/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.OverseaPayBody;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.OverseaPayRequest;
import com.kingdee.bos.ebservice.OverseaPayResponse;
import com.kingdee.bos.ebservice.QueryOverseaPayRequest;
import com.kingdee.bos.ebservice.QueryOverseaPayRequestBody;
import com.kingdee.bos.ebservice.QueryOverseaPayResponse;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBPayServiceUtil;
import com.kingdee.eas.fm.be.app.service.OverSeaBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class EBPayOverseaPayOpUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(EBPayOverseaPayOpUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;
    private EBPayServiceUtil service;
    private Context ctx;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public EBPayOverseaPayOpUtil() {
    }

    public EBPayOverseaPayOpUtil(Context ctx) throws EASBizException {
        this.ctx = ctx;
        try {
            this.service = new EBPayServiceUtil(ctx);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    public OverseaPayDetail[] overseaPay(Context ctx, OverSeaBizInfo bizInfo, OverseaPayBody body) throws RemoteException, EASBizException, ServiceException, BOSException {
        this.service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBPayServiceUtil(ctx) : new EBPayServiceUtil(ctx, bizInfo);
        OverseaPayResponse payResponse = this.service.overseaPay(this.overseaPayRequest(ctx, bizInfo, body));
        OverseaPayBody overseaPayBody = payResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)overseaPayBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, payResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, payResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return overseaPayBody.getDetails();
        }
        if (payResponse.getException() != null && payResponse.getException().getErrorCode() != null && payResponse.getException().getErrorCode().equalsIgnoreCase("pre")) {
            logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + payResponse.getException().getMessage() + "********"));
            throw new BEException(BEException.COMMON, new Object[]{payResponse.getException().getMessage()});
        }
        if (payResponse.getException() != null && payResponse.getException().getMessage().startsWith("\u4f7f\u7528\u4e86\u94f6\u4f01\u4e2d\u95f4\u4ef6\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7")) {
            logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + payResponse.getException().getMessage() + "********"));
            throw new BEException(BEException.COMMON, new Object[]{payResponse.getException().getMessage()});
        }
        logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + payResponse.getException().getMessage() + "********"));
        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{payResponse.getException().getMessage()});
    }

    public OverseaPayDetail[] queryOverseaPay(Context ctx, OverSeaBizInfo bizInfo, QueryOverseaPayRequestBody body) throws RemoteException, EASBizException, ServiceException, BOSException {
        this.service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBPayServiceUtil(ctx) : new EBPayServiceUtil(ctx, bizInfo);
        QueryOverseaPayResponse overseaPayResponse = this.service.queryOverseaPay(this.queryOverseaPayRequest(ctx, bizInfo, body));
        OverseaPayBody resultBody = overseaPayResponse.getBody();
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, overseaPayResponse);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (resultBody != null) {
            return resultBody.getDetails();
        }
        EBException excetion = overseaPayResponse.getException();
        throw new EBGException(EBGException.QUERYPAYERR, new Object[]{excetion.getMessage()});
    }

    private QueryOverseaPayRequest queryOverseaPayRequest(Context ctx, OverSeaBizInfo bizInfo, QueryOverseaPayRequestBody body) {
        QueryOverseaPayRequest queryOverseaPayRequest = new QueryOverseaPayRequest();
        String operationName = "queryOverseaPay";
        queryOverseaPayRequest.setHeader(this.parseHeader(ctx, bizInfo, operationName));
        queryOverseaPayRequest.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, queryOverseaPayRequest);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, queryOverseaPayRequest);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return queryOverseaPayRequest;
    }

    private OverseaPayRequest overseaPayRequest(Context ctx, OverSeaBizInfo bizInfo, OverseaPayBody body) {
        OverseaPayRequest request = new OverseaPayRequest();
        String operationName = "overseaPay";
        request.setHeader(this.parseHeader(ctx, bizInfo, operationName));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    private EBHeader parseHeader(Context ctx, OverSeaBizInfo bizInfo, String operationName) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("overseaPay");
        header.setSubBizType(bizInfo.getTransType());
        header.setOperationName(operationName);
        header.setAccNo(bizInfo.getBankAcct());
        header.setCurrency(bizInfo.getCurrency());
        return header;
    }
}

