/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.QueryReceiptRequest;
import com.kingdee.bos.ebservice.QueryReceiptRequestBody;
import com.kingdee.bos.ebservice.QueryReceiptResponse;
import com.kingdee.bos.ebservice.QueryReceiptResponseBody;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class EReceiptEBGServiceUtil {
    private EBGServiceUtil eBGServiceUtil = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.EReceiptEBGServiceUtil");

    public QueryReceiptResponseBody getReceiptResponseBody(Context ctx, String bankAccountNumber, Date bizDate, String currency) throws BOSException, EASBizException {
        EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
        String transDate = this.sdf.format(bizDate);
        String commonLogMsg = "\u67e5\u8be2\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + " \u65e5\u671f\uff1a" + transDate + " \u7684\u7535\u5b50\u56de\u5355";
        logger.error((Object)("\u5f00\u59cb\u8fde\u63a5\u94f6\u4f01\uff0c" + commonLogMsg));
        if (this.eBGServiceUtil == null) {
            try {
                BankBizInfo bizInfo = new BankBizInfo();
                bizInfo.setBankAcct(bankAccountNumber);
                this.eBGServiceUtil = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
            }
            catch (ServiceException e) {
                String exMsg = "\u8fde\u63a5\u94f6\u4f01\u5f02\u5e38\uff0c" + commonLogMsg + "  \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                logger.error((Object)exMsg);
                eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u3010\u8fde\u63a5\u94f6\u4f01\u5e73\u53f0\u5931\u8d25\uff01\u3011 \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u786e\u8ba4\u94f6\u4f01\u5e73\u53f0\u662f\u5426\u8fde\u901a  \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", eReceiptLogUtils.getStackTrace(e), EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
                e.printStackTrace();
                throw new BEException(null);
            }
        }
        QueryReceiptRequest request = new QueryReceiptRequest();
        request.setHeader(this.parseHeader(ctx, bankAccountNumber, currency));
        request.setBody(this.parseBody(transDate, transDate));
        QueryReceiptResponse queryReceiptResponse = null;
        try {
            queryReceiptResponse = this.eBGServiceUtil.queryReceipt(request);
        }
        catch (RemoteException e1) {
            String exMsg = "\u94f6\u4f01\u5e73\u53f0\u67e5\u8be2\u7535\u5b50\u56de\u5355\u5f02\u5e38\uff01" + commonLogMsg + " \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e1.getMessage();
            logger.error((Object)exMsg);
            eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u67e5\u8be2\u7535\u5b50\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e1.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", eReceiptLogUtils.getStackTrace(e1), EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
            e1.printStackTrace();
            throw new BEException(null);
        }
        QueryReceiptResponseBody queryReceiptResponseBody = queryReceiptResponse.getBody();
        EBException exception = queryReceiptResponse.getException();
        String exMsg = null;
        if (exception != null) {
            exMsg = "\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + exception.getMessage() + commonLogMsg;
            logger.error((Object)exMsg);
            eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + exception.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exception.getMessage(), EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody == null) {
            exMsg = "\u94f6\u4f01\u8fd4\u56dequeryReceiptResponse.getBody() \u4e3anull\uff0c" + commonLogMsg;
            logger.error((Object)exMsg);
            eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u94f6\u4f01\u8fd4\u56dequeryReceiptResponse.getBody() \u4e3anull", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exMsg, EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody.getCompleted() == null || !queryReceiptResponseBody.getCompleted().equals("1")) {
            logger.error((Object)(commonLogMsg + " \u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d"));
            eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d !", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", "\u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d !", EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody.getReceiptInfos() == null) {
            exMsg = "\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReceiptInfos() \u4e3a null " + commonLogMsg;
            logger.error((Object)exMsg);
            eReceiptLogUtils.saveReceiptLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReceiptInfos() \u4e3a null", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exMsg, EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
            throw new BEException(null);
        }
        return queryReceiptResponseBody;
    }

    protected QueryReceiptRequestBody parseBody(String startDate, String endDate) {
        QueryReceiptRequestBody body = new QueryReceiptRequestBody();
        body.setStartDate(startDate);
        body.setEndDate(endDate);
        return body;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct, String currency) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        EBHeader header = new EBHeader();
        header.setClientName("EAS$" + ctx.getAIS());
        header.setClientVersion("EAS7.0");
        header.setCurrency("CNY");
        header.setRequestTime(format.format(new Date()));
        header.setBizType("queryReceipt");
        header.setSubBizType("queryReceipt");
        header.setOperationName("queryReceipt");
        header.setCurrency(currency);
        header.setAccNo(BankAcct);
        return header;
    }
}

