/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.QueryReceiptResponseBody;
import com.kingdee.bos.ebservice.ReceiptInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.AbstractTransDetailInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.EReceiptStorageSettingCollection;
import com.kingdee.eas.fm.be.EReceiptStorageSettingFactory;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.EreceiptAccountBankListCollection;
import com.kingdee.eas.fm.be.EreceiptAccountBankListInfo;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.app.EReceiptCloundDriveUtils;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.EreceiptAccountBankListDBUtils;
import com.kingdee.eas.fm.be.app.service.EReceiptEBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.EReceiptJDBC;
import com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EReceiptService {
    private EReceiptEBGServiceUtil eReceiptEBGServiceUtil = new EReceiptEBGServiceUtil();
    protected EReceiptDBUtils eReceiptDBUtils = new EReceiptDBUtils();
    private EreceiptAccountBankListDBUtils eAccBankListDBUtils = new EreceiptAccountBankListDBUtils();
    private EReceiptCloundDriveUtils eReceiptCloundDriveUtils = new EReceiptCloundDriveUtils();
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.EReceiptService");
    private static final String resourcePath = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public int downLoadEReceipts(Context ctx, String fbankAccountNumber, String startDate, String endDate, StringBuffer msg) throws EASBizException, BOSException {
        return this.downLoadEReceipts(ctx, fbankAccountNumber, startDate, endDate, msg, true);
    }

    public int downLoadEReceipts(Context ctx, String fbankAccountNumber, String startDate, String endDate, StringBuffer msg, boolean isTrasactionDown) throws EASBizException, BOSException {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int total = 0;
        try {
            start.setTime(this.sdf.parse(startDate));
            end.setTime(this.sdf.parse(endDate));
            end.add(5, 1);
            while (start.before(end)) {
                String downEReceiptMsg = "\u4e0b\u8f7d\u94f6\u884c\u8d26\u6237\uff1a" + fbankAccountNumber + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.sdf.format(start.getTime()) + " \u7684\u7535\u5b50\u56de\u5355";
                logger.error((Object)downEReceiptMsg);
                int count = EReceiptFactory.getLocalInstance(ctx).downLoadEReceiptsByBankNumberAndDate(fbankAccountNumber, start.getTime(), isTrasactionDown, msg);
                start.add(5, 1);
                total += count;
            }
            String downEreceiptNumMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + startDate + "\u81f3" + endDate + "\u5171\u4e0b\u8f7d\u5230\u7535\u5b50\u56de\u5355\uff1a" + total + " \u6761";
            logger.error((Object)downEreceiptNumMsg);
        }
        catch (Exception e) {
            String commonMsg = "\u94f6\u884c\u8d26\u53f7\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + startDate + "\u81f3" + endDate + "\u4e0b\u8f7d\u5f02\u5e38";
            logger.error((Object)commonMsg, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return total;
    }

    public CoreBaseCollection getEReceiptCollectionByResponse(Context ctx, QueryReceiptResponseBody responseBody, String fbankAccountNumber, Date date, StringBuffer msg, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        EReceiptStorageSettingCollection StorageColls = EReceiptStorageSettingFactory.getLocalInstance(ctx).getEReceiptStorageSettingCollection(View);
        EReceiptStorageSettingInfo StorageInfo = StorageColls.get(0);
        String transDate = this.sdf.format(date);
        CoreBaseCollection eReceiptInfoCollection = new CoreBaseCollection();
        ReceiptInfo[] receiptInfos = responseBody.getReceiptInfos();
        logger.error((Object)("\u94f6\u884c\u8d26\u6237\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + transDate + "\u83b7\u53d6\u5230\u54cd\u5e94\u4e2d\u7684\u56de\u5355\u6570\u4e3a\uff1a" + receiptInfos.length));
        logger.error((Object)("\u94f6\u884c\u8d26\u6237\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + transDate + "\u83b7\u53d6\u5230\u7684\u56de\u5355\u4fe1\u606f\u5982\u4e0b\uff1a"));
        for (int i = 0; i < receiptInfos.length; ++i) {
            AccountBankCollection collection;
            Object[] reserveds;
            ReceiptInfo receiptInfo = receiptInfos[i];
            StringBuilder receiptInfoBuilder = new StringBuilder();
            receiptInfoBuilder.append("\u7535\u5b50\u56de\u5355\u3010" + i + "\u3011\r\n");
            receiptInfoBuilder.append("\u662f\u5426\u6587\u4ef6:" + receiptInfo.getFileFlag() + " detailNO\uff1a" + receiptInfo.getDetailNo() + " \u7528\u9014:" + receiptInfo.getUseCn());
            receiptInfoBuilder.append("\u6d41\u6c34\u53f7:" + receiptInfo.getTranSerialNo() + "\u4ed8\u6b3e\u65b9\u8d26\u53f7\uff1a" + receiptInfo.getPayerAcntNo() + " \u4ed8\u65b9\u8d26\u53f7\u540d\u79f0:" + receiptInfo.getPayerAcntName());
            receiptInfoBuilder.append("\u4ed8\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0:" + receiptInfo.getPayerBankName() + " \u6536\u6b3e\u65b9\u8d26\u53f7: " + receiptInfo.getPayeeAcntNo() + " \u6536\u6b3e\u65b9\u8d26\u53f7\u540d\u79f0: " + receiptInfo.getPayeeAcntName());
            receiptInfoBuilder.append("\u6587\u4ef6\u8def\u5f84\uff1a" + receiptInfo.getFilePath() + " \u6536\u6b3e\u94f6\u884c:" + receiptInfo.getPayeeBankName() + " \u4ea4\u6613\u65e5\u671f\uff1a" + receiptInfo.getTransDate());
            receiptInfoBuilder.append("\u9a8c\u8bc1\u7801\uff1a" + receiptInfo.getEbillKey());
            logger.error((Object)receiptInfoBuilder.toString());
            String fileFlag = receiptInfo.getFileFlag();
            byte[] fileValue = null;
            EReceiptInfo eReceiptInfo = new EReceiptInfo();
            eReceiptInfo.setId(BOSUuid.create((BOSObjectType)eReceiptInfo.getBOSType()));
            eReceiptInfo.setCurrency(currencyInfo);
            if (receiptInfo.getDetailNo() == null || receiptInfo.getDetailNo().equals("")) {
                msg.append("\u94f6\u884c\u8d26\u53f7" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f" + transDate + ";\u94f6\u4f01\u63a5\u53e3\u8fd4\u56de\u7535\u5b50\u56de\u5355\u6570\u636e\u4e2d\u4ea4\u6613\u660e\u7ec6\u5173\u8054\u6807\u8bb0(DetailNo)\u4e3a\u7a7a\r\n");
                String exMsg = FMHelper.formatMessage((Context)ctx, (String)resourcePath, (String)"DetailNoIsNull", (Object[])new String[]{fbankAccountNumber, transDate});
                this.eReceiptLogUtils.saveReceiptLog(ctx, fbankAccountNumber, date, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"953_EReceiptService", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"954_EReceiptService", (Locale)ctx.getLocale()), exMsg, EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
                throw new BEException(null);
            }
            String detailNo = receiptInfo.getDetailNo();
            EReceiptCollection coll = this.eReceiptDBUtils.getEReceiptCollectionByDetailNoAndAccNumber(ctx, detailNo, fbankAccountNumber, date);
            if (coll.size() > 0) continue;
            eReceiptInfo.setFileFlag(receiptInfo.getFileFlag());
            eReceiptInfo.setUse(receiptInfo.getUseCn());
            eReceiptInfo.setSerialNo(receiptInfo.getTranSerialNo());
            eReceiptInfo.setPayerAcntNo(receiptInfo.getPayerAcntNo());
            eReceiptInfo.setPayerAcntName(receiptInfo.getPayerAcntName());
            eReceiptInfo.setPayerBankName(receiptInfo.getPayerBankName());
            eReceiptInfo.setPayeeAcntNo(receiptInfo.getPayeeAcntNo());
            eReceiptInfo.setPayeeAcntName(receiptInfo.getPayeeAcntName());
            eReceiptInfo.setPayeeBankName(receiptInfo.getPayeeBankName());
            eReceiptInfo.setDetailNo(detailNo);
            eReceiptInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
            eReceiptInfo.setCreator(currentUser);
            eReceiptInfo.setValidCode(receiptInfo.getEbillKey());
            eReceiptInfo.setFilePath(receiptInfo.getFilePath());
            eReceiptInfo.setIsMatch(EReceiptIsMatchEnum.UnMatch);
            try {
                eReceiptInfo.setTransDate(this.sdf.parse(receiptInfo.getTransDate()));
            }
            catch (ParseException e) {
                logger.error((Object)("\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a\u8fd4\u56de\u7684\u56de\u5355\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + receiptInfo.getTransDate()));
                e.printStackTrace();
            }
            eReceiptInfo.setTranSerialNo(receiptInfo.getTranSerialNo());
            eReceiptInfo.setEbillSerialno(receiptInfo.getEbillSerialno());
            eReceiptInfo.setIsInnerEReceipt(false);
            eReceiptInfo.setTransNetCode(receiptInfo.getTransNetCode());
            eReceiptInfo.setTransTellno(receiptInfo.getTransTellno());
            eReceiptInfo.setBusiType(receiptInfo.getBusiType());
            eReceiptInfo.setTimestamp(receiptInfo.getTimeStamp());
            eReceiptInfo.setExplanation(receiptInfo.getExplanation());
            try {
                String str = receiptInfo.getDetailDateTime();
                if (!EmptyUtil.isEmpty((String)str)) {
                    String detailDateTime = str.substring(0, 8);
                    eReceiptInfo.setDetailDateTime(this.sdf.parse(detailDateTime));
                }
            }
            catch (ParseException e) {
                logger.error((Object)("\u59d4\u6258\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a\u8fd4\u56de\u7684\u56de\u5355\u59d4\u6258\u65e5\u671f\u4e3a\uff1a" + receiptInfo.getDetailDateTime()));
                e.printStackTrace();
            }
            if (fileFlag.equals("0")) {
                eReceiptInfo.setFileName(detailNo + ".pdf");
                eReceiptInfo.setFileValue(fileValue);
            } else if (fileFlag.equals("1")) {
                int one = receiptInfo.getFilePath().lastIndexOf("/");
                String fileName = receiptInfo.getFilePath().substring(one + 1, receiptInfo.getFilePath().length());
                eReceiptInfo.setFileName(fileName);
                if (!EmptyUtil.isEmpty((String)fileName) && fileName.endsWith("ofd") && fileName.contains("issuer")) {
                    int beginIndex = fileName.indexOf("issuer");
                    int endIndex = fileName.indexOf(46);
                    String validCode = fileName.substring(beginIndex + 7, endIndex);
                    eReceiptInfo.setValidCode(validCode);
                }
                eReceiptInfo.setFileValue(fileValue);
                logger.error((Object)("\u4e0b\u8f7dPDF\u7684\u8fdc\u7a0b\u8fde\u63a5\u4fe1\u606f\uff1aIP:" + responseBody.getIp() + " proxy:" + responseBody.getProxy()));
                if (responseBody.getIp() != null && responseBody.getPassword() != null && responseBody.getUsername() != null && responseBody.getProxy() != null) {
                    eReceiptInfo.setIp(responseBody.getIp());
                    eReceiptInfo.setPort(responseBody.getPort());
                    eReceiptInfo.setProxy(responseBody.getProxy());
                    eReceiptInfo.setPassword(responseBody.getPassword());
                    eReceiptInfo.setUsername(responseBody.getUsername());
                } else {
                    msg.append("\u94f6\u884c\u8d26\u53f7" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f" + transDate + ";\u94f6\u4f01\u63a5\u53e3\u7535\u5b50\u56de\u5355\u4e0b\u8f7d,\u7535\u5b50\u56de\u5355\u4e3a\u6587\u4ef6\u683c\u5f0f\uff0c\u4f46\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\r\n");
                    this.eReceiptLogUtils.saveReceiptLog(ctx, fbankAccountNumber, date, ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"957_EReceiptService", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"954_EReceiptService", (Locale)ctx.getLocale()), msg.toString(), EReceiptLogTypeEnum.DOWNERECEIPT, LevelEnum.ERROR);
                    throw new BEException(null);
                }
            }
            eReceiptInfo.setRemark(receiptInfo.getRemark());
            String reserved = receiptInfo.getReserved1();
            if (!EmptyUtil.isEmpty((String)reserved) && !EmptyUtil.isEmpty((Object[])(reserveds = reserved.split(";")))) {
                for (int m = 0; m < reserveds.length; ++m) {
                    String returnValue = ((String)reserveds[m]).trim();
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("proBusiType=".toUpperCase(Locale.ENGLISH))) {
                        eReceiptInfo.setProBusiType(returnValue.substring("proBusiType=".length()));
                    }
                    if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("messageType=".toUpperCase(Locale.ENGLISH))) continue;
                    eReceiptInfo.setMessageType(returnValue.substring("messageType=".length()));
                }
            }
            if ((collection = this.getAccountBankCollectionByAccNum(ctx, fbankAccountNumber)).size() != 0) {
                AccountBankInfo accountBankInfo = collection.get(0);
                if (collection.size() > 1) {
                    Iterator it = collection.iterator();
                    while (it.hasNext() && (SharedAcctType.userd == (accountBankInfo = (AccountBankInfo)it.next()).getShareType() || SharedAcctType.shared != accountBankInfo.getShareType())) {
                    }
                }
                eReceiptInfo.setBankAccount(accountBankInfo);
                eReceiptInfo.setCompany(accountBankInfo.getCompany());
                if (StorageInfo.getStorageType().getValue() == 3) {
                    String localPath = null;
                    String bankAccountId = accountBankInfo.getBankInterFaceID();
                    SimpleDateFormat y = new SimpleDateFormat("yyyy");
                    String eRYear = y.format(eReceiptInfo.getTransDate());
                    SimpleDateFormat m = new SimpleDateFormat("MM");
                    String eRMonth = m.format(eReceiptInfo.getTransDate());
                    SimpleDateFormat d = new SimpleDateFormat("dd");
                    String eRDay = d.format(eReceiptInfo.getTransDate());
                    localPath = StorageInfo.isUseMapping() ? StorageInfo.getMappingFinalPath() + bankAccountId + "/" + eRYear + "/" + eRMonth + "/" + eRDay : StorageInfo.getLocalPath() + "/" + bankAccountId + "/" + eRYear + "/" + eRMonth + "/" + eRDay;
                    eReceiptInfo.setReceiptStampPath(localPath);
                }
                if (EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCompany())) {
                    eReceiptInfo.setCurrency(accountBankInfo.getCompany().getBaseCurrency());
                }
            }
            eReceiptInfo.setBankNumber(fbankAccountNumber);
            eReceiptInfo.setFileSource("3");
            EReceiptCollection colls = this.eReceiptDBUtils.getEReceiptCollectionByDetailNoAndAccNumber(ctx, eReceiptInfo.getDetailNo(), eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate());
            if (colls != null && colls.size() != 0) continue;
            eReceiptInfoCollection.add((CoreBaseInfo)eReceiptInfo);
        }
        return eReceiptInfoCollection;
    }

    public void updateEreceiptAccBankListByAccNum(Context ctx, String fBankAccountNumber, Date transDate) throws BOSException, EASBizException {
        EreceiptAccountBankListCollection collection = this.eAccBankListDBUtils.getEreceiptAccountBankListCollection(ctx, fBankAccountNumber);
        EreceiptAccountBankListInfo info = null;
        if (collection == null || collection.size() <= 0) {
            String noEreceiptAccountBankListMsg = "\u6ca1\u6709\u67e5\u8be2\u5230\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + "\u7684\u7535\u5b50\u56de\u5355\u6267\u884c\u8bb0\u5f55\uff0c\u4e0d\u80fd\u66f4\u65b0\u7535\u5b50\u56de\u5355\u4ea4\u6613\u65e5\u671f";
            logger.error((Object)noEreceiptAccountBankListMsg);
            throw new BOSException(noEreceiptAccountBankListMsg);
        }
        info = collection.get(0);
        info.setTransDate(transDate);
        logger.error((Object)("\u66f4\u65b0\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + " \u7684\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + info.getTransDate() + "\tStart"));
        this.eAccBankListDBUtils.insertEreceiptAccountBankInfo(ctx, info);
        logger.error((Object)("\u66f4\u65b0\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + " \u7684\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + info.getTransDate() + "\tEnd"));
    }

    private AccountBankCollection getAccountBankCollectionByAccNum(Context ctx, String fbankAccountNumber) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("company.*"));
        selectorItemCollection.add(new SelectorItemInfo("bank.*"));
        selectorItemCollection.add(new SelectorItemInfo("shareAcct.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)fbankAccountNumber, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        AccountBankCollection collection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(entityViewInfo);
        return collection;
    }

    public void savePDFValues(Context ctx, EReceiptInfo eReceiptInfo, Connection conn) throws BOSException {
        block6: {
            try {
                StorageSettingInstance storageSetting = StorageSettingInstance.getInstance(ctx);
                EntityViewInfo View = new EntityViewInfo();
                SelectorItemCollection Sic = new SelectorItemCollection();
                Sic.add(new SelectorItemInfo("*"));
                View.setSelector(Sic);
                EReceiptStorageSettingCollection colls = EReceiptStorageSettingFactory.getLocalInstance(ctx).getEReceiptStorageSettingCollection(View);
                EReceiptStorageSettingInfo info = colls.get(0);
                if (storageSetting != null) {
                    int storageType = storageSetting.getStorageSettingInfo().getStorageType().getValue();
                    if (storageType == 0) {
                        this.eReceiptDBUtils.insertEReceiptPDFToDB(ctx, eReceiptInfo, info);
                        this.eReceiptDBUtils.updateEASEreceiptPDF(ctx, eReceiptInfo, conn);
                    } else if (storageType == 3) {
                        this.eReceiptDBUtils.insertEReceiptPDFToLocal(ctx, eReceiptInfo, info);
                        this.eReceiptDBUtils.updateEASEreceiptPDF(ctx, eReceiptInfo, conn);
                    }
                    break block6;
                }
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"744_EReceiptControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"962_EReceiptService", (Locale)ctx.getLocale()), null, EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"744_EReceiptControllerBean", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"962_EReceiptService", (Locale)ctx.getLocale())});
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateEReceiptPayBankName(Context ctx, EReceiptCollection eReceiptInfoCollection, HashMap<String, TransDetailCollection> transDetailMap, Connection conn) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u66f4\u65b0 \u3010\u534e\u590f\u94f6\u884c\u3011 \u7535\u5b50\u56de\u5355\u7684  \u6536\u6b3e\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0  \u548c  \u6536\u6b3e\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0     \u3010\u5174\u4e1a\u94f6\u884c\u3011\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0   \uff0c \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0  \uff0c\u6536\u6b3e\u8d26\u53f7\u540d\u79f0  \uff0c\u6536\u6b3e\u5f00\u6237\u884c");
        try {
            for (int i = 0; i < eReceiptInfoCollection.size(); ++i) {
                String msg;
                EReceiptInfo eReceiptInfo = eReceiptInfoCollection.get(i);
                String exMsg = " \u7535\u5b50\u56de\u5355id\uff1a" + eReceiptInfo.getId() + "  \u94f6\u884c\u8d26\u53f7\uff1a" + eReceiptInfo.getBankNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.sdf.format(eReceiptInfo.getTransDate()) + "  DetailNo: " + eReceiptInfo.getDetailNo();
                logger.error((Object)("\u7b2c\u3010" + i + "\u3011\u6761  " + exMsg));
                String bankInterFace = null;
                AccountBankInfo accBankInfo = eReceiptInfo.getBankAccount();
                if (accBankInfo == null) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"968_EReceiptService", (Locale)ctx.getLocale()) + exMsg;
                    logger.error((Object)exMsg);
                    throw new BOSException(msg);
                }
                bankInterFace = accBankInfo.getBankInterFace();
                if (bankInterFace == null || !bankInterFace.contains("\u534e\u590f\u94f6\u884c") && !bankInterFace.contains("\u5174\u4e1a\u94f6\u884c")) {
                    msg = "\u8be5\u94f6\u884c\u8d26\u6237\u975e  \u534e\u590f\u548c\u5174\u4e1a\u94f6\u884c \u8d26\u6237\uff0c\u4e0d\u9700\u8981\u5904\u7406" + exMsg;
                    logger.error((Object)(msg + exMsg));
                    break;
                }
                if (eReceiptInfo.getIsMatch() == EReceiptIsMatchEnum.AutoMatic) {
                    EntityViewInfo accBankView = new EntityViewInfo();
                    SelectorItemCollection accBankSic = new SelectorItemCollection();
                    accBankSic.add(new SelectorItemInfo("*"));
                    accBankSic.add(new SelectorItemInfo("bank.*"));
                    accBankView.setSelector(accBankSic);
                    FilterInfo accBankFilter = new FilterInfo();
                    accBankFilter.getFilterItems().add(new FilterItemInfo("id", (Object)accBankInfo.getId(), CompareType.EQUALS));
                    accBankView.setFilter(accBankFilter);
                    AccountBankCollection accBankColls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(accBankView);
                    accBankInfo = accBankColls.get(0);
                    logger.error((Object)("\u94f6\u884c\u63a5\u53e3\u4fe1\u606f\u4e3a:" + accBankInfo.getBankInterFace()));
                    if (bankInterFace == null || !bankInterFace.contains("\u534e\u590f\u94f6\u884c") && !bankInterFace.contains("\u5174\u4e1a\u94f6\u884c")) continue;
                    logger.error((Object)"\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6");
                    if (transDetailMap.get(eReceiptInfo.getDetailNo()) != null) {
                        String msg2;
                        TransDetailCollection transColls = transDetailMap.get(eReceiptInfo.getDetailNo());
                        AbstractTransDetailInfo transDetailInfo = null;
                        for (int m = 0; m < transColls.size(); ++m) {
                            if (!transColls.get(m).getId().toString().equals(eReceiptInfo.getTransDetailId())) continue;
                            transDetailInfo = transColls.get(m);
                            break;
                        }
                        String oppBank = transDetailInfo.getOppBank();
                        String bankName = accBankInfo.getBank().getName();
                        String oppUnit = transDetailInfo.getOppUnit();
                        String accName = accBankInfo.getAcctName();
                        logger.error((Object)("\u5bf9\u65b9\u94f6\u884c\u4e3a\uff1a" + oppBank + "  \u672c\u65b9\u8d26\u6237\u91d1\u878d\u673a\u6784\uff1a" + bankName + "  \u5bf9\u65b9\u5355\u4f4d\uff1a" + oppUnit + "  \u8d26\u53f7\u540d\u79f0:" + accName));
                        String logMsg = "\u7535\u5b50\u56de\u5355id\uff1a" + eReceiptInfo.getId() + "  \u94f6\u884c\u8d26\u53f7\uff1a" + eReceiptInfo.getBankNumber() + "  \u4ea4\u6613\u65e5\u671f\uff1a" + this.sdf.format(eReceiptInfo.getTransDate()) + " DetailNo: " + eReceiptInfo.getDetailNo();
                        if (transDetailInfo.getDebitAmount() != null && transDetailInfo.getDebitAmount().compareTo(Constants.ZERO) != 0) {
                            msg2 = "";
                            if (bankInterFace.contains("\u534e\u590f\u94f6\u884c")) {
                                msg2 = "\u66f4\u65b0\u534e\u590f\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u65b9\u94f6\u884c\u5f00\u6237\u884c\u540d\u79f0\uff1a" + bankName + "   \u6536\u6b3e\u65b9\u94f6\u884c\u5f00\u6237\u884c\u540d\u79f0\uff1a " + oppBank;
                                logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u534e\u590f\u7535\u5b50\u56de\u5355\uff0c\u6536\u4ed8\u6b3e\u94f6\u884c\u5f00\u6237\u884c\u540d\u79f0");
                                this.eReceiptDBUtils.updateEReceipt(ctx, bankName, oppBank, null, null, eReceiptInfo.getId().toString(), conn);
                                logger.error((Object)("\u66f4\u65b0\u5b8c\u6210\uff1a" + msg2 + logMsg));
                                continue;
                            }
                            if (!bankInterFace.contains("\u5174\u4e1a\u94f6\u884c")) continue;
                            msg2 = "\u66f4\u65b0\u5174\u4e1a\u94f6\u884c\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0\uff1a" + accName + "   \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff1a " + bankName;
                            logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u5174\u4e1a\u94f6\u884c\u3010\u4ed8\u6b3e\u3011\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0   \u548c \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0");
                            this.eReceiptDBUtils.updateEReceipt(ctx, bankName, null, accName, null, eReceiptInfo.getId().toString(), conn);
                            logger.error((Object)("\u66f4\u65b0\u5b8c\u6210\uff1a" + msg2 + logMsg));
                            continue;
                        }
                        if (transDetailInfo.getCreditAmount() == null || transDetailInfo.getCreditAmount().compareTo(Constants.ZERO) == 0) continue;
                        msg2 = "";
                        if (bankInterFace.contains("\u534e\u590f\u94f6\u884c")) {
                            msg2 = "\u66f4\u65b0\u534e\u590f\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u65b9\u94f6\u884c\u5f00\u6237\u884c\u540d\u79f0\uff1a" + oppBank + "   \u6536\u6b3e\u65b9\u94f6\u884c\u540d\u79f0\uff1a " + bankName;
                            logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u534e\u590f\u7535\u5b50\u56de\u5355\uff0c\u6536\u4ed8\u6b3e\u94f6\u884c\u5f00\u6237\u884c\u540d\u79f0");
                            this.eReceiptDBUtils.updateEReceipt(ctx, oppBank, bankName, null, null, eReceiptInfo.getId().toString(), conn);
                            logger.error((Object)("\u66f4\u65b0\u5b8c\u6210\uff1a" + msg2 + logMsg));
                            continue;
                        }
                        if (!bankInterFace.contains("\u5174\u4e1a\u94f6\u884c")) continue;
                        msg2 = "\u66f4\u65b0\u5174\u4e1a\u94f6\u884c\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0\uff1a" + oppUnit + "   \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff1a " + oppBank + "  \u6536\u6b3e\u8d26\u53f7\u540d\u79f0\u4e3a\uff1a" + accName + " \u6536\u6b3e\u5f00\u6237\u94f6\u884c\u540d\u79f0\uff1a" + bankName;
                        logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u5174\u4e1a\u94f6\u884c\u3010\u6536\u6b3e\u3011\u7535\u5b50\u56de\u5355\uff0c\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0   \u548c \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0 \uff0c\u6536\u6b3e\u8d26\u53f7\u540d\u79f0\uff0c\u6536\u6b3e\u5f00\u6237\u884c");
                        this.eReceiptDBUtils.updateEReceipt(ctx, oppBank, bankName, oppUnit, accName, eReceiptInfo.getId().toString(), conn);
                        logger.error((Object)("\u66f4\u65b0\u5b8c\u6210\uff1a" + msg2 + logMsg));
                        continue;
                    }
                    logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u4ea4\u6613\u660e\u7ec6\uff01\uff01");
                    continue;
                }
                logger.error((Object)"\u8be5\u7535\u5b50\u56de\u5355\u6ca1\u6709\u4e0e\u4ea4\u6613\u660e\u7ec6\u5339\u914d");
            }
            logger.error((Object)"\u7ed3\u675f\u66f4\u65b0 \u3010\u534e\u590f\u94f6\u884c\u3011 \u7535\u5b50\u56de\u5355\u7684  \u6536\u6b3e\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0  \u548c  \u6536\u6b3e\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0     \u3010\u5174\u4e1a\u94f6\u884c\u3011\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0   \u548c \u4ed8\u6b3e\u94f6\u884c\u540d\u79f0 ");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public byte[] getPDFValues(Context ctx, EReceiptInfo eReceiptInfo) throws BOSException {
        byte[] fileValue = null;
        try {
            StorageSettingInstance storageSetting = StorageSettingInstance.getInstance(ctx);
            EReceiptStorageSettingInfo eReceiptStorageSettingInfo = storageSetting.getStorageSettingInfo();
            if (eReceiptStorageSettingInfo == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"744_EReceiptControllerBean", (Locale)ctx.getLocale()));
            }
            if (!eReceiptInfo.getFileSource().equals("3")) {
                String fileSource = eReceiptInfo.getFileSource();
                if (fileSource.equals("0")) {
                    logger.error((Object)"\u7535\u5b50\u56de\u5355\u6570\u636e 0\u4e3a\u6570\u636e\u5b58\u5728EAS\u672c\u5730\u5e93 ");
                    fileValue = eReceiptInfo.getFileValue();
                    logger.error((Object)"\u7535\u5b50\u56de\u5355\u6570\u636e 0\u4e3a\u6570\u636e\u5b58\u5728EAS\u672c\u5730\u5e93 \u8fd4\u56de\u7ed3\u679c  ");
                } else if (fileSource.equals("1")) {
                    EReceiptJDBC eReceiptJDBCTool = new EReceiptJDBC();
                    logger.error((Object)"\u7535\u5b50\u56de\u5355\u6570\u636e 1\u4e3a\u6570\u636e\u5b58\u653e\u5728PDF\u6570\u636e\u5e93\u4e2d  ");
                    fileValue = eReceiptJDBCTool.getEReceiptPDFValues(eReceiptInfo.getId().toString(), CompareType.EQUALS, eReceiptStorageSettingInfo);
                    logger.error((Object)"\u7535\u5b50\u56de\u5355\u53d6\u6570\u636e 0\u4e3a\u6570\u636e\u5b58\u653e\u5728PDFl\u6570\u636e\u5e93\u4e2d  \u8fd4\u56de\u7ed3\u679c \u5b8c\u6210  ");
                } else if (fileSource.equals("2")) {
                    logger.error((Object)"\u7535\u5b50\u56de\u5355\u6570\u636e 2\u4e3a\u6570\u636e\u5b58\u653e\u5728\u91d1\u8776\u4e91\u76d8  ");
                    fileValue = KingDeeCloundDriveApiUtils.getFileValue(eReceiptInfo.getFileId(), storageSetting.getOrgAccessToken(), eReceiptStorageSettingInfo.getDriveUserId());
                    logger.error((Object)("\u4e91\u76d8\u8fd4\u56de\u7535\u5b50\u56de\u5355PDF\u6d41  \u5b8c\u6210 ,\u83b7\u53d6\u5230PDF\u5927\u5c0f\u4e3a\uff1a " + fileValue.length));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return fileValue;
    }

    public boolean isExsitTransDetail(Context ctx, String bankNumber, Date transDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.bankAccountNumber", (Object)bankNumber));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(transDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(DateUtil.getNextDay((Date)transDate)), CompareType.LESS));
        view.setFilter(filter);
        TransDetailCollection transColls = TransDetailFactory.getLocalInstance(ctx).getTransDetailCollection(view);
        return transColls != null && transColls.size() > 0;
    }

    public Date getNowTime() {
        return new Date();
    }
}

