/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.QueryReceiptResponseBody;
import com.kingdee.bos.ebservice.ReceiptInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.DebitStatusEnum;
import com.kingdee.eas.fm.be.ElStatementBillAccountBankListCollection;
import com.kingdee.eas.fm.be.ElStatementBillAccountBankListInfo;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillEntryInfo;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.be.app.ElStatementBillAccountBankListDBUtils;
import com.kingdee.eas.fm.be.app.service.ElStatementDBUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ElStatementBillService {
    private ElStatementDBUtils elStatementUtils = new ElStatementDBUtils();
    protected EReceiptDBUtils eReceiptDBUtils = new EReceiptDBUtils();
    private ElStatementBillAccountBankListDBUtils elStatementBillAccBankListUtil = new ElStatementBillAccountBankListDBUtils();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.EReceiptService");
    private SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat dfts = new SimpleDateFormat("yyyyMMdd");

    public ElStatementBillInfo parseElStatementInfoByResponse(Context ctx, QueryReceiptResponseBody responseBody, String fbankAccountNumber, Date date) throws BOSException, EASBizException {
        ReceiptInfo[] receiptInfos = responseBody.getReceiptInfos();
        Object[] bodyReserveds = responseBody.getReserveds();
        if (bodyReserveds == null || bodyReserveds.length == 0) {
            logger.error((Object)("\u94f6\u884c\u8d26\u6237\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + this.dfts.format(date) + "\u83b7\u53d6\u5230\u54cd\u5e94\u4e2d\u7684body\u4e2d\u7684Reserveds\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5b8c\u6210\u89e3\u6790\uff0c\u9700\u8981\u63d0\u4f9b\u94f6\u4f01\u62a5\u6587\u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u90e8\u95e8\u5206\u6790\uff01"));
            return null;
        }
        logger.error((Object)("\u94f6\u884c\u8d26\u6237\uff1a" + fbankAccountNumber + "\u4ea4\u6613\u65e5\u671f\uff1a" + this.dfts.format(date) + "\u83b7\u53d6\u5230\u54cd\u5e94\u4e2d\u7684\u5bf9\u8d26\u5355\u6570\u4e3a\uff1a" + receiptInfos.length + "\u83b7\u53d6\u5230\u7684\u5bf9\u8d26\u5355\u4fe1\u606f\u5982\u4e0b\uff1a"));
        ElStatementBillInfo elStatementBillInfo = new ElStatementBillInfo();
        elStatementBillInfo.setId(BOSUuid.create((BOSObjectType)elStatementBillInfo.getBOSType()));
        elStatementBillInfo.setTransDate(date);
        AccountBankCollection collection = this.getAccountBankCollectionByAccNum(ctx, fbankAccountNumber);
        if (collection.size() != 0) {
            AccountBankInfo accountBankInfo = collection.get(0);
            if (collection.size() > 1) {
                Iterator it = collection.iterator();
                while (it.hasNext() && (SharedAcctType.userd.equals((Object)(accountBankInfo = (AccountBankInfo)it.next()).getShareType()) || !SharedAcctType.shared.equals((Object)accountBankInfo.getShareType()))) {
                }
            }
            elStatementBillInfo.setBankAccount(accountBankInfo);
            elStatementBillInfo.setBankAcctName(accountBankInfo.getName());
            elStatementBillInfo.setCompany(accountBankInfo.getCompany());
            if (EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCompany())) {
                elStatementBillInfo.setCurrency(accountBankInfo.getCompany().getBaseCurrency());
            }
        }
        elStatementBillInfo.setIp(responseBody.getIp());
        elStatementBillInfo.setPort(responseBody.getPort());
        elStatementBillInfo.setProxy(responseBody.getProxy());
        elStatementBillInfo.setPassword(responseBody.getPassword());
        elStatementBillInfo.setUsername(responseBody.getUsername());
        if (!EmptyUtil.isEmpty((Object[])bodyReserveds)) {
            String elYear = "";
            String elMonth = "";
            for (int m = 0; m < bodyReserveds.length; ++m) {
                String currIsoCode;
                String returnValue = ((String)bodyReserveds[m]).trim();
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("identificationCodeOfIssuer=".toUpperCase(Locale.ENGLISH))) {
                    elStatementBillInfo.setAuthority(returnValue.substring("identificationCodeOfIssuer=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("numberOfBankBranch=".toUpperCase(Locale.ENGLISH))) {
                    elStatementBillInfo.setNetworkSalesNum(returnValue.substring("numberOfBankBranch=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("codeOfBankCustomer=".toUpperCase(Locale.ENGLISH))) {
                    elStatementBillInfo.setBankClientCode(returnValue.substring("codeOfBankCustomer=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("yearOfBankReconciliationStatement=".toUpperCase(Locale.ENGLISH))) {
                    elYear = returnValue.substring("yearOfBankReconciliationStatement=".length());
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("monthOfBankReconciliationStatement=".toUpperCase(Locale.ENGLISH))) {
                    elMonth = returnValue.substring("monthOfBankReconciliationStatement=".length());
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("printTimes=".toUpperCase(Locale.ENGLISH))) {
                    String printCount = returnValue.substring("printTimes=".length());
                    elStatementBillInfo.setPrintCount(EmptyUtil.isEmpty((String)printCount) ? 0 : Integer.parseInt(printCount));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("printDate=".toUpperCase(Locale.ENGLISH))) {
                    try {
                        elStatementBillInfo.setPrintDate(this.dfts.parse(returnValue.substring("printDate=".length())));
                    }
                    catch (ParseException e) {
                        logger.error((Object)("\u6253\u5370\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a\u8fd4\u56de\u7684\u56de\u5355\u6253\u5370\u65e5\u671f\u4e3a\uff1a" + returnValue.substring("printDate=".length())));
                        e.printStackTrace();
                    }
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("currency=".toUpperCase(Locale.ENGLISH)) && !EmptyUtil.isEmpty((String)(currIsoCode = returnValue.substring("currency=".length())))) {
                    EntityViewInfo curview = new EntityViewInfo();
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("isoCode", (Object)currIsoCode));
                    curview.setFilter(fi);
                    CurrencyCollection currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(curview);
                    if (currency.size() > 0) {
                        elStatementBillInfo.setCurrency(currency.get(0));
                    }
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("AccountBalanceAtTheEndOfReconciliationCycleAmount=".toUpperCase(Locale.ENGLISH))) {
                    String endBalance = returnValue.substring("AccountBalanceAtTheEndOfReconciliationCycleAmount=".length());
                    elStatementBillInfo.setEndBalance(EmptyUtil.isEmpty((String)endBalance) ? BigDecimal.ZERO : new BigDecimal(endBalance));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("OverdraftBalanceAtEndOfReconciliationCycle=".toUpperCase(Locale.ENGLISH))) {
                    String endOverdraftBalance = returnValue.substring("OverdraftBalanceAtEndOfReconciliationCycle=".length());
                    elStatementBillInfo.setEndOverdraftAmt(EmptyUtil.isEmpty((String)endOverdraftBalance) ? BigDecimal.ZERO : new BigDecimal(endOverdraftBalance));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("ReserveBalanceAtTheEndOfReconciliationCycle=".toUpperCase(Locale.ENGLISH))) {
                    String endRetainedBalance = returnValue.substring("ReserveBalanceAtTheEndOfReconciliationCycle=".length());
                    elStatementBillInfo.setEndRetainedAmt(EmptyUtil.isEmpty((String)endRetainedBalance) ? BigDecimal.ZERO : new BigDecimal(endRetainedBalance));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("AvailableBalanceAtTheEndOfReconciliationCycleAmount=".toUpperCase(Locale.ENGLISH))) {
                    String endAvailableBalance = returnValue.substring("AvailableBalanceAtTheEndOfReconciliationCycleAmount=".length());
                    elStatementBillInfo.setEndAvailableAmt(EmptyUtil.isEmpty((String)endAvailableBalance) ? BigDecimal.ZERO : new BigDecimal(endAvailableBalance));
                }
                if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("FrozenBalanceAtTheEndOfReconciliationCycle=".toUpperCase(Locale.ENGLISH))) continue;
                String endFrezonBalance = returnValue.substring("FrozenBalanceAtTheEndOfReconciliationCycle=".length());
                elStatementBillInfo.setEndFrezonAmt(EmptyUtil.isEmpty((String)endFrezonBalance) ? BigDecimal.ZERO : new BigDecimal(endFrezonBalance));
            }
            elStatementBillInfo.setPeriod(elYear + elMonth);
        }
        BigDecimal debitAmountTotal = BigDecimal.ZERO;
        BigDecimal creditAmountTotal = BigDecimal.ZERO;
        int debitCount = 0;
        int creditCount = 0;
        String filePathStr = "";
        for (int i = 0; i < receiptInfos.length; ++i) {
            ReceiptInfo receiptInfo = receiptInfos[i];
            if (!EmptyUtil.isEmpty((String)receiptInfo.getFilePath()) && EmptyUtil.isEmpty((String)filePathStr)) {
                filePathStr = receiptInfo.getFilePath();
            }
            ElStatementBillEntryInfo entry = new ElStatementBillEntryInfo();
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setSeq(i + 1);
            StringBuilder receiptInfoBuilder = new StringBuilder();
            receiptInfoBuilder.append("\u7535\u5b50\u5bf9\u8d26\u5355\u3010" + i + "\u3011\r\n");
            receiptInfoBuilder.append("\u5bf9\u8d26\u5355\u552f\u4e00\u6807\u8bc6\u7801:" + receiptInfo.getReserved1() + "\u4ed8\u6b3e\u65b9\u8d26\u53f7\uff1a" + receiptInfo.getPayerAcntNo() + " \u4ed8\u65b9\u8d26\u53f7\u540d\u79f0:" + receiptInfo.getPayerAcntName());
            receiptInfoBuilder.append("\u4ed8\u65b9\u5f00\u6237\u94f6\u884c\u540d\u79f0:" + receiptInfo.getPayerBankName() + " \u6536\u6b3e\u65b9\u8d26\u53f7: " + receiptInfo.getPayeeAcntNo() + " \u6536\u6b3e\u65b9\u8d26\u53f7\u540d\u79f0: " + receiptInfo.getPayeeAcntName());
            receiptInfoBuilder.append("\u6587\u4ef6\u8def\u5f84\uff1a" + receiptInfo.getFilePath() + " \u6536\u6b3e\u94f6\u884c:" + receiptInfo.getPayeeBankName() + " \u4ea4\u6613\u65e5\u671f\uff1a" + receiptInfo.getTransDate());
            receiptInfoBuilder.append("\u9a8c\u8bc1\u7801\uff1a" + receiptInfo.getEbillKey());
            logger.error((Object)receiptInfoBuilder.toString());
            if ("1".equals(receiptInfo.getCreditDebitFlag())) {
                entry.setDebitAmount(new BigDecimal(receiptInfo.getAmount()));
                entry.setCreditAmount(BigDecimal.ZERO);
                debitAmountTotal = debitAmountTotal.add(new BigDecimal(receiptInfo.getAmount()));
                entry.setDebitStatus(DebitStatusEnum.debit);
                ++debitCount;
            } else if ("2".equals(receiptInfo.getCreditDebitFlag())) {
                entry.setCreditAmount(new BigDecimal(receiptInfo.getAmount()));
                entry.setDebitAmount(BigDecimal.ZERO);
                creditAmountTotal = creditAmountTotal.add(new BigDecimal(receiptInfo.getAmount()));
                entry.setDebitStatus(DebitStatusEnum.credit);
                ++creditCount;
            }
            entry.setOppBankName(receiptInfo.getPayeeAcntName());
            entry.setOppBank(receiptInfo.getPayeeBankName());
            entry.setOppBankNumber(receiptInfo.getPayeeAcntNo());
            entry.setDecreption(receiptInfo.getRemark());
            entry.setEreceiptNum(receiptInfo.getEbillSerialno());
            entry.setBizProductType(receiptInfo.getBusiType());
            entry.setBookKeeper(receiptInfo.getTransTellno());
            entry.setFilePath(receiptInfo.getFilePath());
            entry.setParent(elStatementBillInfo);
            Object[] entryReserveds = receiptInfo.getReserveds();
            if (!EmptyUtil.isEmpty((Object[])entryReserveds)) {
                for (int m = 0; m < entryReserveds.length; ++m) {
                    String returnValue = ((String)entryReserveds[m]).trim();
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("typeOfSourceDocument=".toUpperCase(Locale.ENGLISH))) {
                        entry.setVourcherType(returnValue.substring("typeOfSourceDocument=".length()));
                    }
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("numberOfSourceDocument=".toUpperCase(Locale.ENGLISH))) {
                        entry.setVourcherNum(returnValue.substring("numberOfSourceDocument=".length()));
                    }
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("transactionCode=".toUpperCase(Locale.ENGLISH))) {
                        entry.setTradeCode(returnValue.substring("transactionCode=".length()));
                    }
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("journalAccountOfBookkeeping=".toUpperCase(Locale.ENGLISH))) {
                        entry.setBookDetail(returnValue.substring("journalAccountOfBookkeeping=".length()));
                    }
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("otherAccountingInformation=".toUpperCase(Locale.ENGLISH))) {
                        entry.setOtherBookMsg(returnValue.substring("otherAccountingInformation=".length()));
                    }
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("accountBalance=".toUpperCase(Locale.ENGLISH))) {
                        entry.setAcctBalance(new BigDecimal(returnValue.substring("accountBalance=".length())));
                    }
                    if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("timeOfBookkeeping=".toUpperCase(Locale.ENGLISH))) continue;
                    Date booktime = new Date();
                    try {
                        String booktimeStr = receiptInfo.getTransDate() + " " + returnValue.substring("timeOfBookkeeping=".length());
                        booktime = this.sdfhms.parse(booktimeStr);
                    }
                    catch (ParseException e) {
                        logger.error((Object)("\u8bb0\u8d26\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a\u8fd4\u56de\u7684\u8bb0\u8d26\u65e5\u671f\u4e3a\uff1a" + returnValue.substring("timeOfBookkeeping=".length())));
                        e.printStackTrace();
                    }
                    entry.setBookTime(new Timestamp(booktime.getTime()));
                }
            }
            try {
                entry.setBookDate(this.dfts.parse(receiptInfo.getTransDate()));
            }
            catch (ParseException e) {
                logger.error((Object)("\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a\u8fd4\u56de\u7684\u56de\u5355\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + receiptInfo.getTransDate()));
                e.printStackTrace();
            }
            elStatementBillInfo.getEntry().add(entry);
        }
        if (!EmptyUtil.isEmpty((String)filePathStr)) {
            int one = filePathStr.lastIndexOf("/");
            String fileName = filePathStr.substring(one + 1, filePathStr.length());
            elStatementBillInfo.setFileName(fileName);
        }
        elStatementBillInfo.setFileSource("3");
        elStatementBillInfo.setIsDownPdf(false);
        elStatementBillInfo.setIsImport(false);
        elStatementBillInfo.setDebitAmount(debitAmountTotal);
        elStatementBillInfo.setDebitCounts(debitCount);
        elStatementBillInfo.setCreditAmount(creditAmountTotal);
        elStatementBillInfo.setCreditCounts(creditCount);
        ElStatementBillCollection elColl = this.elStatementUtils.getElStatementBillByBankAndDate(ctx, fbankAccountNumber, date);
        if (elColl.size() > 0) {
            return null;
        }
        return elStatementBillInfo;
    }

    private AccountBankCollection getAccountBankCollectionByAccNum(Context ctx, String fbankAccountNumber) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("company.*"));
        selectorItemCollection.add(new SelectorItemInfo("bank.*"));
        selectorItemCollection.add(new SelectorItemInfo("shareAcct.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)fbankAccountNumber, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        AccountBankCollection collection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(entityViewInfo);
        return collection;
    }

    public void updateElStatementBillAccBankListByAccNum(Context ctx, String fBankAccountNumber, Date transDate) throws BOSException, EASBizException {
        ElStatementBillAccountBankListCollection collection = this.elStatementBillAccBankListUtil.getElStatementBillAccountBankListCollection(ctx, fBankAccountNumber);
        ElStatementBillAccountBankListInfo info = null;
        if (collection == null || collection.size() <= 0) {
            String noElStatementBillAccountBankListMsg = "\u6ca1\u6709\u67e5\u8be2\u5230\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + "\u7684\u7535\u5b50\u5bf9\u8d26\u5355\u6267\u884c\u8bb0\u5f55\uff0c\u4e0d\u80fd\u66f4\u65b0\u7535\u5b50\u56de\u5355\u4ea4\u6613\u65e5\u671f";
            logger.error((Object)noElStatementBillAccountBankListMsg);
            throw new BOSException(noElStatementBillAccountBankListMsg);
        }
        info = collection.get(0);
        info.setTransDate(transDate);
        logger.error((Object)("\u66f4\u65b0\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + " \u7684\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + info.getTransDate() + "\tStart"));
        this.elStatementBillAccBankListUtil.insertElStatementBillAccountBankInfo(ctx, info);
        logger.error((Object)("\u66f4\u65b0\u94f6\u884c\u8d26\u6237" + fBankAccountNumber + " \u7684\u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + info.getTransDate() + "\tEnd"));
    }
}

