/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.IElStatementBill;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.app.util.ElStatementJDBC;
import com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils;
import com.kingdee.eas.fm.be.vo.EReceiptVO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementDBUtils {
    private IElStatementBill iElStatementBill = null;
    private static Logger logger = Logger.getLogger((String)ElStatementDBUtils.class.getName());

    public void addnewBatchData(Context ctx, CoreBaseCollection elStatementColls) throws BOSException, EASBizException {
        if (this.iElStatementBill == null) {
            this.iElStatementBill = ElStatementBillFactory.getLocalInstance(ctx);
        }
        this.iElStatementBill.addnewBatchData(elStatementColls);
    }

    public void updateEASElStatementFile(Context ctx, ElStatementBillInfo elStatementInfo, Connection conn) throws BOSException {
        PreparedStatement stmtUpdate = null;
        String updateSql = "Update T_BE_ElStatementBill set FIsDownPdf = 1, FFileSource = ? ,FFileValue = ? where FId= ? ";
        try {
            stmtUpdate = conn.prepareStatement(updateSql);
            stmtUpdate.setString(1, "0");
            logger.error((Object)"\u8f6c\u6362byte\u6d41");
            ByteArrayInputStream input = new ByteArrayInputStream(elStatementInfo.getFileValue());
            logger.error((Object)"\u8f6c\u6362\u5b8c\u6210");
            stmtUpdate.setBinaryStream(2, (InputStream)input, ((InputStream)input).available());
            DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)3, (String)elStatementInfo.getId().toString());
            logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5230EAS\u5e93");
            stmtUpdate.executeUpdate();
            logger.error((Object)"\u66f4\u65b0\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5230EAS\u5e93\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0EAS\u5e93\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmtUpdate);
        }
    }

    public void insertMySqlEreceiptPDF(Context ctx, ElStatementBillInfo elStatementBillInfo) throws BOSException, EASBizException {
        ElStatementJDBC elStatementJDBCTool = new ElStatementJDBC();
        EReceiptVO eReceiptVO = new EReceiptVO();
        eReceiptVO.setFID(elStatementBillInfo.getId().toString());
        eReceiptVO.setEASID(elStatementBillInfo.getId().toString());
        eReceiptVO.setFILENAME(elStatementBillInfo.getFileName());
        eReceiptVO.setDETAILNO("");
        eReceiptVO.setBANKNUMBER(elStatementBillInfo.getBankAccount().getBankAccountNumber());
        eReceiptVO.setTRANSDATE(elStatementBillInfo.getTransDate());
        ByteArrayInputStream input = new ByteArrayInputStream(elStatementBillInfo.getFileValue());
        eReceiptVO.setFILEVALUE(input);
        try {
            elStatementJDBCTool.insert(eReceiptVO);
        }
        catch (Exception e) {
            String exMsg = "\u4fdd\u5b58PDF\u5230PDF\u5e93\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4PDF\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException((Throwable)e);
        }
    }

    public void insertElStatementFilesToDB(Context ctx, ElStatementBillInfo elStatementInfo, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws BOSException, EASBizException {
        ElStatementJDBC elStatementJDBCTool = new ElStatementJDBC();
        EReceiptVO eReceiptVO = new EReceiptVO();
        eReceiptVO.setFID(elStatementInfo.getId().toString());
        eReceiptVO.setEASID(elStatementInfo.getId().toString());
        eReceiptVO.setFILENAME(elStatementInfo.getFileName());
        eReceiptVO.setDETAILNO("");
        eReceiptVO.setBANKNUMBER(elStatementInfo.getBankAccount().getBankAccountNumber());
        eReceiptVO.setTRANSDATE(elStatementInfo.getTransDate());
        ByteArrayInputStream input = new ByteArrayInputStream(elStatementInfo.getFileValue());
        eReceiptVO.setFILEVALUE(input);
        try {
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  start");
            elStatementJDBCTool.insertEReceipt(eReceiptVO, eReceiptStorageSettingInfo);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  OK");
        }
        catch (Exception e) {
            String exMsg = "\u4fdd\u5b58PDF\u5230\u56de\u5355\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4PDF\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            logger.error((Object)exMsg);
            e.printStackTrace();
            throw new BEException(null);
        }
    }

    public void updateElStatementFileId(Context ctx, String elStatementId, String fileId, Connection conn) throws BOSException {
        String sql = "Update T_BE_ElStatementBill set FFileId = ? where fid = ?";
        PreparedStatement stmtUpdate = null;
        try {
            stmtUpdate = conn.prepareStatement(sql);
            stmtUpdate.setString(1, fileId);
            stmtUpdate.setString(2, elStatementId);
            stmtUpdate.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0 \u4e91\u76d8\u6587\u4ef6id\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmtUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElStatementFileToLocal(Context ctx, ElStatementBillInfo elStatementInfo, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws BOSException, EASBizException {
        String storePath = eReceiptStorageSettingInfo.getLocalPath();
        String fileName = elStatementInfo.getFileName();
        String bankAccountId = null;
        String filePath = null;
        byte[] fileValue = elStatementInfo.getFileValue();
        File file = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            logger.error((Object)"\u4fdd\u5b58\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5230 \u672c\u5730  start");
            File dir = new File(storePath);
            if (!dir.exists() || !dir.isDirectory()) {
                String errMsg = "\u672c\u5730\u8be5\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u6587\u4ef6\u5939\uff0c\u8bf7\u5728web\u7aef\u7535\u5b50\u56de\u5355\u5b58\u50a8\u914d\u7f6e\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!";
                logger.error((Object)errMsg);
                throw new BOSException(errMsg);
            }
            bankAccountId = elStatementInfo.getBankAccount().getBankInterFaceID();
            SimpleDateFormat y = new SimpleDateFormat("yyyy");
            String eRYear = y.format(elStatementInfo.getTransDate());
            SimpleDateFormat m = new SimpleDateFormat("MM");
            String eRMonth = m.format(elStatementInfo.getTransDate());
            SimpleDateFormat d = new SimpleDateFormat("dd");
            String eRDay = d.format(elStatementInfo.getTransDate());
            filePath = elStatementInfo.isIsImport() ? storePath + "/Import/" + eRYear + "/" + eRMonth + "/" + eRDay : storePath + "/" + bankAccountId + "/" + eRYear + "/" + eRMonth + "/" + eRDay;
            file = new File(filePath);
            if (!file.exists() || !file.isDirectory()) {
                file.mkdirs();
            }
            filePath = filePath + "/" + fileName;
            file = new File(filePath);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(fileValue);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  end");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String uploadFileToDrive(Context ctx, ElStatementBillInfo elStatementInfo, String orgAccessToken, String uid, Map<String, String> folderIdMap) throws BOSException {
        String fileId = null;
        try {
            SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
            SimpleDateFormat sdfMonth = new SimpleDateFormat("MM");
            SimpleDateFormat sdfDay = new SimpleDateFormat("dd");
            Date transDate = elStatementInfo.getTransDate();
            String transYear = sdfYear.format(transDate);
            String transMonth = sdfMonth.format(transDate);
            String transDay = sdfDay.format(transDate);
            String yearFolderId = folderIdMap.get(transYear);
            if (yearFolderId == null) {
                yearFolderId = ElStatementDBUtils.createFolder(ctx, transYear, null, orgAccessToken, uid);
                folderIdMap.put(transYear, yearFolderId);
            }
            if (yearFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            String monthFolderId = folderIdMap.get(transYear + transMonth);
            if (monthFolderId == null) {
                monthFolderId = ElStatementDBUtils.createFolder(ctx, transMonth, yearFolderId, orgAccessToken, uid);
                folderIdMap.put(transYear + transMonth, monthFolderId);
            }
            if (monthFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            String dayFolderId = folderIdMap.get(transYear + transMonth + transDay);
            if (dayFolderId == null) {
                dayFolderId = ElStatementDBUtils.createFolder(ctx, transDay, monthFolderId, orgAccessToken, uid);
                folderIdMap.put(transYear + transMonth + transDay, dayFolderId);
            }
            if (dayFolderId == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"607_EReceiptCloundDriveUtils", (Locale)ctx.getLocale()));
            }
            Map<String, String> fileMap = KingDeeCloundDriveApiUtils.uploadFileToOrgDrive(ctx, orgAccessToken, elStatementInfo.getFileValue(), elStatementInfo.getFileName(), dayFolderId, uid);
            String errcode = fileMap.get("errcode");
            if (!errcode.equals("0")) {
                String exMsg = KingDeeCloundDriveApiUtils.getExMsg(ctx, fileMap);
                throw new Exception(exMsg);
            }
            fileId = fileMap.get("file_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return fileId;
    }

    public static String createFolder(Context ctx, String folderName, String parentFolderId, String orgAccessToken, String uid) throws Exception {
        String folderId = null;
        Map<String, String> folderMap = KingDeeCloundDriveApiUtils.isExistFolder(ctx, folderName, parentFolderId, orgAccessToken, uid);
        String errcode = folderMap.get("errcode");
        if (errcode.equals("0")) {
            folderId = folderMap.get("folder_id");
        } else if (errcode.equals("2002")) {
            logger.error((Object)("\u6587\u4ef6\u5939\u3010" + folderName + "\u3011\u4e0d\u5b58\u5728,\u6240\u5c5e\u7236\u6587\u4ef6\u5939Id:" + parentFolderId));
            folderMap = KingDeeCloundDriveApiUtils.createFolder(ctx, folderName, parentFolderId, orgAccessToken, uid);
            errcode = folderMap.get("errcode");
            if (errcode.equals("0")) {
                folderId = folderMap.get("folder_id");
            }
            logger.error((Object)("\u521b\u5efa\u6587\u4ef6\u5939\u3010" + folderName + "\u3011OK,\u6240\u5c5e\u7236\u6587\u4ef6\u5939Id:" + parentFolderId));
        }
        if (!errcode.equals("0")) {
            String exMsg = KingDeeCloundDriveApiUtils.getExMsg(ctx, folderMap);
            throw new Exception(exMsg);
        }
        return folderId;
    }

    public void saveFilesValues(Context ctx, ElStatementBillInfo elStatementInfo, Connection conn) throws BOSException {
        block8: {
            try {
                this.updateEASElStatementFile(ctx, elStatementInfo, conn);
                StorageSettingInstance storageSetting = StorageSettingInstance.getInstance(ctx);
                if (storageSetting != null) {
                    int storageType = storageSetting.getStorageSettingInfo().getStorageType().getValue();
                    if (storageType == 0) {
                        this.insertElStatementFilesToDB(ctx, elStatementInfo, storageSetting.getStorageSettingInfo());
                        break block8;
                    }
                    if (storageType == 3) {
                        this.insertElStatementFileToLocal(ctx, elStatementInfo, storageSetting.getStorageSettingInfo());
                        break block8;
                    }
                    logger.error((Object)"\u4e0a\u4f20\u6587\u4ef6 \u5230\u91d1\u8776\u4e91\u76d8  start");
                    try {
                        String fileId = ElStatementDBUtils.uploadFileToDrive(ctx, elStatementInfo, storageSetting.getOrgAccessToken(), storageSetting.getStorageSettingInfo().getDriveUserId(), storageSetting.getFolderIdMap());
                        logger.error((Object)("\u4e0a\u4f20\u6587\u4ef6 \u5230\u91d1\u8776\u4e91\u76d8  ok,\u6587\u4ef6id\u4e3a\uff1a" + fileId));
                        if (fileId == null) {
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"558_DriveElStatementBatchService", (Locale)ctx.getLocale()));
                        }
                        logger.error((Object)"\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  start");
                        this.updateElStatementFileId(ctx, elStatementInfo.getId().toString(), fileId, conn);
                        logger.error((Object)"\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  ok");
                        break block8;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"917_ElStatementDBUtils", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"918_ElStatementDBUtils", (Locale)ctx.getLocale())});
                    }
                }
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"561_ElStatementBatchService", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"919_ElStatementDBUtils", (Locale)ctx.getLocale())});
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ElStatementBillCollection getElStatementBillByBankAndDate(Context ctx, String fbankAccountNumber, Date transDate) throws BOSException {
        EntityViewInfo elStatementView = new EntityViewInfo();
        SelectorItemCollection elStatementSic = new SelectorItemCollection();
        elStatementSic.add(new SelectorItemInfo("id"));
        elStatementView.setSelector(elStatementSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankAccount.bankAccountNumber", (Object)fbankAccountNumber));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)transDate));
        elStatementView.setFilter(eReceiptFilter);
        ElStatementBillCollection coll = ElStatementBillFactory.getLocalInstance(ctx).getElStatementBillCollection(elStatementView);
        return coll;
    }
}

