/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.QueryReceiptRequest;
import com.kingdee.bos.ebservice.QueryReceiptRequestBody;
import com.kingdee.bos.ebservice.QueryReceiptResponse;
import com.kingdee.bos.ebservice.QueryReceiptResponseBody;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.ElStatementBillTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.app.ElStatementBillLogUtils;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class ElStatementEBGServiceUtil
extends BaseEBGUtil {
    private static final Logger logger = Logger.getLogger((String)ElStatementEBGServiceUtil.class.getName());
    private static final String yyyyMMdd = "yyyyMMdd";
    private EBGServiceUtil eBGServiceUtil = null;
    private ElStatementBillLogUtils elStatementBillLogUtils = new ElStatementBillLogUtils();

    protected EBHeader parseHeader(Context ctx, String BankAcct) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        EBHeader header = new EBHeader();
        header.setClientName("EAS$" + ctx.getAIS());
        header.setClientVersion("EAS7.0");
        header.setCurrency("CNY");
        header.setRequestTime(format.format(new Date()));
        header.setBizType("queryReceipt");
        header.setSubBizType("queryRebill");
        header.setOperationName("queryReceipt");
        header.setCurrency("CNY");
        header.setAccNo(BankAcct);
        return header;
    }

    protected QueryReceiptRequestBody parseBody(String startDate, String endDate) {
        QueryReceiptRequestBody body = new QueryReceiptRequestBody();
        body.setStartDate(startDate);
        body.setEndDate(endDate);
        return body;
    }

    public QueryReceiptResponseBody getReceiptResponseBody(Context ctx, String bankAccountNumber, Date bizDate) throws BOSException, EASBizException {
        String transDate = this.parseDateToStr(bizDate, yyyyMMdd);
        String commonLogMsg = "\u67e5\u8be2\u94f6\u884c\u8d26\u53f7\uff1a" + bankAccountNumber + " \u65e5\u671f\uff1a" + transDate + " \u7684\u7535\u5b50\u5bf9\u8d26\u5355";
        logger.error((Object)("\u5f00\u59cb\u8fde\u63a5\u94f6\u4f01\uff0c" + commonLogMsg));
        if (this.eBGServiceUtil == null) {
            try {
                BankBizInfo bizInfo = new BankBizInfo();
                bizInfo.setBankAcct(bankAccountNumber);
                this.eBGServiceUtil = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
            }
            catch (ServiceException e) {
                String exMsg = "\u8fde\u63a5\u94f6\u4f01\u5f02\u5e38\uff0c" + commonLogMsg + "  \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                logger.error((Object)exMsg);
                this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u8fde\u63a5\u94f6\u4f01\u5e73\u53f0\u5931\u8d25\uff01\u3011 \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u786e\u8ba4\u94f6\u4f01\u5e73\u53f0\u662f\u5426\u8fde\u901a  \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", this.elStatementBillLogUtils.getStackTrace(e), ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
                e.printStackTrace();
                throw new BEException(null);
            }
        }
        QueryReceiptRequest request = new QueryReceiptRequest();
        request.setHeader(this.parseHeader(ctx, bankAccountNumber));
        request.setBody(this.parseBody(transDate, transDate));
        QueryReceiptResponse queryReceiptResponse = null;
        try {
            queryReceiptResponse = this.eBGServiceUtil.queryReceipt(request);
        }
        catch (RemoteException e1) {
            String exMsg = "\u94f6\u4f01\u5e73\u53f0\u67e5\u8be2\u7535\u5b50\u56de\u5355\u5f02\u5e38\uff01" + commonLogMsg + " \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e1.getMessage();
            logger.error((Object)exMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u67e5\u8be2\u7535\u5b50\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e1.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", this.elStatementBillLogUtils.getStackTrace(e1), ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            e1.printStackTrace();
            throw new BEException(null);
        }
        QueryReceiptResponseBody queryReceiptResponseBody = queryReceiptResponse.getBody();
        EBException exception = queryReceiptResponse.getException();
        String exMsg = null;
        if (exception != null) {
            exMsg = "\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + exception.getMessage() + commonLogMsg;
            logger.error((Object)exMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + exception.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exception.getMessage(), ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody == null) {
            exMsg = "\u94f6\u4f01\u8fd4\u56dequeryReceiptResponse.getBody() \u4e3anull\uff0c" + commonLogMsg;
            logger.error((Object)exMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u94f6\u4f01\u8fd4\u56dequeryReceiptResponse.getBody() \u4e3anull", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exMsg, ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody.getCompleted() == null || !queryReceiptResponseBody.getCompleted().equals("1")) {
            logger.error((Object)(commonLogMsg + " \u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d"));
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d !", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", "\u94f6\u4f01\u8fd4\u56de\u672a\u5b8c\u6210\u4e0b\u8f7d !", ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody.getReceiptInfos() == null || queryReceiptResponseBody.getReceiptInfos().length == 0) {
            exMsg = "\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReceiptInfos() \u4e3a null\uff0c\u5373\u5355\u636e\u5206\u5f55\u7684\u6570\u636e\u4e3a\u7a7a" + commonLogMsg;
            logger.error((Object)exMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReceiptInfos() \u4e3a null", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exMsg, ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BEException(null);
        }
        if (queryReceiptResponseBody.getReserveds() == null || queryReceiptResponseBody.getReserveds().length == 0) {
            exMsg = "\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReserveds() \u4e3a null\uff0c\u5373\u5355\u636e\u5934\u6570\u636e\u4e3a\u7a7a" + commonLogMsg;
            logger.error((Object)exMsg);
            this.elStatementBillLogUtils.saveElStatementBillLog(ctx, bankAccountNumber, bizDate, "\u3010\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u56de\u5355\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u94f6\u4f01\u8fd4\u56dequeryReceiptResponseBody.getReserveds() \u4e3a null", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u8fd0\u7ef4\u4eba\u5458\uff01", exMsg, ElStatementBillTypeEnum.DOWNElStructFormat, LevelEnum.ERROR);
            throw new BEException(null);
        }
        return queryReceiptResponseBody;
    }

    private String parseDateToStr(Date date, String formatStr) {
        if (EmptyUtil.isEmpty((String)formatStr)) {
            formatStr = yyyyMMdd;
        }
        SimpleDateFormat dfts = new SimpleDateFormat(formatStr);
        return dfts.format(date);
    }
}

