/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.ElStatementBillFilePathCollection;
import com.kingdee.eas.fm.be.ElStatementBillFilePathFactory;
import com.kingdee.eas.fm.be.ElStatementBillFilePathInfo;
import com.kingdee.eas.fm.be.ElStatementBillInfo;
import com.kingdee.eas.fm.be.app.EReceiptPDFUtils;
import com.kingdee.eas.fm.be.app.util.EReceiptSFtpUtil;
import com.kingdee.eas.fm.be.vo.FtpVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ElStatementFilesUtils {
    private Logger logger = Logger.getLogger(EReceiptPDFUtils.class);
    private SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
    private EReceiptSFtpUtil eReceiptFtpUtil = new EReceiptSFtpUtil();

    public byte[] getFilesByteAarry(Context ctx, ElStatementBillInfo elStatementInfo) throws BOSException, EASBizException {
        byte[] fileValue = null;
        String sSQL = "Select FSFTPServiceAddress, FSFTPPort, FSFTPUser,FSFTPUserPassword From T_BE_SFTPServiceAdd";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
        FtpVO ftpVO = new FtpVO();
        try {
            if (rs.next()) {
                String sftpIp = rs.getString("FSFTPServiceAddress");
                String sftpport = rs.getString("FSFTPPort");
                String sftpUserName = rs.getString("FSFTPUser");
                String sftpPassword = rs.getString("FSFTPUserPassword");
                ftpVO.setIp(sftpIp);
                ftpVO.setPor(Integer.parseInt(sftpport));
                ftpVO.setUser(sftpUserName);
                ftpVO.setPassword(sftpPassword);
            } else {
                ftpVO.setIp(elStatementInfo.getIp());
                int porStr = -1;
                if (elStatementInfo.getPort() != null && !elStatementInfo.getPort().equals("")) {
                    porStr = Integer.parseInt(elStatementInfo.getPort());
                }
                ftpVO.setPor(porStr);
                ftpVO.setUser(elStatementInfo.getUsername());
                ftpVO.setPassword(elStatementInfo.getPassword());
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
        String msg = "";
        this.logger.error((Object)("\u5f00\u59cb\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\uff0c" + msg));
        String remotePath = elStatementInfo.getFilePath();
        fileValue = this.downloadFileFromFTP(ctx, ftpVO, remotePath, elStatementInfo.getId().toString());
        this.logger.error((Object)("\u7ed3\u675f\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\uff0c" + msg));
        return fileValue;
    }

    protected byte[] downloadFileFromFTP(Context ctx, FtpVO ftpVO, String remotePath, String elStatementId) throws BOSException, EASBizException {
        byte[] fileValue = null;
        byte[] allBytes = null;
        String msg = "\u4e0b\u8f7dPDF\u6587\u4ef6\uff1aIP:" + ftpVO.getIp() + "   \u7aef\u53e3:" + ftpVO.getPor() + "   \u7528\u6237\u540d:" + ftpVO.getUser() + "  \u5bc6\u7801:" + ftpVO.getPassword() + "  \u5bf9\u8d26\u5355\u6587\u4ef6FTP\u670d\u52a1\u5668\u8def\u5f84:" + remotePath;
        try {
            try {
                this.eReceiptFtpUtil.getConnect(ftpVO);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new BEException(null);
            }
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("elStatementBillId", (Object)elStatementId));
                view.setFilter(filter);
                ElStatementBillFilePathCollection filePathColl = ElStatementBillFilePathFactory.getLocalInstance(ctx).getElStatementBillFilePathCollection(view);
                ArrayList<byte[]> elFileValueList = new ArrayList<byte[]>();
                for (int i = 0; i < filePathColl.size(); ++i) {
                    ElStatementBillFilePathInfo elFilePathInfo = filePathColl.get(i);
                    fileValue = this.eReceiptFtpUtil.downloadFile(elFilePathInfo.getFilePath());
                    elFileValueList.add(fileValue);
                }
                allBytes = ElStatementFilesUtils.mergeBytes(elFileValueList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BEException(null);
            }
            this.logger.error((Object)(" \u6210\u529f  " + msg));
        }
        catch (Exception e) {
            try {
                this.eReceiptFtpUtil.closeChannel();
            }
            catch (Exception e1) {
                this.logger.error((Object)"\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25");
                e1.printStackTrace();
            }
            if (e instanceof BEException) {
                throw new BEException(null);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                this.eReceiptFtpUtil.closeChannel();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)"\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25");
            }
        }
        return allBytes;
    }

    private static byte[] mergeBytes(List<byte[]> values) {
        int lengthBype = 0;
        for (byte[] value : values) {
            lengthBype += value.length;
        }
        byte[] allBytes = new byte[lengthBype];
        int countLength = 0;
        for (byte[] b : values) {
            System.arraycopy(b, 0, allBytes, countLength, b.length);
            countLength += b.length;
        }
        return allBytes;
    }
}

