/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.QueryReconciliateRequest;
import com.kingdee.bos.ebservice.QueryReconciliateRequestBody;
import com.kingdee.bos.ebservice.QueryReconciliateResponse;
import com.kingdee.bos.ebservice.QueryReconciliateResponseBody;
import com.kingdee.bos.ebservice.ReconciliateDetail;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fi.cas.ElecBookOnLineTypeEnum;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.ElecBookBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class ElecBookServiceUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(ElecBookServiceUtil.class);
    IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    protected EBHeader parseHeader(Context ctx, ElecBookBizInfo bizInfo) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("reconciliate");
        header.setSubBizType("queryReconciliate");
        header.setOperationName("queryReconciliate");
        if (ElecBookOnLineTypeEnum.ONLINE_ALL.getValue().equals(bizInfo.getQueryRecType())) {
            header.setAccNo("*");
        } else {
            header.setAccNo(bizInfo.getBankAcct());
        }
        header.setCurrency(bizInfo.getCurrency());
        return header;
    }

    private QueryReconciliateRequest parseElecBookReqeust(Context ctx, ElecBookBizInfo bizInfo) {
        QueryReconciliateRequest qRecRequest = new QueryReconciliateRequest();
        qRecRequest.setHeader(this.parseHeader(ctx, bizInfo));
        QueryReconciliateRequestBody qRecReqBody = new QueryReconciliateRequestBody();
        qRecReqBody.setBatchSeqId(bizInfo.getBatchSeqId());
        qRecReqBody.setBeginDate(bizInfo.getStartDate());
        qRecReqBody.setEndDate(bizInfo.getFinishDate());
        qRecReqBody.setQueryRecType(bizInfo.getQueryRecType());
        qRecReqBody.setBankServiceLoginId(bizInfo.getBankInterfaceType());
        qRecRequest.setBody(qRecReqBody);
        return qRecRequest;
    }

    public ReconciliateDetail[] getReconciliate(Context ctx, ElecBookBizInfo bizInfo) throws RemoteException, EBGException, ServiceException, BEException, FMException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        QueryReconciliateResponse qrResponse = service.getReconciliate(this.parseElecBookReqeust(ctx, bizInfo));
        QueryReconciliateResponseBody qrDetail = qrResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)qrDetail)) {
            return qrDetail.getDetails();
        }
        EBException exception = qrResponse.getException();
        throw new EBGException(EBGException.RECONCILIATEERR, new Object[]{exception.getMessage()});
    }
}

