/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.ReconciliateDetail;
import com.kingdee.bos.ebservice.ReconciliateRequest;
import com.kingdee.bos.ebservice.ReconciliateRequestBody;
import com.kingdee.bos.ebservice.ReconciliateResponse;
import com.kingdee.bos.ebservice.ReconciliateResponseBody;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.ElecBookBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class ElecSignServiceUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(ElecSignServiceUtil.class);
    private IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    private ReconciliateRequest parseElecSignReqeust(Context ctx, List elecBookColl) {
        ReconciliateRequest recRequest = new ReconciliateRequest();
        recRequest.setHeader(this.parseHeader(ctx, elecBookColl));
        ReconciliateRequestBody body = new ReconciliateRequestBody();
        body.setBankServiceLoginId(((ElecBookBizInfo)elecBookColl.get(0)).getBankInterfaceType());
        body.setBatchSeqId(((ElecBookBizInfo)elecBookColl.get(0)).getBatchSeqId());
        body.setDetails(this.parseReconciliateDetail(elecBookColl));
        recRequest.setBody(body);
        return recRequest;
    }

    protected ReconciliateDetail[] parseReconciliateDetail(List elecBookBizInfos) {
        ReconciliateDetail[] details = new ReconciliateDetail[elecBookBizInfos.size()];
        for (int i = 0; i < elecBookBizInfos.size(); ++i) {
            details[i] = new ReconciliateDetail();
            ElecBookBizInfo elecBookInfo = (ElecBookBizInfo)elecBookBizInfos.get(i);
            details[i].setAccount(elecBookInfo.getBankAcct());
            details[i].setDetailSeqId(elecBookInfo.getSerialNumber());
            details[i].setCurrency(elecBookInfo.getCurrency());
            details[i].setRecDate(elecBookInfo.getRecDate());
            details[i].setBalance(elecBookInfo.getBalance());
            details[i].setRecRef(elecBookInfo.getRecRef());
            details[i].setBalanceStatus(elecBookInfo.getBalanceStatus());
            details[i].setAdjustCause(elecBookInfo.getAdjustCause());
            details[i].setTelephoneNumber(elecBookInfo.getTelephoneNumber());
        }
        return details;
    }

    public ReconciliateDetail[] reconciliate(Context ctx, List elecBookBizInfos) throws RemoteException, EBGException, ServiceException, BEException, FMException {
        EBGServiceUtil service = new EBGServiceUtil(ctx);
        ReconciliateResponse response = service.reconciliate(this.parseElecSignReqeust(ctx, elecBookBizInfos));
        ReconciliateResponseBody body = response.getBody();
        if (!EmptyUtil.isEmpty((Object)body)) {
            return body.getDetails();
        }
        EBException exception = response.getException();
        throw new EBGException(EBGException.RECONCILIATEERR, new Object[]{exception.getMessage()});
    }

    protected EBHeader parseHeader(Context ctx, List elecBookBizInfo) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("reconciliate");
        header.setSubBizType("reconciliate");
        ElecBookBizInfo ebBizInfo = (ElecBookBizInfo)elecBookBizInfo.get(0);
        header.setOperationName("reconciliate");
        header.setAccNo(ebBizInfo.getBankAcct());
        header.setCurrency(ebBizInfo.getCurrency());
        return header;
    }
}

