/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.CreditDealReceivedDetail;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryRequest;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryRequestBody;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryResponse;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryResponseBody;
import com.kingdee.bos.ebservice.CreditDealReceivedRequest;
import com.kingdee.bos.ebservice.CreditDealReceivedRequestBody;
import com.kingdee.bos.ebservice.CreditDealReceivedResponse;
import com.kingdee.bos.ebservice.CreditDealReceivedResponseBody;
import com.kingdee.bos.ebservice.CreditModifyDetail;
import com.kingdee.bos.ebservice.CreditModifyQueryRequest;
import com.kingdee.bos.ebservice.CreditModifyQueryRequestBody;
import com.kingdee.bos.ebservice.CreditModifyQueryResponse;
import com.kingdee.bos.ebservice.CreditModifyQueryResponseBody;
import com.kingdee.bos.ebservice.CreditModifyRequest;
import com.kingdee.bos.ebservice.CreditModifyRequestBody;
import com.kingdee.bos.ebservice.CreditModifyResponse;
import com.kingdee.bos.ebservice.CreditModifyResponseBody;
import com.kingdee.bos.ebservice.CreditOpenBody;
import com.kingdee.bos.ebservice.CreditOpenDetail;
import com.kingdee.bos.ebservice.CreditOpenQueryRequest;
import com.kingdee.bos.ebservice.CreditOpenQueryRequestBody;
import com.kingdee.bos.ebservice.CreditOpenRequest;
import com.kingdee.bos.ebservice.CreditOpenResponse;
import com.kingdee.bos.ebservice.CreditQueryReceivedRequest;
import com.kingdee.bos.ebservice.CreditQueryReceivedRequestBody;
import com.kingdee.bos.ebservice.CreditQueryReceivedResponse;
import com.kingdee.bos.ebservice.CreditQueryReceivedResponseBody;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.ReceivedDetail;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBCreditServiceUtil;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedAcceptDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedAcceptVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedPayDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedPayVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedRejectDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedRejectVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditQueryReceivedVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedAcceptQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedPayQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedRejectQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditVO;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditVO;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class LetterOfCreditEBGServiceUtil
extends BaseEBGUtil {
    private EBCreditServiceUtil service = null;
    private Context ctx;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil");
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public LetterOfCreditEBGServiceUtil() {
    }

    public LetterOfCreditEBGServiceUtil(Context ctx) throws EASBizException {
        this.ctx = ctx;
        try {
            this.service = new EBCreditServiceUtil(ctx);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    public CreditOpenBody openCredit(Context ctx, OpenCreditVO openCreditVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditOpenRequest request = new CreditOpenRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("openCredit");
        header.setOperationName("openCredit");
        header.setAccNo(openCreditVO.getAccNo());
        header.setCurrency(openCreditVO.getCurrency());
        request.setHeader(header);
        CreditOpenBody creditOpenBody = new CreditOpenBody();
        creditOpenBody.setBatchSeqId(openCreditVO.getBatchSeqId());
        creditOpenBody.setBatchBizNo(openCreditVO.getBatchBizNo());
        creditOpenBody.setTotalCount(openCreditVO.getTotalCount());
        CreditOpenDetail[] details = new CreditOpenDetail[]{};
        List<Object> openCreditList = new ArrayList();
        openCreditList = openCreditVO.getDetails();
        if (openCreditList.size() > 0) {
            details = new CreditOpenDetail[openCreditList.size()];
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < openCreditList.size(); ++i) {
            OpenCreditDetailVO openCreditDetailVO = (OpenCreditDetailVO)openCreditList.get(i);
            CreditOpenDetail creditOpenDetail = new CreditOpenDetail();
            creditOpenDetail.setDetailSeqId(openCreditDetailVO.getDetailSeqId());
            creditOpenDetail.setDetailBizNo(openCreditDetailVO.getDetailBizNo());
            creditOpenDetail.setCreditType(openCreditDetailVO.getCreditType());
            creditOpenDetail.setNominalCurrency(openCreditDetailVO.getNominalCurrency());
            creditOpenDetail.setNominalAmount(openCreditDetailVO.getNominalAmount());
            creditOpenDetail.setInitialCode(openCreditDetailVO.getInitialCode());
            creditOpenDetail.setIssuedDate(df.format(openCreditDetailVO.getIssuedDate()));
            creditOpenDetail.setLatestShipmentDate(df.format(openCreditDetailVO.getLatestShipmentDate()));
            creditOpenDetail.setExpiringDate(df.format(openCreditDetailVO.getExpiringDate()));
            creditOpenDetail.setExpiryPlace(openCreditDetailVO.getExpiryPlace());
            creditOpenDetail.setTenors(openCreditDetailVO.getTenors());
            creditOpenDetail.setApplicableRules(openCreditDetailVO.getApplicableRules());
            creditOpenDetail.setContractNo(openCreditDetailVO.getContractNo());
            creditOpenDetail.setContractAmount(openCreditDetailVO.getContractAmount());
            creditOpenDetail.setApplicant(openCreditDetailVO.getApplicant());
            creditOpenDetail.setAdvisingBank(openCreditDetailVO.getAdvisingBank());
            creditOpenDetail.setBeneficiary(openCreditDetailVO.getBeneficiary());
            creditOpenDetail.setConfirmInstruction(openCreditDetailVO.getConfirmInstruction());
            creditOpenDetail.setApplicantBank(openCreditDetailVO.getApplicantBank());
            creditOpenDetail.setOtherAdvisingBank(openCreditDetailVO.getOtherAdvisingBank());
            creditOpenDetail.setAvailableWithBank(openCreditDetailVO.getAvailableWithBank());
            creditOpenDetail.setAvailableBy(openCreditDetailVO.getAvailableBy());
            creditOpenDetail.setDraftsAt(openCreditDetailVO.getDraftsAt());
            creditOpenDetail.setDrawee(openCreditDetailVO.getDrawee());
            creditOpenDetail.setDefPaymentDetails(openCreditDetailVO.getDefPaymentDetails());
            creditOpenDetail.setMixedPaymentDetails(openCreditDetailVO.getMixedPaymentDetails());
            creditOpenDetail.setPresentationPeriod(openCreditDetailVO.getPresentationPeriod());
            creditOpenDetail.setDetailsOfCharges(openCreditDetailVO.getDetailsOfCharges());
            creditOpenDetail.setCountryCode(openCreditDetailVO.getCountryCode());
            creditOpenDetail.setPatialShipment(openCreditDetailVO.getPatialShipment());
            creditOpenDetail.setTransshipment(openCreditDetailVO.getTransshipment());
            creditOpenDetail.setPlaceOfReceipt(openCreditDetailVO.getPlaceOfReceipt());
            creditOpenDetail.setPortOfLoading(openCreditDetailVO.getPortOfLoading());
            creditOpenDetail.setPortOfDischarge(openCreditDetailVO.getPortOfDischarge());
            creditOpenDetail.setFinalDestination(openCreditDetailVO.getFinalDestination());
            creditOpenDetail.setShipmentPeriod(openCreditDetailVO.getShipmentPeriod());
            creditOpenDetail.setGoods(openCreditDetailVO.getGoods());
            creditOpenDetail.setDocuments(openCreditDetailVO.getDocuments());
            creditOpenDetail.setAdditionalConditions(openCreditDetailVO.getAdditionalConditions());
            creditOpenDetail.setComment(openCreditDetailVO.getComment());
            details[i] = creditOpenDetail;
        }
        creditOpenBody.setDetails(details);
        request.setBody(creditOpenBody);
        CreditOpenResponse creditOpenResponse = null;
        creditOpenResponse = this.service.openCredit(request);
        CreditOpenBody receiveCreditOpenBody = creditOpenResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)receiveCreditOpenBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditOpenResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditOpenResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return receiveCreditOpenBody;
        }
        EBException excetion = creditOpenResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditOpenBody openCreditQuery(Context ctx, OpenCreditQueryVO openCreditQueryVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditOpenQueryRequest request = new CreditOpenQueryRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("openCreditQuery");
        header.setOperationName("openCreditQuery");
        header.setAccNo(openCreditQueryVO.getAccNo());
        header.setCurrency(openCreditQueryVO.getCurrency());
        request.setHeader(header);
        CreditOpenQueryRequestBody creditOpenQueryRequestBody = new CreditOpenQueryRequestBody();
        creditOpenQueryRequestBody.setBatchSeqId(openCreditQueryVO.getBatchSeqId());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        creditOpenQueryRequestBody.setStartDate(df.format(openCreditQueryVO.getStartDate()));
        creditOpenQueryRequestBody.setEndDate(df.format(openCreditQueryVO.getEndDate()));
        request.setBody(creditOpenQueryRequestBody);
        CreditOpenResponse creditOpenResponse = null;
        creditOpenResponse = this.service.openCreditQuery(request);
        CreditOpenBody creditOpenBody = creditOpenResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)creditOpenBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditOpenResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditOpenResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditOpenBody;
        }
        EBException excetion = creditOpenResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditModifyResponseBody modifyCredit(Context ctx, ModifyCreditVO modifyCreditVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditModifyRequest request = new CreditModifyRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("modifyCredit");
        header.setOperationName("modifyCredit");
        header.setAccNo(modifyCreditVO.getAccNo());
        header.setCurrency(modifyCreditVO.getCurrency());
        request.setHeader(header);
        CreditModifyRequestBody creditModifyRequestBody = new CreditModifyRequestBody();
        creditModifyRequestBody.setBatchSeqId(modifyCreditVO.getBatchSeqId());
        creditModifyRequestBody.setBatchBizNo(modifyCreditVO.getBatchBizNo());
        creditModifyRequestBody.setTotalCount(modifyCreditVO.getTotalCount());
        CreditModifyDetail[] details = new CreditModifyDetail[]{};
        List<Object> modifyCreditList = new ArrayList();
        modifyCreditList = modifyCreditVO.getDetails();
        if (modifyCreditList.size() > 0) {
            details = new CreditModifyDetail[modifyCreditList.size()];
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < modifyCreditList.size(); ++i) {
            ModifyCreditDetailVO modifyCreditDetailVO = (ModifyCreditDetailVO)modifyCreditList.get(i);
            CreditModifyDetail creditModifyDetail = new CreditModifyDetail();
            creditModifyDetail.setDetailSeqId(modifyCreditDetailVO.getDetailSeqId());
            creditModifyDetail.setDetailBizNo(modifyCreditDetailVO.getDetailBizNo());
            creditModifyDetail.setBranchNo(modifyCreditDetailVO.getBranchNo());
            creditModifyDetail.setCreditNo(modifyCreditDetailVO.getCreditNo());
            creditModifyDetail.setApplicant(modifyCreditDetailVO.getApplicant());
            creditModifyDetail.setBeneficiary(modifyCreditDetailVO.getBeneficiary());
            creditModifyDetail.setApplyItems(modifyCreditDetailVO.getApplyItems());
            creditModifyDetail.setApplyDate(modifyCreditDetailVO.getApplyDate());
            creditModifyDetail.setUseCode("-1");
            details[i] = creditModifyDetail;
        }
        creditModifyRequestBody.setDetails(details);
        request.setBody(creditModifyRequestBody);
        CreditModifyResponse creditModifyResponse = null;
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)"-----------------before query start---------amazing!----------------");
        logger.error((Object)("BizType:" + headerTemp.getBizType()));
        logger.error((Object)("SubBizType:" + headerTemp.getSubBizType()));
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditModifyRequestBody bodyTemp = request.getBody();
        logger.error((Object)("BatchBizNo:" + bodyTemp.getBatchBizNo()));
        logger.error((Object)("BatchSeqId:" + bodyTemp.getBatchSeqId()));
        logger.error((Object)("TotalCount:" + bodyTemp.getTotalCount()));
        CreditModifyDetail[] detailsTmp = bodyTemp.getDetails();
        for (int i = 0; i < detailsTmp.length; ++i) {
            logger.error((Object)("\u7b2c" + i + "\u4e2adetail\u7684\u6570\u636e"));
            CreditModifyDetail detailTmp = detailsTmp[i];
            logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
            logger.error((Object)("BranchNo:" + detailTmp.getBranchNo()));
            logger.error((Object)("ApplyDate:" + detailTmp.getApplyDate()));
            logger.error((Object)("Beneficiary:" + detailTmp.getBeneficiary()));
            logger.error((Object)("DetailBizNo:" + detailTmp.getDetailBizNo()));
            logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
            logger.error((Object)("Applicant:" + detailTmp.getApplicant()));
            logger.error((Object)("ApplyItems:" + detailTmp.getApplyItems()));
        }
        logger.error((Object)"-----------------before query end---------amazing!----------------");
        creditModifyResponse = this.service.modifyCredit(request);
        CreditModifyResponseBody creditModifyQueryResponseBody = creditModifyResponse.getBody();
        if (creditModifyQueryResponseBody != null) {
            logger.error((Object)"-----------------after query start-----------------------------");
            CreditModifyDetail[] details1 = creditModifyQueryResponseBody.getDetails();
            for (int i = 0; i < details1.length; ++i) {
                logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
                CreditModifyDetail detailTmp = details1[i];
                logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
                logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
                logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
                logger.error((Object)("BranchNo:" + detailTmp.getBranchNo()));
                logger.error((Object)("ApplyDate:" + detailTmp.getApplyDate()));
                logger.error((Object)("Beneficiary:" + detailTmp.getBeneficiary()));
                logger.error((Object)("DetailBizNo:" + detailTmp.getDetailBizNo()));
                logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
                logger.error((Object)("Applicant:" + detailTmp.getApplicant()));
                logger.error((Object)("ApplyItems:" + detailTmp.getApplyItems()));
            }
        } else {
            logger.error((Object)"queryresponsebody is null");
        }
        logger.error((Object)"-----------------after query end----------amazing!-----------");
        CreditModifyResponseBody creditModifyResponseBody = creditModifyResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)creditModifyResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditModifyResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditModifyResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditModifyResponseBody;
        }
        EBException excetion = creditModifyResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditModifyQueryResponseBody modifyCreditQuery(Context ctx, ModifyCreditQueryVO modifyCreditQueryVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditModifyQueryRequest request = new CreditModifyQueryRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("modifyCreditQuery");
        header.setOperationName("modifyCreditQuery");
        header.setAccNo(modifyCreditQueryVO.getAccNo());
        header.setCurrency(modifyCreditQueryVO.getCurrency());
        request.setHeader(header);
        CreditModifyQueryRequestBody creditModifyQueryRequestBody = new CreditModifyQueryRequestBody();
        creditModifyQueryRequestBody.setBatchSeqId(modifyCreditQueryVO.getBatchSeqId());
        request.setBody(creditModifyQueryRequestBody);
        CreditModifyQueryResponse creditModifyQueryResponse = null;
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)"-----------------before query start---------amazing!----------------");
        logger.error((Object)("BizType:" + headerTemp.getBizType()));
        logger.error((Object)("SubBizType:" + headerTemp.getSubBizType()));
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditModifyQueryRequestBody bodyTmp = request.getBody();
        logger.error((Object)("DetailSeqId:" + bodyTmp.getDetailSeqId()));
        logger.error((Object)"-----------------before query end---------amazing!----------------");
        creditModifyQueryResponse = this.service.modifyCreditQuery(request);
        CreditModifyQueryResponseBody creditModifyQueryResponseBody = creditModifyQueryResponse.getBody();
        if (creditModifyQueryResponseBody != null) {
            logger.error((Object)"-----------------after query start-----------------------------");
            logger.error((Object)("BatchSeqId:" + creditModifyQueryResponseBody.getBatchSeqId()));
            CreditModifyDetail[] details = creditModifyQueryResponseBody.getDetails();
            for (int i = 0; i < details.length; ++i) {
                logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
                CreditModifyDetail detailTmp = details[i];
                logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
                logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
                logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
                logger.error((Object)("BranchNo:" + detailTmp.getBranchNo()));
                logger.error((Object)("ApplyDate:" + detailTmp.getApplyDate()));
                logger.error((Object)("Beneficiary:" + detailTmp.getBeneficiary()));
                logger.error((Object)("DetailBizNo:" + detailTmp.getDetailBizNo()));
                logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
                logger.error((Object)("Applicant:" + detailTmp.getApplicant()));
                logger.error((Object)("UseCode:" + detailTmp.getUseCode()));
                logger.error((Object)("ApplyItems:" + detailTmp.getApplyItems()));
            }
        } else {
            logger.error((Object)"queryresponsebody is null");
        }
        logger.error((Object)"-----------------after query end----------amazing!-----------");
        CreditModifyQueryResponseBody creditModifyQueryResponseBody1 = creditModifyQueryResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)creditModifyQueryResponseBody1)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditModifyQueryResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditModifyQueryResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditModifyQueryResponseBody1;
        }
        EBException excetion = creditModifyQueryResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditQueryReceivedResponseBody queryReceivedCredit(Context ctx, CreditQueryReceivedVO creditQueryReceivedVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditQueryReceivedRequest request = new CreditQueryReceivedRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("receivedCreditQuery");
        header.setOperationName("receivedCreditQuery");
        header.setAccNo(creditQueryReceivedVO.getAccNo());
        header.setCurrency(creditQueryReceivedVO.getCurrency());
        request.setHeader(header);
        CreditQueryReceivedRequestBody creditQueryReceivedRequestBody = new CreditQueryReceivedRequestBody();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        creditQueryReceivedRequestBody.setStartDate(df.format(creditQueryReceivedVO.getStartDate()));
        creditQueryReceivedRequestBody.setEndDate(df.format(creditQueryReceivedVO.getEndDate()));
        request.setBody(creditQueryReceivedRequestBody);
        CreditQueryReceivedResponse creditQueryReceivedResponse = null;
        logger.error((Object)"-----------------before query start-----------------------------");
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)("BizType:" + headerTemp.getBizType()));
        logger.error((Object)("SubBizType:" + headerTemp.getSubBizType()));
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditQueryReceivedRequestBody bodyTemp = request.getBody();
        logger.error((Object)("StartDate:" + bodyTemp.getStartDate()));
        logger.error((Object)("EndDate:" + bodyTemp.getEndDate()));
        logger.error((Object)"-----------------before query end---------amazing!----------------");
        creditQueryReceivedResponse = this.service.queryReceivedCredit(request);
        CreditQueryReceivedResponseBody creditQueryReceivedResponseBody = creditQueryReceivedResponse.getBody();
        if (creditQueryReceivedResponseBody != null) {
            logger.error((Object)"-----------------after query start-----------------------------");
            logger.error((Object)("BatchSeqId:" + creditQueryReceivedResponseBody.getBatchSeqId()));
            logger.error((Object)("NextPage:" + creditQueryReceivedResponseBody.getNextPage()));
            ReceivedDetail[] details = creditQueryReceivedResponseBody.getDetails();
            for (int i = 0; i < details.length; ++i) {
                logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
                ReceivedDetail detail = details[i];
                logger.error((Object)("DetailSeqId:" + detail.getDetailSeqId()));
                logger.error((Object)("CreditNo:" + detail.getCreditNo()));
                logger.error((Object)("ReceivedCreditNumber:" + detail.getReceivedCreditNumber()));
                logger.error((Object)("ReferenceNum:" + detail.getReferenceNum()));
                logger.error((Object)("ReceivedDate:" + detail.getReceivedDate()));
                logger.error((Object)("ReceivedNoticeDate:" + detail.getReceivedNoticeDate()));
                logger.error((Object)("ContractNo:" + detail.getContractNo()));
                logger.error((Object)("Amount:" + detail.getAmount()));
                logger.error((Object)("ReceivedDate:" + detail.getReceivedDate()));
                logger.error((Object)("ClaimAmount:" + detail.getClaimAmount()));
                logger.error((Object)("Applicant:" + detail.getApplicant()));
                logger.error((Object)("Beneficiary:" + detail.getBeneficiary()));
                logger.error((Object)("SubmitBank:" + detail.getSubmitBank()));
                logger.error((Object)("SystemBuisnessNo:" + detail.getSystemBuisnessNo()));
                logger.error((Object)("BranchNo:" + detail.getBranchNo()));
            }
        } else {
            logger.error((Object)"queryresponsebody is null");
        }
        logger.error((Object)"-----------------after query end----------amazing!-----------");
        if (!EmptyUtil.isEmpty((Object)creditQueryReceivedResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditQueryReceivedResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditQueryReceivedResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditQueryReceivedResponseBody;
        }
        EBException excetion = creditQueryReceivedResponse.getException();
        logger.error((Object)excetion.getMessage());
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedResponseBody dealReceivedReject(Context ctx, CreditDealReceivedRejectVO creditDealReceivedRejectVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        logger.error((Object)("20161203 service" + this.service.getBankServiceConfig_address()));
        CreditDealReceivedRequest request = new CreditDealReceivedRequest();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceived");
        header.setOperationName("dealReceived");
        header.setAccNo(creditDealReceivedRejectVO.getAccNo());
        header.setCurrency(creditDealReceivedRejectVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedRequestBody creditDealReceivedRequestBody = new CreditDealReceivedRequestBody();
        creditDealReceivedRequestBody.setBatchSeqId(creditDealReceivedRejectVO.getBatchSeqId());
        creditDealReceivedRequestBody.setBatchBizNo(creditDealReceivedRejectVO.getBatchBizNo());
        creditDealReceivedRequestBody.setTotalCount(creditDealReceivedRejectVO.getTotalCount());
        CreditDealReceivedDetail[] details = new CreditDealReceivedDetail[]{};
        List<Object> rejectList = new ArrayList();
        rejectList = creditDealReceivedRejectVO.getDetails();
        if (rejectList.size() > 0) {
            details = new CreditDealReceivedDetail[rejectList.size()];
        }
        for (int i = 0; i < rejectList.size(); ++i) {
            CreditDealReceivedRejectDetailVO creditDealReceivedDetailVO = (CreditDealReceivedRejectDetailVO)rejectList.get(i);
            CreditDealReceivedDetail creditDealReceivedDetail = new CreditDealReceivedDetail();
            creditDealReceivedDetail.setDetailSeqId(creditDealReceivedDetailVO.getDetailSeqId());
            creditDealReceivedDetail.setDetailBizNo(creditDealReceivedDetailVO.getDetailSeqId());
            creditDealReceivedDetail.setCreditNo(creditDealReceivedDetailVO.getCreditNo());
            creditDealReceivedDetail.setBranchNo(creditDealReceivedDetailVO.getBranchNo());
            creditDealReceivedDetail.setReceivedCreditNumber(creditDealReceivedDetailVO.getReceivedCreditNumber());
            creditDealReceivedDetail.setReferenceNum(creditDealReceivedDetailVO.getReferenceNum());
            creditDealReceivedDetail.setApplicationItems("4");
            creditDealReceivedDetail.setNote(creditDealReceivedDetailVO.getNote());
            creditDealReceivedDetail.setApplyDate(df.format(creditDealReceivedDetailVO.getApplyDate()));
            creditDealReceivedDetail.setApplicant(creditDealReceivedDetailVO.getApplicant());
            creditDealReceivedDetail.setBeneficiary(creditDealReceivedDetailVO.getBeneficiary());
            creditDealReceivedDetail.setAmount(creditDealReceivedDetailVO.getAmount());
            creditDealReceivedDetail.setClaimAmount(creditDealReceivedDetailVO.getClaimAmount());
            creditDealReceivedDetail.setContractNo(creditDealReceivedDetailVO.getContractNo());
            creditDealReceivedDetail.setRejectResult("A");
            details[i] = creditDealReceivedDetail;
        }
        creditDealReceivedRequestBody.setDetails(details);
        request.setBody(creditDealReceivedRequestBody);
        logger.error((Object)"----------before request start---------------------");
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditDealReceivedRequestBody bodyTemp = request.getBody();
        logger.error((Object)("BatchSeqId:" + bodyTemp.getBatchSeqId()));
        logger.error((Object)("TotalCount:" + bodyTemp.getTotalCount()));
        CreditDealReceivedDetail[] detailArray = creditDealReceivedRequestBody.getDetails();
        for (int i = 0; i < detailArray.length; ++i) {
            CreditDealReceivedDetail detail = detailArray[i];
            logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
            logger.error((Object)("DetailSeqId:" + detail.getDetailSeqId()));
            logger.error((Object)("EbSeqId\uff1a" + detail.getEbSeqId()));
            logger.error((Object)("CreditNo\uff1a" + detail.getCreditNo()));
            logger.error((Object)("ReceivedCreditNumber\uff1a" + detail.getReceivedCreditNumber()));
            logger.error((Object)("ApplicationItems:" + detail.getApplicationItems()));
            logger.error((Object)("Applicant:" + detail.getApplicant()));
            logger.error((Object)("Beneficiary:" + detail.getBeneficiary()));
            logger.error((Object)("Amount:" + detail.getAmount()));
            logger.error((Object)("ClaimAmount:" + detail.getClaimAmount()));
            logger.error((Object)("ContractNo:" + detail.getContractNo()));
            logger.error((Object)("RejectResult:" + detail.getRejectResult()));
        }
        logger.error((Object)"----------before request end---------------------");
        CreditDealReceivedResponse creditDealReceivedResponse = null;
        creditDealReceivedResponse = this.service.dealReceived(request);
        CreditDealReceivedResponseBody creditDealReceivedResponseBody = creditDealReceivedResponse.getBody();
        if (creditDealReceivedResponseBody != null) {
            logger.error((Object)"----------after response start---------------------");
            logger.error((Object)("BatchSeqID:" + creditDealReceivedResponseBody.getBatchSeqID()));
            logger.error((Object)("TotalCount:" + creditDealReceivedResponseBody.getTotalCount()));
            CreditDealReceivedDetail[] respDetails = creditDealReceivedResponseBody.getDetails();
            for (int i = 0; i < respDetails.length; ++i) {
                CreditDealReceivedDetail respdetail = respDetails[i];
                logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
                logger.error((Object)("DetailSeqId:" + respdetail.getDetailSeqId()));
                logger.error((Object)("CreditNo:" + respdetail.getCreditNo()));
                logger.error((Object)("ReceivedCreditNumber:" + respdetail.getReceivedCreditNumber()));
                logger.error((Object)("ApplicationItems:" + respdetail.getApplicationItems()));
                logger.error((Object)("RejectResult:" + respdetail.getRejectResult()));
                logger.error((Object)("RejectAmount:" + respdetail.getRejectAmount()));
                logger.error((Object)("RejectDate:" + respdetail.getRejectDate()));
                logger.error((Object)("EbStatus:" + respdetail.getEbStatus()));
                logger.error((Object)("getEbStatusMsg:" + respdetail.getEbStatusMsg()));
                logger.error((Object)("BankStatus:" + respdetail.getBankStatus()));
                logger.error((Object)("BankStatusMsg:" + respdetail.getBankStatusMsg()));
                logger.error((Object)("BankStatusName:" + respdetail.getBankStatusName()));
            }
        } else {
            logger.error((Object)(new Date() + "reject resoponse body is null"));
        }
        logger.error((Object)"----------after response end---------------------");
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedResponseBody;
        }
        EBException excetion = creditDealReceivedResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedResponseBody dealReceivedAcct(Context ctx, CreditDealReceivedAcceptVO creditDealReceivedAcceptVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditDealReceivedRequest request = new CreditDealReceivedRequest();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceived");
        header.setOperationName("dealReceived");
        header.setAccNo(creditDealReceivedAcceptVO.getAccNo());
        header.setCurrency(creditDealReceivedAcceptVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedRequestBody creditDealReceivedRequestBody = new CreditDealReceivedRequestBody();
        creditDealReceivedRequestBody.setBatchSeqId(creditDealReceivedAcceptVO.getBatchSeqId());
        creditDealReceivedRequestBody.setBatchBizNo(creditDealReceivedAcceptVO.getBatchBizNo());
        creditDealReceivedRequestBody.setTotalCount(creditDealReceivedAcceptVO.getTotalCount());
        CreditDealReceivedDetail[] details = new CreditDealReceivedDetail[]{};
        List<Object> acctList = new ArrayList();
        acctList = creditDealReceivedAcceptVO.getDetails();
        if (acctList.size() > 0) {
            details = new CreditDealReceivedDetail[acctList.size()];
        }
        for (int i = 0; i < acctList.size(); ++i) {
            CreditDealReceivedAcceptDetailVO creditDealReceivedAcceptDetailVO = (CreditDealReceivedAcceptDetailVO)acctList.get(i);
            CreditDealReceivedDetail creditDealReceivedDetail = new CreditDealReceivedDetail();
            creditDealReceivedDetail.setDetailSeqId(creditDealReceivedAcceptDetailVO.getDetailSeqId());
            creditDealReceivedDetail.setDetailBizNo(creditDealReceivedAcceptDetailVO.getDetailBizNo());
            creditDealReceivedDetail.setCreditNo(creditDealReceivedAcceptDetailVO.getCreditNo());
            creditDealReceivedDetail.setBranchNo(creditDealReceivedAcceptDetailVO.getBranchNo());
            creditDealReceivedDetail.setReceivedCreditNumber(creditDealReceivedAcceptDetailVO.getReceivedCreditNumber());
            creditDealReceivedDetail.setReferenceNum(creditDealReceivedAcceptDetailVO.getReferenceNum());
            creditDealReceivedDetail.setApplicant(creditDealReceivedAcceptDetailVO.getApplicant());
            creditDealReceivedDetail.setBeneficiary(creditDealReceivedAcceptDetailVO.getBeneficiary());
            creditDealReceivedDetail.setAmount(creditDealReceivedAcceptDetailVO.getAmount());
            creditDealReceivedDetail.setClaimAmount(creditDealReceivedAcceptDetailVO.getClaimAmount());
            creditDealReceivedDetail.setContractNo(creditDealReceivedAcceptDetailVO.getContractNo());
            creditDealReceivedDetail.setApplicationItems("3");
            creditDealReceivedDetail.setNote(creditDealReceivedAcceptDetailVO.getNote());
            creditDealReceivedDetail.setApplyDate(df.format(creditDealReceivedAcceptDetailVO.getApplyDate()));
            creditDealReceivedDetail.setUseCode("-1");
            details[i] = creditDealReceivedDetail;
        }
        creditDealReceivedRequestBody.setDetails(details);
        request.setBody(creditDealReceivedRequestBody);
        logger.error((Object)"----------before request start---------------------");
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditDealReceivedRequestBody bodyTemp = request.getBody();
        logger.error((Object)("BatchSeqId:" + bodyTemp.getBatchSeqId()));
        logger.error((Object)("TotalCount:" + bodyTemp.getTotalCount()));
        CreditDealReceivedDetail[] detailArray = creditDealReceivedRequestBody.getDetails();
        for (int i = 0; i < detailArray.length; ++i) {
            CreditDealReceivedDetail detail = detailArray[i];
            logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
            logger.error((Object)("DetailSeqId:" + detail.getDetailSeqId()));
            logger.error((Object)("EbSeqId\uff1a" + detail.getEbSeqId()));
            logger.error((Object)("CreditNo\uff1a" + detail.getCreditNo()));
            logger.error((Object)("ReceivedCreditNumber\uff1a" + detail.getReceivedCreditNumber()));
            logger.error((Object)("ApplicationItems:" + detail.getApplicationItems()));
        }
        logger.error((Object)"----------before request end---------------------");
        CreditDealReceivedResponse creditDealReceivedResponse = null;
        creditDealReceivedResponse = this.service.dealReceived(request);
        CreditDealReceivedResponseBody creditDealReceivedResponseBody = creditDealReceivedResponse.getBody();
        logger.error((Object)"----------after response start---------------------");
        logger.error((Object)("BatchSeqID:" + creditDealReceivedResponseBody.getBatchSeqID()));
        logger.error((Object)("TotalCount:" + creditDealReceivedResponseBody.getTotalCount()));
        CreditDealReceivedDetail[] respDetails = creditDealReceivedResponseBody.getDetails();
        for (int i = 0; i < respDetails.length; ++i) {
            CreditDealReceivedDetail respdetail = respDetails[i];
            logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
            logger.error((Object)("DetailSeqId:" + respdetail.getDetailSeqId()));
            logger.error((Object)("CreditNo:" + respdetail.getCreditNo()));
            logger.error((Object)("ReceivedCreditNumber:" + respdetail.getReceivedCreditNumber()));
            logger.error((Object)("ApplicationItems:" + respdetail.getApplicationItems()));
            logger.error((Object)("RejectResult:" + respdetail.getRejectResult()));
            logger.error((Object)("RejectAmount:" + respdetail.getRejectAmount()));
            logger.error((Object)("RejectDate:" + respdetail.getRejectDate()));
            logger.error((Object)("EbStatus:" + respdetail.getEbStatus()));
            logger.error((Object)("getEbStatusMsg:" + respdetail.getEbStatusMsg()));
            logger.error((Object)("BankStatus:" + respdetail.getBankStatus()));
            logger.error((Object)("BankStatusMsg:" + respdetail.getBankStatusMsg()));
            logger.error((Object)("BankStatusName:" + respdetail.getBankStatusName()));
        }
        logger.error((Object)"----------after response end---------------------");
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedResponseBody;
        }
        EBException excetion = creditDealReceivedResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedResponseBody dealReceivedPay(Context ctx, CreditDealReceivedPayVO creditDealReceivedPayVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditDealReceivedRequest request = new CreditDealReceivedRequest();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceived");
        header.setOperationName("dealReceived");
        header.setAccNo(creditDealReceivedPayVO.getAccNo());
        header.setCurrency(creditDealReceivedPayVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedRequestBody creditDealReceivedRequestBody = new CreditDealReceivedRequestBody();
        creditDealReceivedRequestBody.setBatchSeqId(creditDealReceivedPayVO.getBatchSeqId());
        creditDealReceivedRequestBody.setBatchBizNo(creditDealReceivedPayVO.getBatchBizNo());
        creditDealReceivedRequestBody.setTotalCount(creditDealReceivedPayVO.getTotalCount());
        CreditDealReceivedDetail[] details = new CreditDealReceivedDetail[]{};
        List<Object> payList = new ArrayList();
        payList = creditDealReceivedPayVO.getDetails();
        if (payList.size() > 0) {
            details = new CreditDealReceivedDetail[payList.size()];
        }
        for (int i = 0; i < payList.size(); ++i) {
            CreditDealReceivedPayDetailVO creditDealReceivedPayDetailVO = (CreditDealReceivedPayDetailVO)payList.get(i);
            CreditDealReceivedDetail creditDealReceivedDetail = new CreditDealReceivedDetail();
            creditDealReceivedDetail.setDetailSeqId(creditDealReceivedPayDetailVO.getDetailSeqId());
            creditDealReceivedDetail.setDetailBizNo(creditDealReceivedPayDetailVO.getDetailSeqId());
            creditDealReceivedDetail.setCreditNo(creditDealReceivedPayDetailVO.getCreditNo());
            creditDealReceivedDetail.setReceivedCreditNumber(creditDealReceivedPayDetailVO.getReceivedCreditNumber());
            creditDealReceivedDetail.setReferenceNum(creditDealReceivedPayDetailVO.getReferenceNum());
            creditDealReceivedDetail.setApplicant(creditDealReceivedPayDetailVO.getApplicant());
            creditDealReceivedDetail.setBranchNo(creditDealReceivedPayDetailVO.getBranchNo());
            creditDealReceivedDetail.setBeneficiary(creditDealReceivedPayDetailVO.getBeneficiary());
            creditDealReceivedDetail.setAmount(creditDealReceivedPayDetailVO.getAmount());
            creditDealReceivedDetail.setClaimAmount(creditDealReceivedPayDetailVO.getClaimAmount());
            creditDealReceivedDetail.setContractNo(creditDealReceivedPayDetailVO.getContractNo());
            if (!creditDealReceivedPayDetailVO.getIsForward()) {
                creditDealReceivedDetail.setApplicationItems("1");
            } else {
                creditDealReceivedDetail.setApplicationItems("2");
            }
            creditDealReceivedDetail.setNote(creditDealReceivedPayDetailVO.getNote());
            creditDealReceivedDetail.setApplyDate(df.format(creditDealReceivedPayDetailVO.getApplyDate()));
            creditDealReceivedDetail.setUseCode("-1");
            details[i] = creditDealReceivedDetail;
        }
        creditDealReceivedRequestBody.setDetails(details);
        request.setBody(creditDealReceivedRequestBody);
        CreditDealReceivedResponse creditDealReceivedResponse = null;
        EBHeader headerTemp = request.getHeader();
        logger.error((Object)"-----------------before query start---------amazing!----------------");
        logger.error((Object)("BizType:" + headerTemp.getBizType()));
        logger.error((Object)("SubBizType:" + headerTemp.getSubBizType()));
        logger.error((Object)("OperationName:" + headerTemp.getOperationName()));
        logger.error((Object)("AccNo:" + headerTemp.getAccNo()));
        logger.error((Object)("Currency:" + headerTemp.getCurrency()));
        CreditDealReceivedRequestBody bodyTemp = request.getBody();
        logger.error((Object)("BatchBizNo:" + bodyTemp.getBatchBizNo()));
        logger.error((Object)("BatchSeqId:" + bodyTemp.getBatchSeqId()));
        logger.error((Object)("TotalCount:" + bodyTemp.getTotalCount()));
        CreditDealReceivedDetail[] detailsTmp = bodyTemp.getDetails();
        for (int i = 0; i < detailsTmp.length; ++i) {
            logger.error((Object)("\u7b2c" + i + "\u4e2adetail\u7684\u6570\u636e"));
            CreditDealReceivedDetail detailTmp = detailsTmp[i];
            logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
            logger.error((Object)("BranchNo:" + detailTmp.getBranchNo()));
            logger.error((Object)("ApplyDate:" + detailTmp.getApplyDate()));
            logger.error((Object)("Beneficiary:" + detailTmp.getBeneficiary()));
            logger.error((Object)("DetailBizNo:" + detailTmp.getDetailBizNo()));
            logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
            logger.error((Object)("Applicant:" + detailTmp.getApplicant()));
            logger.error((Object)("ReceivedCreditNumber:" + detailTmp.getReceivedCreditNumber()));
            logger.error((Object)("ReferenceNum:" + detailTmp.getReferenceNum()));
            logger.error((Object)("Amount:" + detailTmp.getAmount()));
            logger.error((Object)("ClaimAmount:" + detailTmp.getClaimAmount()));
            logger.error((Object)("ContractNo:" + detailTmp.getContractNo()));
        }
        creditDealReceivedResponse = this.service.dealReceived(request);
        CreditDealReceivedResponseBody creditDealReceivedResponseBody = creditDealReceivedResponse.getBody();
        logger.error((Object)"-----------------before query end---------amazing!----------------");
        if (creditDealReceivedResponseBody != null) {
            logger.error((Object)"-----------------after query start-----------------------------");
            CreditDealReceivedDetail[] details1 = creditDealReceivedResponseBody.getDetails();
            for (int i = 0; i < details1.length; ++i) {
                logger.error((Object)("\u7b2c" + (i + 1) + "\u6761"));
                CreditDealReceivedDetail detailTmp = details1[i];
                logger.error((Object)("CreditNo:" + detailTmp.getCreditNo()));
                logger.error((Object)("BranchNo:" + detailTmp.getBranchNo()));
                logger.error((Object)("ApplyDate:" + detailTmp.getApplyDate()));
                logger.error((Object)("Beneficiary:" + detailTmp.getBeneficiary()));
                logger.error((Object)("DetailBizNo:" + detailTmp.getDetailBizNo()));
                logger.error((Object)("DetailSeqId:" + detailTmp.getDetailSeqId()));
                logger.error((Object)("Applicant:" + detailTmp.getApplicant()));
                logger.error((Object)("ReceivedCreditNumber:" + detailTmp.getReceivedCreditNumber()));
                logger.error((Object)("ReferenceNum:" + detailTmp.getReferenceNum()));
                logger.error((Object)("Amount:" + detailTmp.getAmount()));
                logger.error((Object)("ClaimAmount:" + detailTmp.getClaimAmount()));
                logger.error((Object)("ContractNo:" + detailTmp.getContractNo()));
            }
        } else {
            logger.error((Object)"queryresponsebody is null");
        }
        logger.error((Object)"-----------------after query end----------amazing!-----------");
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedResponseBody;
        }
        EBException excetion = creditDealReceivedResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedQueryResponseBody dealReceivedRejectQuery(Context ctx, DealReceivedRejectQueryVO dealReceivedRejectQueryVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditDealReceivedQueryRequest request = new CreditDealReceivedQueryRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceivedQuery");
        header.setOperationName("dealReceivedQuery");
        header.setAccNo(dealReceivedRejectQueryVO.getAccNo());
        header.setCurrency(dealReceivedRejectQueryVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedQueryRequestBody creditDealReceivedQueryRequestBody = new CreditDealReceivedQueryRequestBody();
        creditDealReceivedQueryRequestBody.setBatchSeqId(dealReceivedRejectQueryVO.getBatchSeqId());
        creditDealReceivedQueryRequestBody.setBatchBizNo(dealReceivedRejectQueryVO.getBatchBizNo());
        creditDealReceivedQueryRequestBody.setQueryType("reject");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        creditDealReceivedQueryRequestBody.setStartDate(df.format(dealReceivedRejectQueryVO.getStartDate()));
        creditDealReceivedQueryRequestBody.setEndDate(df.format(dealReceivedRejectQueryVO.getEndDate()));
        request.setBody(creditDealReceivedQueryRequestBody);
        CreditDealReceivedQueryResponse creditDealReceivedQueryResponse = null;
        creditDealReceivedQueryResponse = this.service.dealReceivedQuery(request);
        CreditDealReceivedQueryResponseBody creditDealReceivedQueryResponseBody = creditDealReceivedQueryResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedQueryResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedQueryResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedQueryResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedQueryResponseBody;
        }
        EBException excetion = creditDealReceivedQueryResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedQueryResponseBody dealReceivedAcceptQuery(Context ctx, DealReceivedAcceptQueryVO dealReceivedAcceptQueryVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditDealReceivedQueryRequest request = new CreditDealReceivedQueryRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceivedQuery");
        header.setOperationName("dealReceivedQuery");
        header.setAccNo(dealReceivedAcceptQueryVO.getAccNo());
        header.setCurrency(dealReceivedAcceptQueryVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedQueryRequestBody creditDealReceivedQueryRequestBody = new CreditDealReceivedQueryRequestBody();
        creditDealReceivedQueryRequestBody.setBatchSeqId(dealReceivedAcceptQueryVO.getBatchSeqId());
        creditDealReceivedQueryRequestBody.setBatchBizNo(dealReceivedAcceptQueryVO.getBatchBizNo());
        creditDealReceivedQueryRequestBody.setQueryType("accept");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        creditDealReceivedQueryRequestBody.setStartDate(df.format(dealReceivedAcceptQueryVO.getStartDate()));
        creditDealReceivedQueryRequestBody.setEndDate(df.format(dealReceivedAcceptQueryVO.getEndDate()));
        request.setBody(creditDealReceivedQueryRequestBody);
        CreditDealReceivedQueryResponse creditDealReceivedQueryResponse = null;
        logger.error((Object)"-----dealReceivedAcceptQuery before service-----");
        creditDealReceivedQueryResponse = this.service.dealReceivedQuery(request);
        logger.error((Object)"-----dealReceivedAcceptQuery end service-----");
        CreditDealReceivedQueryResponseBody creditDealReceivedQueryResponseBody = creditDealReceivedQueryResponse.getBody();
        logger.error((Object)("creditDealReceivedQueryResponseBody: " + creditDealReceivedQueryResponseBody));
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedQueryResponseBody)) {
            try {
                logger.error((Object)("batchPK: " + this.batchPK));
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedQueryResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedQueryResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedQueryResponseBody;
        }
        EBException excetion = creditDealReceivedQueryResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public CreditDealReceivedQueryResponseBody dealReceivedPayQuery(Context ctx, DealReceivedPayQueryVO dealReceivedpayQueryVO) throws RemoteException, BEException, ServiceException, FMException {
        if (this.service == null) {
            this.service = new EBCreditServiceUtil(ctx);
        }
        CreditDealReceivedQueryRequest request = new CreditDealReceivedQueryRequest();
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("credit");
        header.setSubBizType("dealReceivedQuery");
        header.setOperationName("dealReceivedQuery");
        header.setAccNo(dealReceivedpayQueryVO.getAccNo());
        header.setCurrency(dealReceivedpayQueryVO.getCurrency());
        request.setHeader(header);
        CreditDealReceivedQueryRequestBody creditDealReceivedQueryRequestBody = new CreditDealReceivedQueryRequestBody();
        creditDealReceivedQueryRequestBody.setBatchSeqId(dealReceivedpayQueryVO.getBatchSeqId());
        creditDealReceivedQueryRequestBody.setBatchBizNo(dealReceivedpayQueryVO.getBatchBizNo());
        creditDealReceivedQueryRequestBody.setQueryType("pay");
        if (!dealReceivedpayQueryVO.getIsForward()) {
            creditDealReceivedQueryRequestBody.setSubQueryType("payAtSight");
        } else {
            creditDealReceivedQueryRequestBody.setSubQueryType("payFoward");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        request.setBody(creditDealReceivedQueryRequestBody);
        CreditDealReceivedQueryResponse creditDealReceivedQueryResponse = null;
        creditDealReceivedQueryResponse = this.service.dealReceivedQuery(request);
        CreditDealReceivedQueryResponseBody creditDealReceivedQueryResponseBody = creditDealReceivedQueryResponse.getBody();
        if (!EmptyUtil.isEmpty((Object)creditDealReceivedQueryResponseBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, creditDealReceivedQueryResponse);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, creditDealReceivedQueryResponse);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return creditDealReceivedQueryResponseBody;
        }
        EBException excetion = creditDealReceivedQueryResponse.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }
}

