/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.QueryLinkPayRequest;
import com.kingdee.bos.ebservice.QueryLinkPayRequestBody;
import com.kingdee.bos.ebservice.QueryLinkPayResponse;
import com.kingdee.bos.ebservice.QueryLinkPayResponseBody;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

public class LinkPayQueryUtil
extends BaseEBGUtil {
    IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public QueryLinkPayResponseBody queryLinkPay(Context ctx, BankBizInfo bizInfo) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        QueryLinkPayRequestBody body = new QueryLinkPayRequestBody();
        body.setBatchSeqID(bizInfo.getSerialNumber());
        QueryLinkPayResponse response = service.queryLinkPay(this.parseLinkPayQueryRequest(ctx, bizInfo.getBankAcct(), body));
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        QueryLinkPayResponseBody resultBody = response.getBody();
        if (resultBody != null) {
            return resultBody;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.QUERYPAYERR, new Object[]{excetion.getMessage()});
    }

    public QueryLinkPayResponseBody queryLinkPay(Context ctx, BankBizInfo bizInfo, boolean isUrgent, QueryLinkPayResponse response, QueryLinkPayRequest request) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        QueryLinkPayRequestBody body = new QueryLinkPayRequestBody();
        if (isUrgent) {
            body.setReserved1("enforcequery");
        }
        body.setBatchSeqID(bizInfo.getSerialNumber());
        QueryLinkPayResponse resp = service.queryLinkPay(this.parseLinkPayQueryRequest(ctx, bizInfo.getBankAcct(), body, request));
        response.setBody(resp.getBody());
        response.setException(resp.getException());
        response.setHeader(resp.getHeader());
        response.setReserved1(resp.getReserved1());
        response.setReserved3(resp.getReserved3());
        response.setReserved2(resp.getReserved2());
        response.setReserveds(resp.getReserveds());
        QueryLinkPayResponseBody resultBody = resp.getBody();
        if (resultBody != null) {
            return resultBody;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.QUERYPAYERR, new Object[]{excetion.getMessage()});
    }

    public QueryLinkPayResponseBody queryLinkPay(Context ctx, BankBizInfo bizInfo, QueryLinkPayResponse response, QueryLinkPayRequest request) throws RemoteException, ServiceException, EASBizException, BOSException {
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        QueryLinkPayRequestBody body = new QueryLinkPayRequestBody();
        body.setBatchSeqID(bizInfo.getSerialNumber());
        QueryLinkPayResponse resp = service.queryLinkPay(this.parseLinkPayQueryRequest(ctx, bizInfo.getBankAcct(), body, request));
        response.setBody(resp.getBody());
        response.setException(resp.getException());
        response.setHeader(resp.getHeader());
        response.setReserved1(resp.getReserved1());
        response.setReserved3(resp.getReserved3());
        response.setReserved2(resp.getReserved2());
        response.setReserveds(resp.getReserveds());
        QueryLinkPayResponseBody resultBody = resp.getBody();
        if (resultBody != null) {
            return resultBody;
        }
        EBException excetion = response.getException();
        throw new EBGException(EBGException.QUERYPAYERR, new Object[]{excetion.getMessage()});
    }

    private QueryLinkPayRequest parseLinkPayQueryRequest(Context ctx, String BankAcct, QueryLinkPayRequestBody body) {
        QueryLinkPayRequest request = new QueryLinkPayRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct));
        request.setBody(body);
        try {
            BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return request;
    }

    private QueryLinkPayRequest parseLinkPayQueryRequest(Context ctx, String BankAcct, QueryLinkPayRequestBody body, QueryLinkPayRequest request) {
        request.setHeader(this.parseHeader(ctx, BankAcct));
        request.setBody(body);
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcct) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("pay");
        header.setSubBizType("pay");
        header.setOperationName("queryLinkPay");
        header.setAccNo(BankAcct);
        return header;
    }
}

