/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.LinkPayRequest;
import com.kingdee.bos.ebservice.LinkPayRequestBody;
import com.kingdee.bos.ebservice.LinkPayResponse;
import com.kingdee.bos.ebservice.LinkPayResponseBody;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class LinkPayUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(LinkPayUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public LinkPayResponseBody linkPay(Context ctx, LinkPayRequestBody body, BankBizInfo bizInfo, String currency) throws RemoteException, ServiceException, EASBizException, BOSException {
        logger.info((Object)("********linkPay " + body.getBatchSeqID() + " begin********"));
        EBGServiceUtil service = null;
        service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfo);
        LinkPayResponse response = service.linkPay(this.parseLinkPayRequest(ctx, bizInfo.getBankAcct(), body, currency));
        LinkPayResponseBody linkBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)linkBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u94f6\u4f01\u8fd4\u56de\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u94f6\u4f01\u8fd4\u56de\u62a5\u6587\u65f6\u5931\u8d25"), (Throwable)e);
            }
            logger.info((Object)("********linkPay " + body.getBatchSeqID() + " end********"));
            return linkBody;
        }
        if (response.getException() != null && response.getException().getErrorCode() != null && response.getException().getErrorCode().equalsIgnoreCase("pre")) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u5f02\u5e38\uff1a" + response.getException()));
            throw new BEException(BEException.COMMON, new Object[]{response.getException().getMessage()});
        }
        if (response.getException() != null && response.getException().getMessage().startsWith("\u4f7f\u7528\u4e86\u94f6\u4f01\u4e2d\u95f4\u4ef6\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7")) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de\u5f02\u5e38\uff1a" + response.getException()));
            throw new BEException(BEException.COMMON, new Object[]{response.getException().getMessage()});
        }
        logger.error((Object)("********pay " + body.getBatchSeqID() + " exception :" + response.getException().getMessage() + "********"));
        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{response.getException().getMessage()});
    }

    private LinkPayRequest parseLinkPayRequest(Context ctx, String BankAcc, LinkPayRequestBody body, String currency) {
        LinkPayRequest request = new LinkPayRequest();
        request.setHeader(this.parseHeader(ctx, BankAcc, currency));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u53d1\u9001\u94f6\u4f01\u62a5\u6587\u65f6\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u6279\u6b21\u53f7\uff1a" + body.getBatchSeqID() + "\u62fc\u88c5EAS\u53d1\u9001\u94f6\u4f01\u62a5\u6587\u65f6\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String BankAcc, String currency) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("pay");
        header.setSubBizType("pay");
        header.setOperationName("linkPay");
        header.setAccNo(BankAcc);
        header.setCurrency(currency);
        return header;
    }
}

