/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NotePayableBody;
import com.kingdee.bos.ebservice.NotePayableDetail;
import com.kingdee.bos.ebservice.NotePayableRequest;
import com.kingdee.bos.ebservice.NotePayableResponse;
import com.kingdee.bos.ebservice.QueryNotePayableRequest;
import com.kingdee.bos.ebservice.QueryNotePayableRequestBody;
import com.kingdee.bos.ebservice.QueryNotePayableResponse;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGNoteServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class NotePayableOpUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(NotePayableOpUtil.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public NotePayableDetail[] notePayableOp(Context ctx, String subBizType, String accNo, NotePayableBody body) throws ServiceException, BEException, RemoteException, EASBizException, BOSException {
        EBGNoteServiceUtil service = null;
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(accNo);
        try {
            if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                if (service == null) {
                    service = new EBGNoteServiceUtil(ctx);
                }
            } else {
                service = new EBGNoteServiceUtil(ctx, bizInfo);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        NotePayableResponse response = service.notePayableOp(this.parseNotePayableRequest(ctx, subBizType, accNo, body));
        NotePayableBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNotePayableDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NotePayableRequest parseNotePayableRequest(Context ctx, String subBizType, String accNo, NotePayableBody body) {
        NotePayableRequest request = new NotePayableRequest();
        request.setHeader(this.parseHeader(ctx, subBizType, accNo));
        request.setBody(body);
        return request;
    }

    private EBHeader parseHeader(Context ctx, String subBizType, String accNo) {
        EBHeader header = super.parseHeader(ctx);
        if ("remit_register".equals(subBizType)) {
            header.setSubBizType("remit_register");
        } else if ("remit_revocation".equals(subBizType)) {
            header.setSubBizType("remit_revocation");
        } else if ("remit_accept".equals(subBizType)) {
            header.setSubBizType("remit_accept");
        } else if ("remit_receive".equals(subBizType)) {
            header.setSubBizType("remit_receive");
        } else if ("note_cancle".equals(subBizType)) {
            header.setSubBizType("note_cancle");
        } else if ("remit_confirm".equals(subBizType)) {
            header.setSubBizType("remit_confirm");
        }
        header.setBizType("notePayable");
        header.setOperationName("notePayableOp");
        header.setAccNo(accNo);
        return header;
    }

    public NotePayableDetail[] queryNotePayable(Context ctx, String accNo, QueryNotePayableRequestBody queryBody) throws RemoteException, ServiceException, BEException {
        EBGNoteServiceUtil service = null;
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(accNo);
        try {
            if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                if (service == null) {
                    service = new EBGNoteServiceUtil(ctx);
                }
            } else {
                service = new EBGNoteServiceUtil(ctx, bizInfo);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        QueryNotePayableResponse response = service.queryNotePayable(this.parseQueryRequest(ctx, accNo, queryBody));
        NotePayableBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNotePayableDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private QueryNotePayableRequest parseQueryRequest(Context ctx, String accNo, QueryNotePayableRequestBody queryBody) {
        QueryNotePayableRequest queryRequest = new QueryNotePayableRequest();
        queryRequest.setHeader(this.parseQueryHeader(ctx, accNo));
        queryRequest.setBody(queryBody);
        return queryRequest;
    }

    private EBHeader parseQueryHeader(Context ctx, String accNo) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("queryNotePayable");
        header.setSubBizType("queryNotePayable");
        header.setOperationName("queryNotePayable");
        header.setAccNo(accNo);
        return header;
    }
}

