/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NoteInfoDetail;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteReceivableRequest;
import com.kingdee.bos.ebservice.NoteReceivableResponse;
import com.kingdee.bos.ebservice.QueryNoteInfoRequst;
import com.kingdee.bos.ebservice.QueryNoteInfoResponse;
import com.kingdee.bos.ebservice.QueryNoteInfoResponseBody;
import com.kingdee.bos.ebservice.QueryNoteReceivableInfoRequest;
import com.kingdee.bos.ebservice.QueryNoteReceivableInfoResponse;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGNoteServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class NoteReceivableOpUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(NoteReceivableOpUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;
    private EBGNoteServiceUtil service;
    private Context ctx;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public NoteReceivableOpUtil() {
    }

    public NoteReceivableOpUtil(Context ctx) throws EASBizException {
        this.ctx = ctx;
        try {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    public NoteReceivableDetail[] noteRecOp(Context ctx, NoteBizInfo bizInfo, NoteReceivableBody body) throws RemoteException, BEException, ServiceException, FMException {
        BankBizInfo bizInfo1 = new BankBizInfo();
        bizInfo1.setBankAcct(bizInfo.getBankAcct());
        try {
            if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                if (this.service == null) {
                    this.service = new EBGNoteServiceUtil(ctx);
                }
            } else {
                this.service = new EBGNoteServiceUtil(ctx, bizInfo);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        NoteReceivableResponse response = this.service.noteRecOp(this.parsePayRequest(ctx, bizInfo.getBankAcct(), body, bizInfo.getNoteType()));
        NoteReceivableBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNoteReceiableDetail();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteReceivableRequest parsePayRequest(Context ctx, String BankAcct, NoteReceivableBody body, NoteTypeEnum noteType) {
        NoteReceivableRequest request = new NoteReceivableRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, noteType));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String bankAcct, NoteTypeEnum noteType) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("noteReceivable");
        if (NoteTypeEnum.ENDORSEMENT_BILL.equals((Object)noteType)) {
            header.setSubBizType("note_endorse");
        } else if (NoteTypeEnum.DISCOUNT_BILL.equals((Object)noteType)) {
            header.setSubBizType("note_discount");
        } else if (NoteTypeEnum.DRAFT_SIGNIN.equals((Object)noteType)) {
            header.setSubBizType("note_signin");
        } else if (NoteTypeEnum.NOTE_PLEDGE.equals((Object)noteType)) {
            header.setSubBizType("pledge_note");
        } else if (NoteTypeEnum.COLLECTREGISTER_BILL.equals((Object)noteType)) {
            header.setSubBizType("present_payment");
        } else if (NoteTypeEnum.NOTE_CANCLE.equals((Object)noteType)) {
            header.setSubBizType("note_cancle");
        } else if (NoteTypeEnum.REMOVE_PLEDGE.equals((Object)noteType)) {
            header.setSubBizType("remove_pledge");
        }
        header.setOperationName("noteRecOp");
        header.setAccNo(bankAcct);
        return header;
    }

    public NoteReceivableDetail[] queryNoteReceivable(Context ctx, String accNo, NoteReceivableBody body) throws BEException, RemoteException, ServiceException {
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(accNo);
        try {
            if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                if (this.service == null) {
                    this.service = new EBGNoteServiceUtil(ctx);
                }
            } else {
                this.service = new EBGNoteServiceUtil(ctx, bizInfo);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        QueryNoteReceivableInfoResponse response = this.service.queryNoteRec(this.parseQueryRecRequest(ctx, accNo, body));
        NoteReceivableBody resultBody = response.getBody();
        String subBizType = response.getHeader().getSubBizType();
        logger.equals("\u540c\u6b65\u72b6\u6001\uff0c\u83b7\u53d6\u64cd\u4f5cresponse.getHeader().getSubBizType()" + subBizType);
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            for (NoteReceivableDetail noteReceivableDetail : resultBody.getNoteReceiableDetail()) {
                noteReceivableDetail.setReservedFiled2(subBizType);
                logger.error((Object)("noteReceivableDetail.getReservedFiled2 = " + noteReceivableDetail.getReservedFiled2()));
            }
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNoteReceiableDetail();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private QueryNoteReceivableInfoRequest parseQueryRecRequest(Context ctx, String accNo, NoteReceivableBody body) {
        QueryNoteReceivableInfoRequest request = new QueryNoteReceivableInfoRequest();
        request.setBody(body);
        request.setHeader(this.parseQueryHeader(ctx, accNo));
        return request;
    }

    private EBHeader parseQueryHeader(Context ctx, String accNo) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("queryNoteReceivable");
        header.setSubBizType("queryNoteReceivable");
        header.setOperationName("queryNoteRec");
        header.setAccNo(accNo);
        return header;
    }

    public NoteInfoDetail[] queryNoteInfo(Context ctx, QueryNoteInfoRequst request) throws ServiceException, RemoteException, BEException {
        QueryNoteInfoResponse response;
        QueryNoteInfoResponseBody resultBody;
        if (this.service == null) {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        if (!EmptyUtil.isEmpty((Object)(resultBody = (response = this.service.queryNoteInfo(request)).getBody()))) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }
}

