/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.ebservice.NoteStatusUpdateRequest;
import com.kingdee.bos.ebservice.NoteStatusUpdateResponse;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGNoteServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class NoteUpdateStautsUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(NoteUpdateStautsUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public NoteStatusDetail[] updateNoteStatus(Context ctx, String subBizType, NoteStatusBody body, NoteBizInfo bizInfo) throws RemoteException, BEException, ServiceException, FMException {
        EBGNoteServiceUtil service = null;
        BankBizInfo bizInfo1 = new BankBizInfo();
        bizInfo1.setBankAcct(bizInfo.getBankAcct());
        try {
            if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                if (service == null) {
                    service = new EBGNoteServiceUtil(ctx);
                }
            } else {
                service = new EBGNoteServiceUtil(ctx, bizInfo);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        NoteStatusUpdateResponse response = service.updateNoteStatus(this.parseUpdateRequest(ctx, body, subBizType));
        NoteStatusBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public NoteStatusDetail[] updateNoteStatus(Context ctx, String subBizType, NoteStatusBody body) throws RemoteException, BEException, ServiceException, FMException {
        EBGNoteServiceUtil service = new EBGNoteServiceUtil(ctx);
        NoteStatusUpdateResponse response = service.updateNoteStatus(this.parseUpdateRequest(ctx, body, subBizType));
        NoteStatusBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteStatusUpdateRequest parseUpdateRequest(Context ctx, NoteStatusBody body, String subBizType) {
        NoteStatusUpdateRequest request = new NoteStatusUpdateRequest();
        request.setHeader(this.parseHeader(ctx, subBizType));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String subBizType) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("updateNoteStatus");
        if (EmptyUtil.isEmpty((String)subBizType)) {
            header.setSubBizType("default");
        } else {
            header.setSubBizType(subBizType);
        }
        header.setOperationName("updateNoteStatus");
        return header;
    }
}

