/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NoteDetail;
import com.kingdee.bos.ebservice.NoteDetailRequest;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteDetailResponse;
import com.kingdee.bos.ebservice.NoteDetailResponseBody;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteReceivableRequest;
import com.kingdee.bos.ebservice.NoteReceivableResponse;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.ebservice.NoteStatusUpdateRequest;
import com.kingdee.bos.ebservice.NoteStatusUpdateResponse;
import com.kingdee.bos.ebservice.QueryNoteReceivableInfoRequest;
import com.kingdee.bos.ebservice.QueryNoteReceivableInfoResponse;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.PaperNoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGNoteServiceUtil;
import com.kingdee.eas.fm.be.app.util.PaperNoteBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class PaperNoteRecOpUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(PaperNoteRecOpUtil.class);
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;
    private EBGNoteServiceUtil service;
    private Context ctx;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public PaperNoteRecOpUtil() {
    }

    public PaperNoteRecOpUtil(Context ctx) throws EASBizException {
        this.ctx = ctx;
        try {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    public NoteReceivableDetail[] paperNoteRecOp(Context ctx, PaperNoteBizInfo bizInfo, NoteReceivableBody body) throws RemoteException, BEException, ServiceException, FMException {
        NoteReceivableResponse response;
        NoteReceivableBody resultBody;
        if (this.service == null) {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        if (!EmptyUtil.isEmpty((Object)(resultBody = (response = this.service.paperNoteRecOp(this.parseNoteRequest(ctx, bizInfo.getBankAcct(), body, bizInfo.getNoteType()))).getBody()))) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNoteReceiableDetail();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteReceivableRequest parseNoteRequest(Context ctx, String BankAcct, NoteReceivableBody body, PaperNoteTypeEnum noteType) {
        NoteReceivableRequest request = new NoteReceivableRequest();
        request.setHeader(this.parseHeader(ctx, BankAcct, noteType));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String bankAcct, PaperNoteTypeEnum noteType) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("paperNote");
        if (PaperNoteTypeEnum.DISCOUNT_APPLY.equals((Object)noteType)) {
            header.setSubBizType("discount");
        } else if (PaperNoteTypeEnum.OUT_TRUSTEEPOOL.equals((Object)noteType)) {
            header.setSubBizType("out_pool");
        }
        header.setOperationName("paperNoteRecOp");
        header.setAccNo(bankAcct);
        return header;
    }

    public NoteReceivableDetail[] queryPaperNoteRec(Context ctx, String accNo, NoteReceivableBody body) throws BEException, RemoteException, ServiceException {
        QueryNoteReceivableInfoResponse response;
        NoteReceivableBody resultBody;
        if (this.service == null) {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        if (!EmptyUtil.isEmpty((Object)(resultBody = (response = this.service.queryPaperNoteRec(this.parseQueryRecRequest(ctx, accNo, body))).getBody()))) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getNoteReceiableDetail();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    public NoteDetail[] queryPaperNoteDetail(Context ctx, String accNo, String isoCode, NoteDetailRequestBody body) throws BEException, RemoteException, ServiceException {
        NoteDetailResponse response;
        NoteDetailResponseBody resultBody;
        if (this.service == null) {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        if (!EmptyUtil.isEmpty((Object)(resultBody = (response = this.service.queryPaperNoteDetail(this.parseNoteDetailRequest(ctx, accNo, isoCode, body))).getBody()))) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteDetailRequest parseNoteDetailRequest(Context ctx, String accNo, String isoCode, NoteDetailRequestBody body) {
        NoteDetailRequest request = new NoteDetailRequest();
        request.setBody(body);
        request.setHeader(this.parseQueryNoteDetailHeader(ctx, accNo, isoCode));
        return request;
    }

    private QueryNoteReceivableInfoRequest parseQueryRecRequest(Context ctx, String accNo, NoteReceivableBody body) {
        QueryNoteReceivableInfoRequest request = new QueryNoteReceivableInfoRequest();
        request.setBody(body);
        request.setHeader(this.parseQueryHeader(ctx, accNo));
        return request;
    }

    private EBHeader parseQueryHeader(Context ctx, String accNo) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("queryPaperNoteReceivable");
        header.setSubBizType("queryPaperNoteReceivable");
        header.setOperationName("queryPaperNoteRec");
        header.setAccNo(accNo);
        return header;
    }

    private EBHeader parseQueryNoteDetailHeader(Context ctx, String accNo, String isoCode) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("queryPaperNoteDetail");
        header.setSubBizType("default");
        header.setOperationName("queryPaperNoteDetail");
        header.setAccNo(accNo);
        header.setCurrency(isoCode);
        return header;
    }

    public NoteStatusDetail[] updatePaperNoteStatus(Context ctx, String subBizType, NoteStatusBody body) throws RemoteException, BEException, ServiceException, FMException {
        NoteStatusUpdateResponse response;
        NoteStatusBody resultBody;
        if (this.service == null) {
            this.service = new EBGNoteServiceUtil(ctx);
        }
        if (!EmptyUtil.isEmpty((Object)(resultBody = (response = this.service.updatePaperNoteStatus(this.parseUpdateRequest(ctx, body, subBizType))).getBody()))) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody.getDetails();
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteStatusUpdateRequest parseUpdateRequest(Context ctx, NoteStatusBody body, String subBizType) {
        NoteStatusUpdateRequest request = new NoteStatusUpdateRequest();
        request.setHeader(this.parseUpdateHeader(ctx, subBizType));
        request.setBody(body);
        try {
            if (this.batchPK == null) {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequest(this.pk, request);
            } else {
                BankLogFacadeFactory.getLocalInstance(ctx).buildRequestBatch(this.batchPK, request);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return request;
    }

    protected EBHeader parseUpdateHeader(Context ctx, String subBizType) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("updatePaperNoteStatus");
        if (EmptyUtil.isEmpty((String)subBizType)) {
            header.setSubBizType("default");
        } else {
            header.setSubBizType(subBizType);
        }
        header.setOperationName("updatePaperNoteStatus");
        return header;
    }
}

