/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.PingDetail;
import com.kingdee.bos.ebservice.PingRequest;
import com.kingdee.bos.ebservice.PingRequestBody;
import com.kingdee.bos.ebservice.PingResponse;
import com.kingdee.bos.ebservice.PingResponseBody;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class PingUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(BaseEBGUtil.class);
    private IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public PingResponseBody getPing(Context ctx, BankBizInfo[] bizInfos) {
        try {
            EBGServiceUtil service = null;
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGServiceUtil(ctx) : new EBGServiceUtil(ctx, bizInfos[0]);
            PingResponse response = service.getPing(this.parsePingRequest(ctx, bizInfos));
            PingResponseBody body = response.getBody();
            if (!EmptyUtil.isEmpty((Object)body)) {
                return body;
            }
            return null;
        }
        catch (BEException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        catch (FMException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    private PingRequest parsePingRequest(Context ctx, BankBizInfo[] bizInfos) {
        PingRequest request = new PingRequest();
        request.setHeader(this.parseHeader(ctx, bizInfos[0]));
        request.setBody(this.parseBody(ctx, bizInfos));
        return request;
    }

    protected EBHeader parseHeader(Context ctx, BankBizInfo bizInfo) {
        EBHeader header = super.parseHeader(ctx);
        header.setBizType("ping");
        header.setSubBizType("ping");
        header.setOperationName("ping");
        header.setCurrency("CNY");
        header.setAccNo(bizInfo.getBankAcct());
        return header;
    }

    protected PingRequestBody parseBody(Context ctx, BankBizInfo[] bizInfos) {
        PingRequestBody body = new PingRequestBody();
        PingDetail[] details = new PingDetail[bizInfos.length];
        for (int i = 0; i < bizInfos.length; ++i) {
            PingDetail detail = new PingDetail();
            detail.setAccNo(bizInfos[i].getBankAcct());
            details[i] = detail;
        }
        body.setDetails(details);
        return body;
    }
}

