/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.NoteDetailRequest;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteDetailResponse;
import com.kingdee.bos.ebservice.NoteDetailResponseBody;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGNoteServiceUtil;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class QueryNoteDetailUtil
extends BaseEBGUtil {
    private static final Logger logger = CoreUIObject.getLogger(QueryNoteDetailUtil.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    IObjectPK pk = null;
    Map<String, IObjectPK> batchPK = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public Map<String, IObjectPK> getBatchPK() {
        return this.batchPK;
    }

    public void setBatchPK(Map<String, IObjectPK> batchPK) {
        this.batchPK = batchPK;
    }

    public NoteDetailResponseBody queryNoteDetail(Context ctx, String accNo, String subBizType, NoteDetailRequestBody body) throws ServiceException, RemoteException, BEException {
        EBGNoteServiceUtil service = null;
        BankBizInfo bizInfo = new BankBizInfo();
        bizInfo.setBankAcct(accNo);
        try {
            service = FmBeHelper.isNotExistsMulBeService(ctx) ? new EBGNoteServiceUtil(ctx) : new EBGNoteServiceUtil(ctx, bizInfo);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        NoteDetailResponse response = service.queryNoteDetail(this.parseDetailRequest(ctx, accNo, subBizType, body));
        NoteDetailResponseBody resultBody = response.getBody();
        if (!EmptyUtil.isEmpty((Object)resultBody)) {
            try {
                if (this.batchPK == null) {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponse(this.pk, response);
                } else {
                    BankLogFacadeFactory.getLocalInstance(ctx).buildResponseBatch(this.batchPK, response);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return resultBody;
        }
        EBException excetion = response.getException();
        throw new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
    }

    private NoteDetailRequest parseDetailRequest(Context ctx, String accNo, String subBizType, NoteDetailRequestBody body) {
        NoteDetailRequest request = new NoteDetailRequest();
        request.setHeader(this.parseHeader(ctx, accNo, subBizType));
        request.setBody(body);
        return request;
    }

    private EBHeader parseHeader(Context ctx, String accNo, String subBizType) {
        EBHeader header = super.parseHeader(ctx);
        header.setAccNo(accNo);
        header.setCurrency("CNY");
        header.setBizType("queryNoteDetail");
        header.setSubBizType(subBizType);
        header.setOperationName("queryNoteDetail");
        return header;
    }
}

