/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ebgateway.common.VirtualInfo;
import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.PositionRequest;
import com.kingdee.bos.ebservice.PositionRequestBody;
import com.kingdee.bos.ebservice.PositionRequestInfo;
import com.kingdee.bos.ebservice.PositionResponse;
import com.kingdee.bos.ebservice.PositionResponseInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.service.BaseEBGUtil;
import com.kingdee.eas.fm.be.app.service.EBGServiceUtil;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class VirtualDetailToolUtil
extends BaseEBGUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.service.VirtualDetailUtil");
    IObjectPK pk = null;

    public IObjectPK getPk() {
        return this.pk;
    }

    public void setPk(IObjectPK pk) {
        this.pk = pk;
    }

    public VirtualInfo[] getVirtualDetails(Context ctx, VirtualInfo[] virtualInfos, Map result) throws EASBizException, BOSException {
        block19: {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] queryAccount = new String[virtualInfos.length];
            for (int i = virtualInfos.length - 1; i >= 0; --i) {
                if (EmptyUtil.isEmpty((Object)virtualInfos[i])) continue;
                queryAccount[i] = virtualInfos[i].getAcnt().getAcntNumber();
                if (map.containsKey(virtualInfos[i].getAcnt().getAcntNumber())) continue;
                map.put(virtualInfos[i].getAcnt().getAcntNumber(), String.valueOf(i));
            }
            try {
                EBGServiceUtil service = new EBGServiceUtil(ctx);
                logger.info((Object)"\u5f00\u59cb\u6b63\u5f0f\u8c03\u7528\u94f6\u4f01\u5e73\u53f0");
                PositionRequest positionRequest = this.parsePositionRequest(ctx, virtualInfos);
                PositionResponse response = service.position(positionRequest);
                logger.info((Object)"\u7ed3\u675f\u6b63\u5f0f\u8c03\u7528\u94f6\u4f01\u5e73\u53f0");
                try {
                    logger.info((Object)("body:" + response.getBody()));
                    logger.info((Object)("exception:" + response.getException().toString()));
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
                if (response.getBody() != null) {
                    PositionResponseInfo[] info = response.getBody().getPositionResponseInfos();
                    for (int i = 0; i < info.length; ++i) {
                        if (EmptyUtil.isEmpty((String)info[i].getAccNo()) || !map.containsKey(info[i].getAccNo())) continue;
                        int j = Integer.parseInt((String)map.get(info[i].getAccNo()));
                        if (!EmptyUtil.isEmpty((String)info[i].getAvailableBalance())) {
                            virtualInfos[j].setAviBalance(new BigDecimal(info[i].getAvailableBalance()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getCurrentBalance())) {
                            virtualInfos[j].setBalance(new BigDecimal(info[i].getCurrentBalance()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getBankLimit())) {
                            virtualInfos[j].setBankLimit(new BigDecimal(info[i].getBankLimit()));
                        }
                        virtualInfos[j].setCurrency(info[i].getCurrency());
                        virtualInfos[j].setAcntType(info[i].getAccType());
                        if (!EmptyUtil.isEmpty((String)info[i].getOverdraftLimit())) {
                            virtualInfos[j].setOverdraftLimit(new BigDecimal(info[i].getOverdraftLimit()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getOverdraftRate())) {
                            virtualInfos[j].setOverdraftRate(new BigDecimal(info[i].getOverdraftRate()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getSurplusBankLimit())) {
                            virtualInfos[j].setSurplusBankLimit(new BigDecimal(info[i].getSurplusBankLimit()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getSurplusOverdraftLimit())) {
                            virtualInfos[j].setSurplusOverdraftLimit(new BigDecimal(info[i].getSurplusOverdraftLimit()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getUsedBankLimit())) {
                            virtualInfos[j].setUsedBankLimit(new BigDecimal(info[i].getUsedBankLimit()));
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getUsedOverdraftLimit())) {
                            virtualInfos[j].setUsedOverdraftLimit(new BigDecimal(info[i].getUsedOverdraftLimit()));
                        }
                        if (!EmptyUtil.isEmpty((Object)info[i].getBalanceDate())) {
                            virtualInfos[j].setVirtualDate(info[i].getBalanceDate().getTime());
                        }
                        if (!EmptyUtil.isEmpty((String)info[i].getLastDayBalance())) {
                            virtualInfos[j].setPreBalance(new BigDecimal(info[i].getLastDayBalance()));
                        }
                        virtualInfos[j].setReserved1(info[i].getReserved1());
                    }
                    break block19;
                }
                EBException excetion = response.getException();
                result.put("errorMsg", excetion.getMessage());
                logger.info((Object)("\u865a\u62df\u73b0\u91d1\u6c60\u8c03\u7528\u94f6\u4f01\u5e73\u53f0:" + excetion.getMessage()));
                BEException beException = new BEException(BEException.COMMON, new Object[]{excetion.getMessage()});
                throw beException;
            }
            catch (RemoteException e) {
                logger.error((Object)"get VirtualCapitalPool failure! exception message is:", (Throwable)e);
                throw new BEException(BEException.VIRTUALCAPIRALPOLL, new Object[]{e.getMessage()});
            }
            catch (ServiceException e) {
                logger.error((Object)"get VirtualCapitalPool failure! exception message is:", (Throwable)e);
                throw new BEException(BEException.VIRTUALCAPIRALPOLL, new Object[]{e.getMessage()});
            }
        }
        return virtualInfos;
    }

    private PositionRequest parsePositionRequest(Context ctx, VirtualInfo[] virtualInfos) {
        PositionRequest request = new PositionRequest();
        request.setHeader(this.parseHeader(ctx, virtualInfos[0].getAcnt().getAcntNumber()));
        PositionRequestBody body = new PositionRequestBody();
        PositionRequestInfo[] positionRequestInfos = new PositionRequestInfo[virtualInfos.length];
        for (int i = 0; i < virtualInfos.length; ++i) {
            positionRequestInfos[i] = new PositionRequestInfo();
            positionRequestInfos[i].setAccNo(virtualInfos[i].getAcnt().getAcntNumber());
            positionRequestInfos[i].setAccType(virtualInfos[i].getAcntType());
            positionRequestInfos[i].setCurrency(virtualInfos[i].getCurrency());
            positionRequestInfos[i].setOverdraftRate(virtualInfos[i].getOverdraftRate().toString());
            if (virtualInfos[i].getUpAcnt() != null) {
                positionRequestInfos[i].setUpAccNo(virtualInfos[i].getUpAcnt().getAcntNumber());
                continue;
            }
            positionRequestInfos[i].setUpAccNo(null);
        }
        body.setPositionRequestInfos(positionRequestInfos);
        request.setBody(body);
        return request;
    }

    protected EBHeader parseHeader(Context ctx, String accNo) {
        EBHeader header = super.parseHeader(ctx);
        header.setMessageType("request");
        header.setBizType("position");
        header.setSubBizType("position");
        header.setOperationName("position");
        header.setAccNo(accNo);
        return header;
    }
}

