/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CurrentToFixedRequestBody;
import com.kingdee.bos.ebservice.FixedToCurrentRequestBody;
import com.kingdee.bos.ebservice.LinkPayDetail;
import com.kingdee.bos.ebservice.LinkPayRequestBody;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ebservice.QueryFixedRequestBody;
import com.kingdee.bos.ebservice.QueryLinkPayRequestBody;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankPayingStatusEnum;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.app.BankFacadeControllerBeanEx;
import com.kingdee.eas.fm.be.app.util.BizConstant;
import com.kingdee.eas.fm.be.app.util.RegularBizInfo;
import com.kingdee.eas.fm.be.app.util.Sequence;
import com.kingdee.eas.fm.nt.BankDraftReqInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.rpc.ServiceException;

public class beServiceHelper {
    private static final String resourcePath = "com.kingdee.eas.fm.be.BEAutoGenerateResource";

    public static PayBody parseBankPayBody(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        PayBody body = new PayBody();
        body.setBatchSeqID(info.getSerialNumber());
        body.setTotalAmount(String.valueOf(info.getPayAmount().setScale(2, 4)));
        body.setTotalCount("1");
        body.setVerifyField("pay");
        body.setDetails(beServiceHelper.parseBankPayDetail(ctx, info));
        return body;
    }

    public static PayBody parseBankTransUpBody(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PayBody body = new PayBody();
        body.setBatchSeqID(entryInfo.getSerialNumber());
        body.setTotalAmount(String.valueOf(entryInfo.getAmount().setScale(2, 4)));
        body.setTotalCount("1");
        body.setVerifyField("pay");
        body.setDetails(beServiceHelper.parseBankTransUpDetail(ctx, info, entryInfo));
        return body;
    }

    public static PayBody parseBankTransDownBody(Context ctx, BankTransDownBillInfo info) throws EASBizException, BOSException {
        PayBody body = new PayBody();
        body.setBatchSeqID(info.getSerialNumber());
        body.setTotalAmount(String.valueOf(info.getTotalAmt().setScale(2, 4)));
        body.setTotalCount(String.valueOf(info.getEntrys().size()));
        body.setVerifyField("pay");
        body.setDetails(beServiceHelper.parseBankTransDownDetail(ctx, info));
        return body;
    }

    public static PayBody parseAgencySalaryBody(Context ctx, BankAgentPayBillInfo info) throws EASBizException, BOSException {
        PayBody body = new PayBody();
        body.setBatchSeqID(info.getSerialNumber());
        body.setTotalAmount(String.valueOf(info.getAmount().setScale(2, 4)));
        body.setTotalCount(String.valueOf(info.getCount()));
        body.setVerifyField("pay");
        body.setDetails(beServiceHelper.parseAgencySalaryDetail(ctx, info));
        return body;
    }

    public static PaymentDetail[] parseAgencySalaryDetail(Context ctx, BankAgentPayBillInfo info) throws EASBizException, BOSException {
        HashMap<String, String> bankNoMap = new HashMap<String, String>();
        PaymentDetail[] details = new PaymentDetail[info.getEntrys().size()];
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BankAgentPayBillEntryInfo entryInfo = info.getEntrys().get(i);
            PaymentDetail detail = new PaymentDetail();
            detail.setDetailSeqID(entryInfo.getSerialNumber());
            detail.setDetailBizNo(entryInfo.getSrcBillID());
            detail.setPayeeAccName(entryInfo.getRecName());
            detail.setPayeeAccNo(entryInfo.getRecBankAccount());
            detail.setPayeeBankName(entryInfo.getRecBankName());
            detail.setPayeeBankAddr(entryInfo.getRecCity());
            if (entryInfo.getRecBankName() != null) {
                String item = "";
                String key = entryInfo.getRecBankName();
                if (bankNoMap.containsKey(key)) {
                    item = (String)bankNoMap.get(key);
                } else {
                    item = BEBankFactory.getLocalInstance((Context)ctx).getBankNo(key);
                    bankNoMap.put(key, item);
                }
                detail.setPayeeCnapsCode(item);
            }
            detail.setPayeeCountry(EASCommonResource.getString((String)resourcePath, (String)"7_BankFacadeControllerBean", (Locale)ctx.getLocale()));
            detail.setPayeeProvince(entryInfo.getRecProvince());
            detail.setPayeeCity(entryInfo.getRecCity());
            detail.setAmount(String.valueOf(entryInfo.getAmount().setScale(2, 4)));
            detail.setUrgent(info.isIsEmergency() ? "TRUE" : "FALSE");
            detail.setUseCode("-1");
            detail.setUse("\u5de5\u8d44");
            detail.setDesc(info.getUsage());
            detail.setVerifyField("pay");
            detail.setPayeeType("individual");
            detail.setReserved1(info.isIsAgencyPersonPay() ? "true" : "false");
            if (!EmptyUtil.isEmpty((Object)((Object)entryInfo.getCertType())) && !EmptyUtil.isEmpty((String)entryInfo.getCertNum())) {
                String[] reserveds = new String[]{"certType=" + entryInfo.getCertType().getValue(), "certNum=" + entryInfo.getCertNum()};
                detail.setReserveds(reserveds);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            if (!EmptyUtil.isEmpty((Object)info.getExpectTransTime())) {
                String bookDate = sdf.format(info.getExpectTransTime());
                detail.setBookingDate(bookDate);
            }
            details[i] = detail;
        }
        return details;
    }

    public static PaymentDetail[] parseBankTransUpDetail(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PaymentDetail[] details = new PaymentDetail[1];
        PaymentDetail detail = new PaymentDetail();
        detail.setDetailSeqID(entryInfo.getSerialNumber());
        detail.setDetailBizNo(entryInfo.getSerialNumber());
        String acctName = info.getMotherAcctBank().getAcctName();
        if (EmptyUtil.isEmpty((String)acctName)) {
            acctName = info.getMotherAcctBank().getName();
        }
        detail.setPayeeAccName(acctName);
        detail.setPayeeAccNo(info.getMotherAcctBank().getBankAccountNumber());
        detail.setPayeeBankName(info.getMotherAcctBank().getBank().getName());
        detail.setPayeeBankAddr(info.getRecCity());
        String item = "";
        item = info.getMotherAcctBank().getBank().getAccountBank() != null ? info.getMotherAcctBank().getBank().getAccountBank().getNumber() : BEBankFactory.getLocalInstance((Context)ctx).getBankNo(info.getMotherAcctBank().getBank().getName());
        detail.setPayeeCnapsCode(item);
        detail.setPayeeCountry(EASCommonResource.getString((String)resourcePath, (String)"7_BankFacadeControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeProvince(info.getRecProvince());
        detail.setPayeeCity(info.getRecCity());
        detail.setAmount(String.valueOf(entryInfo.getAmount().setScale(2, 4)));
        detail.setUrgent(info.isIsUrgent() ? "TRUE" : "FALSE");
        detail.setUseCode("-1");
        detail.setUse("\u8d44\u91d1\u4e0a\u5212");
        detail.setDesc(info.getUsage());
        detail.setVerifyField("pay");
        detail.setPayeeType("company");
        String[] reserveds = new String[]{"TransUp=TRUE"};
        detail.setReserveds(reserveds);
        details[0] = detail;
        return details;
    }

    public static PaymentDetail[] parseBankTransDownDetail(Context ctx, BankTransDownBillInfo info) throws EASBizException, BOSException {
        PaymentDetail[] details = new PaymentDetail[info.getEntrys().size()];
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BankTransDownBillEntryInfo entryInfo = info.getEntrys().get(i);
            PaymentDetail detail = new PaymentDetail();
            detail.setDetailSeqID(entryInfo.getSerialNumber());
            detail.setDetailBizNo(entryInfo.getSerialNumber());
            String acctName = entryInfo.getUnitAcctBank().getAcctName();
            if (EmptyUtil.isEmpty((String)acctName)) {
                acctName = entryInfo.getUnitAcctBank().getName();
            }
            detail.setPayeeAccName(acctName);
            detail.setPayeeAccNo(entryInfo.getUnitAcctBank().getBankAccountNumber());
            detail.setPayeeBankName(entryInfo.getRecBank());
            detail.setPayeeBankAddr(entryInfo.getRecCity());
            detail.setPayeeCnapsCode(entryInfo.getPayeeBankCode());
            detail.setPayeeCountry(EASCommonResource.getString((String)resourcePath, (String)"7_BankFacadeControllerBean", (Locale)ctx.getLocale()));
            detail.setPayeeProvince(entryInfo.getRecProvince());
            detail.setPayeeCity(entryInfo.getRecCity());
            detail.setAmount(String.valueOf(entryInfo.getAmount().setScale(2, 4)));
            detail.setUrgent(info.isIsUrgent() ? "TRUE" : "FALSE");
            detail.setUseCode("-1");
            detail.setUse("\u8d44\u91d1\u4e0b\u62e8");
            detail.setDesc(info.getUsage());
            detail.setVerifyField("pay");
            detail.setPayeeType("company");
            details[i] = detail;
        }
        return details;
    }

    public static PaymentDetail[] parseBankPayDetail(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        PaymentDetail[] details = new PaymentDetail[]{beServiceHelper.parseOneBankPayDetail(ctx, info)};
        return details;
    }

    private static PaymentDetail parseOneBankPayDetail(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException {
        BankFacadeControllerBeanEx bankFacadeControllerBean;
        String[] otherReserveds;
        PaymentDetail detail = new PaymentDetail();
        detail.setDetailSeqID(info.getSerialNumber());
        detail.setDetailBizNo(info.getSourceBillId());
        detail.setPayeeAccName(info.getRecCompany());
        detail.setPayeeAccNo(info.getRecAccountBank());
        detail.setPayeeBankName(info.getRecBank());
        detail.setPayeeCnapsCode(info.getRecBankNo());
        detail.setPayeeBankAddr(info.getRecCityStr());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry())) {
            detail.setPayeeCountry(info.getFRecCountry().getName());
        }
        detail.setPayeeProvince(info.getRecProvinceStr());
        detail.setPayeeCity(info.getRecCityStr());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRecOpenArea())) {
            detail.setPayeeAreaCode(info.getRecOpenArea().getNumber());
        }
        detail.setAmount(String.valueOf(info.getPayAmount().setScale(2, 4)));
        detail.setUrgent(info.isIsEmergency() ? "TRUE" : "FALSE");
        detail.setUseCode("-1");
        detail.setForceManual(info.isIsForceManual() ? "TRUE" : "FALSE");
        detail.setPayeeSwiftCode(info.getSwiftCode());
        detail.setUse("\u7f51\u4e0a\u62a5\u9500");
        detail.setDesc(info.getDescription());
        detail.setVerifyField("pay");
        detail.setPayeeType(info.isIsPersonPay() ? "individual" : "company");
        detail.setReserved1(info.isIsAgencyPersonPay() ? "true" : "false");
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRemitAccountBank())) {
            String[] reserveds;
            String agentAcct = "agentAccNo=" + info.getRemitAccountBank().getBankAccountNumber() + ";agentAccName=" + info.getRemitAccountBank().getName() + ";";
            String recBank = info.getRemitAccountBank().getBank().getName();
            String sSQL = "Select fNumber, FBeCity From T_Be_BeBank Where FName_" + ctx.getLocale().toString() + " = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL, (Object[])new String[]{recBank});
            try {
                agentAcct = rs.next() ? agentAcct + "agentBankCnaps=" + rs.getString("fNumber") + ";agentBankName=" + recBank + ";agentBankAddr=" + rs.getString("FBeCity") + ";" : agentAcct + "agentBankCnaps=;agentBankName=" + recBank + ";agentBankAddr=;";
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
            if (info.isPriorityPay()) {
                reserveds = new String[]{"priorityPay", agentAcct};
                detail.setReserveds(reserveds);
            } else {
                reserveds = new String[]{agentAcct};
                detail.setReserveds(reserveds);
            }
        } else if (info.isPriorityPay()) {
            String[] reserveds = new String[]{"priorityPay"};
            detail.setReserveds(reserveds);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String bookDate = sdf.format(info.getExpectTransTime());
        detail.setBookingDate(bookDate);
        if (detail.getReserveds() != null && detail.getReserveds().length > 0) {
            String[] reservedsOld = detail.getReserveds();
            String[] reservedsNew = new String[reservedsOld.length + 1];
            for (int i = 0; i < reservedsOld.length; ++i) {
                reservedsNew[i] = reservedsOld[i];
            }
            reservedsNew[reservedsOld.length] = "cmbForeignUser=" + (info.isIsCmbForeignUser() ? "true" : "false");
            detail.setReserveds(reservedsNew);
        } else {
            String[] reserveds = new String[]{"cmbForeignUser=" + (info.isIsCmbForeignUser() ? "true" : "false")};
            detail.setReserveds(reserveds);
        }
        if (!EmptyUtil.isEmpty((String)info.getEmail())) {
            detail.setEmail(info.getEmail());
        }
        if (!EmptyUtil.isEmpty((String)info.getTradingCode())) {
            detail.setReserved2(info.getTradingCode());
        }
        if (!EmptyUtil.isEmpty((String)info.getInvoiceNumber())) {
            detail.setReserved3(info.getInvoiceNumber());
        }
        if ((otherReserveds = (bankFacadeControllerBean = new BankFacadeControllerBeanEx()).parsePaymentDetailOtherMessage(ctx, info.getSourceBillId())) != null && otherReserveds.length > 0) {
            String[] reserveds = new String[detail.getReserveds().length + otherReserveds.length];
            for (int i = 0; i < detail.getReserveds().length; ++i) {
                reserveds[i] = detail.getReserveds()[i];
            }
            for (int j = 0; j < otherReserveds.length; ++j) {
                reserveds[detail.getReserveds().length + j] = otherReserveds[j];
            }
            detail.setReserveds(reserveds);
        }
        return detail;
    }

    public static PayBody parseBankDraftReqBody(Context ctx, BankDraftReqInfo info) throws BOSException, EASBizException, RemoteException, ServiceException {
        PayBody body = new PayBody();
        body.setBatchSeqID(String.valueOf(beServiceHelper.getSerialNumber(1)[0]));
        body.setTotalAmount(String.valueOf(info.getPayAmount().setScale(2, 4)));
        body.setTotalCount("1");
        body.setVerifyField("pay");
        body.setDetails(beServiceHelper.parseBankDreftReqDetail(ctx, info));
        return body;
    }

    public static PaymentDetail[] parseBankDreftReqDetail(Context ctx, BankDraftReqInfo info) {
        PaymentDetail[] details = new PaymentDetail[1];
        PaymentDetail detail = new PaymentDetail();
        detail.setDetailSeqID(beServiceHelper.getSerialNumber(1)[0]);
        detail.setDetailBizNo(detail.getDetailSeqID());
        detail.setPayeeAccName(info.getRecPerson());
        if (null != info.getRecAccountBank()) {
            detail.setPayeeAccNo(info.getRecAccountBank());
        } else {
            detail.setPayeeAccNo("0000000000000000");
        }
        if (null != info.getRecBank()) {
            detail.setPayeeBankName(info.getRecBank());
        } else {
            detail.setPayeeBankName(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"19_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        }
        detail.setPayeeCountry(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"18_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeProvince(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"20_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeCity(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"21_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setAmount(String.valueOf(info.getPayAmount().setScale(2, 4)));
        detail.setUrgent("FALSE");
        detail.setUseCode("-1");
        detail.setForceManual("TRUE");
        detail.setUse("\u7f51\u4e0a\u62a5\u9500");
        detail.setDesc(info.getUsage());
        detail.setVerifyField("pay");
        detail.setPayeeType("company");
        details[0] = detail;
        return details;
    }

    public static QueryFixedRequestBody parseRegularBody(Context ctx, RegularBizInfo info) throws EASBizException, BOSException {
        QueryFixedRequestBody body = new QueryFixedRequestBody();
        body.setReserveds(info.getAccNoArray());
        return body;
    }

    public static FixedToCurrentRequestBody parseFixedToCurrentBody(Context ctx, RegularBizInfo info) throws EASBizException, BOSException {
        FixedToCurrentRequestBody body = new FixedToCurrentRequestBody();
        body.setFixedAccNo(info.getFixedAccNo());
        body.setAmount(info.getAmount());
        return body;
    }

    public static CurrentToFixedRequestBody parseCurrentToFixedBody(Context ctx, RegularBizInfo info) throws EASBizException, BOSException {
        CurrentToFixedRequestBody body = new CurrentToFixedRequestBody();
        body.setCurrency(info.getCurrency());
        body.setFixedAccNo(info.getFixedAccNo());
        String amount = info.getAmount();
        if (EmptyUtil.isEmpty((String)amount)) {
            amount = "0";
        }
        body.setAmount(new BigDecimal(amount));
        return body;
    }

    public static BankPayingBillStateEnum transferState(String paymentState) {
        if (paymentState.equals(BankPayingStatusEnum.EB_PROCESSING.getName())) {
            return BankPayingBillStateEnum.OS;
        }
        if (paymentState.equals(BankPayingStatusEnum.BANK_SUCCESS.getName())) {
            return BankPayingBillStateEnum.TS;
        }
        if (paymentState.equals(BankPayingStatusEnum.BANK_FAIL.getName())) {
            return BankPayingBillStateEnum.TF;
        }
        if (paymentState.equals(BankPayingStatusEnum.BANK_PROCESSING.getName())) {
            return BankPayingBillStateEnum.BP;
        }
        if (paymentState.equals(BankPayingStatusEnum.EB_INVALIDATED.getName())) {
            return BankPayingBillStateEnum.OF;
        }
        return BankPayingBillStateEnum.NC;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date stringToDate(String s) {
        Date d = null;
        if (EmptyUtil.isEmpty((String)s)) {
            d = DateUtil.getDayBegin();
        } else {
            try {
                d = BizConstant.FORMAT_BEDATE.parse(s);
            }
            catch (ParseException e) {
                try {
                    d = new SimpleDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = DateUtil.getDayBegin();
                }
            }
        }
        return d;
    }

    public static String[] getSerialNumber(int count) {
        String[] serials = new String[count];
        for (int i = 0; i < count; ++i) {
            serials[i] = Sequence.gen18Sequence();
        }
        return serials;
    }

    private static LinkPayRequestBody createLinkPayRequestBody(BankPayingBillInfo info, int totalCount, BigDecimal totalAmount) {
        LinkPayRequestBody body = new LinkPayRequestBody();
        body.setParentAcnt(info.getParentAccount());
        body.setChildAcnt1(info.getPayAccountBank().getBankAccountNumber());
        body.setFeeType("0");
        body.setBatchSeqID(info.getSerialNumber());
        body.setBatchBizNo(info.getSerialNumber());
        body.setTotalCount(String.valueOf(totalCount));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setVerifyField("pay");
        return body;
    }

    public static LinkPayRequestBody parseLinkPayBody(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        LinkPayRequestBody body = beServiceHelper.createLinkPayRequestBody(info, 1, info.getPayAmount());
        body.setDetails(beServiceHelper.parseSettleBizPayDetail(ctx, info));
        return body;
    }

    public static LinkPayRequestBody parseLinkPayBody(Context ctx, BankPayingBillCollection collection) throws EASBizException, BOSException {
        int size = collection.size();
        PaymentDetail[] linkPayDetails = new LinkPayDetail[size];
        BigDecimal amount = BigDecimal.ZERO;
        BankPayingBillInfo info = collection.get(0);
        LinkPayRequestBody body = beServiceHelper.createLinkPayRequestBody(info, size, amount);
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            amount = amount.add(info.getPayAmount());
            linkPayDetails[i] = beServiceHelper.parseOneSettleBizPayDetail(ctx, info);
        }
        body.setTotalAmount(amount.setScale(2, 4).toString());
        body.setDetails(linkPayDetails);
        return body;
    }

    public static QueryLinkPayRequestBody parseSettleBizPayBody(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        QueryLinkPayRequestBody body = new QueryLinkPayRequestBody();
        body.setBatchSeqID(info.getSerialNumber());
        return body;
    }

    public static LinkPayDetail parseOneSettleBizPayDetail(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException {
        LinkPayDetail detail = new LinkPayDetail();
        detail.setDetailSeqID(info.getSerialNumber());
        detail.setDetailBizNo(info.getSourceBillId());
        detail.setPayeeAccNo(info.getRecAccountBank());
        detail.setPayeeAccName(info.getRecCompany());
        if (!EmptyUtil.isEmpty((String)info.getRecBankNo())) {
            detail.setPayeeCnapsCode(info.getRecBankNo());
        }
        detail.setPayeeType(info.isIsPersonPay() ? "individual" : "company");
        detail.setPayeeBankName(info.getRecBank());
        detail.setPayeeBankAddr(info.getRecCityStr());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry())) {
            detail.setPayeeCountry(info.getFRecCountry().getName());
        }
        detail.setPayeeProvince(info.getRecProvinceStr());
        detail.setPayeeCity(info.getRecCityStr());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRecOpenArea())) {
            detail.setPayeeAreaCode(info.getRecOpenArea().getNumber());
        }
        detail.setAmount(String.valueOf(info.getPayAmount().setScale(2, 4)));
        detail.setUrgent(info.isIsEmergency() ? "TRUE" : "FALSE");
        detail.setUseCode("-1");
        detail.setUse("\u7f51\u4e0a\u62a5\u9500");
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        detail.setDesc(info.getUsage());
        detail.setVerifyField("pay");
        detail.setReserved1(info.isIsAgencyPersonPay() ? "true" : "false");
        if (info.isPriorityPay()) {
            String[] reserds = new String[]{"priorityPay"};
            detail.setReserveds(reserds);
        }
        return detail;
    }

    public static LinkPayDetail[] parseSettleBizPayDetail(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        LinkPayDetail detail = beServiceHelper.parseOneSettleBizPayDetail(ctx, info);
        return new LinkPayDetail[]{detail};
    }

    public static PayBody parseBankPayBody(Context ctx, BankPayingBillCollection collection) throws EASBizException, BOSException {
        int size = collection.size();
        PayBody body = new PayBody();
        body.setTotalCount(String.valueOf(size));
        body.setBatchSeqID(collection.get(0).getSerialNumber());
        body.setVerifyField("pay");
        PaymentDetail[] paymentDetails = new PaymentDetail[size];
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = collection.get(i);
            amount = amount.add(info.getPayAmount());
            paymentDetails[i] = beServiceHelper.parseOneBankPayDetail(ctx, info);
        }
        body.setTotalAmount(String.valueOf(amount.setScale(2, 4)));
        body.setDetails(paymentDetails);
        return body;
    }
}

