/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.be.BankTransDownBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryFactory;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryFactory;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.IBankTransDownBillEntry;
import com.kingdee.eas.fm.be.IBankTransUpBillEntry;
import com.kingdee.eas.fm.common.app.SQL;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.util.StringUtils;

public class BankBillSateUtil {
    private static final String UPDATE_TRANSUP_BILL_ENTRY_REQSEQNO = "Update T_FS_TransUpBillEntry set FReqSeqNo=''{0}'' Where FId=''{1}'';\n";
    private static final String UPDATE_TRANSDOWN_BILL_ENTRY_REQSEQNO = "Update T_FS_TransDownBillEntry set FReqSeqNo=''{0}'' Where FId=''{1}'';\n";

    private String cnulls(String str) {
        return StringUtils.cnulls((String)str);
    }

    public void updateTransUpBillEntryReqSeqNo(Context ctx, PaymentDetail info) throws BOSException {
        IBankTransUpBillEntry ibankEntry = BankTransUpBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)info.getDetailSeqID()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srcBillNumber"));
        view.setFilter(filter);
        view.setSelector(sic);
        BankTransUpBillEntryCollection entryCol = ibankEntry.getBankTransUpBillEntryCollection(view);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransUpBillEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getSrcBillNumber() == null) continue;
            String batchNo = info.getBankBatchSeqID();
            BOSObjectType bosType = BOSUuid.read((String)entryInfo.getSrcBillNumber()).getType();
            if (!bosType.equals((Object)new TransUpBillEntryInfo().getBOSType())) continue;
            SQL sql = new SQL(ctx);
            sql.add(UPDATE_TRANSUP_BILL_ENTRY_REQSEQNO, new Object[]{this.cnulls(batchNo), entryInfo.getSrcBillNumber()});
            sql.execute();
        }
    }

    public void updateTransDownBillEntryReqSeqNo(Context ctx, PaymentDetail info) throws BOSException {
        IBankTransDownBillEntry ibankEntry = BankTransDownBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)info.getDetailSeqID()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srcBillNumber"));
        view.setFilter(filter);
        view.setSelector(sic);
        BankTransDownBillEntryCollection entryCol = ibankEntry.getBankTransDownBillEntryCollection(view);
        for (int i = 0; i < entryCol.size(); ++i) {
            BankTransDownBillEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getSrcBillNumber() == null) continue;
            String batchNo = info.getBankBatchSeqID();
            BOSObjectType bosType = BOSUuid.read((String)entryInfo.getSrcBillNumber()).getType();
            if (!bosType.equals((Object)new TransDownBillEntryInfo().getBOSType())) continue;
            SQL sql = new SQL(ctx);
            sql.add(UPDATE_TRANSDOWN_BILL_ENTRY_REQSEQNO, new Object[]{this.cnulls(batchNo), entryInfo.getSrcBillNumber()});
            sql.execute();
        }
    }
}

