/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.util;

import bos.org.apache.commons.dbcp.BasicDataSource;
import bos.org.apache.commons.dbcp.BasicDataSourceFactory;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBCPConUtils {
    private static Logger logger = Logger.getLogger(DBCPConUtils.class);
    private static BasicDataSource dataSource = null;
    private static final String MYSQL_DRIVERCLASSNAME = "com.mysql.jdbc.Driver";
    private static final String ORACLE_DRIVERCLASSNAME = "oracle.jdbc.driver.OracleDriver";
    private static final String PG_DRIVERCLASSNAME = "org.postgresql.Driver";
    private static final String SQLSERVER_DRIVERCLASSNAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String INITIALSIZE = "10";
    private static final String MAXACTIVE = "50";
    private static final String MAXIDLE = "20";
    private static final String MINIDLE = "5";
    private static final String MAXWAIT = "10000";
    private static final String REMOVEABANDONED = "true";
    private static final String REMOVEABANDONEDTIMEOUT = "180";
    private static final String LOGABANDONED = "true";
    private static final String MYSQL_VALIDATIONQUERY = "SELECT 1";
    private static final String ORACLE_VALIDATIONQUERY = "SELECT 1 FROM dual";
    private static final String PG_VALIDATIONQUERY = "SELECT 1";
    private static final String TESTONBORROW = "true";
    private static final String TESTONRETURN = "true";
    private static final String TESTWHILEIDLE = "true";
    private static final String CONNECTIONPROPERTIES = "useUnicode=true;characterEncoding=UTF8";
    private static final String DEFAULTAUTOCOMMIT = "false";
    private static final String DEFAULTTRANSACTIONISOLATION = "READ_COMMITTED";

    public static void init(EReceiptDBInfo eReceiptDBInfo) throws SQLException {
        if (dataSource != null) {
            try {
                dataSource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dataSource = null;
        }
        try {
            Properties p = new Properties();
            String url = "";
            String dbType = eReceiptDBInfo.getDbType();
            if (dbType.equals("MySQL")) {
                p.setProperty("driverClassName", MYSQL_DRIVERCLASSNAME);
                p.setProperty("validationQuery", "SELECT 1");
                url = "jdbc:mysql://" + eReceiptDBInfo.getDbIP() + ":" + eReceiptDBInfo.getDbPort() + "/" + eReceiptDBInfo.getDbName();
            } else if (dbType.equals("Oracle")) {
                p.setProperty("driverClassName", ORACLE_DRIVERCLASSNAME);
                p.setProperty("validationQuery", ORACLE_VALIDATIONQUERY);
                url = "jdbc:oracle:thin:@" + eReceiptDBInfo.getDbIP() + ":" + eReceiptDBInfo.getDbPort() + ":" + eReceiptDBInfo.getDbName();
            } else if (dbType.equals("PostgreSQL")) {
                p.setProperty("driverClassName", PG_DRIVERCLASSNAME);
                p.setProperty("validationQuery", "SELECT 1");
                url = "jdbc:postgresql://" + eReceiptDBInfo.getDbIP() + ":" + eReceiptDBInfo.getDbPort() + "/" + eReceiptDBInfo.getDbName();
            } else if (dbType.equals("SqlServer")) {
                p.setProperty("driverClassName", SQLSERVER_DRIVERCLASSNAME);
                p.setProperty("validationQuery", "SELECT 1");
                url = "jdbc:sqlserver://" + eReceiptDBInfo.getDbIP() + ":" + eReceiptDBInfo.getDbPort() + ";DatabaseName=" + eReceiptDBInfo.getDbName();
            } else {
                logger.error((Object)("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01\u7c7b\u578b\u4e3a\uff1a" + dbType));
                throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01" + dbType);
            }
            p.setProperty("url", url);
            if (eReceiptDBInfo.getDbUserName() == null) {
                p.setProperty("username", "");
            } else {
                p.setProperty("username", eReceiptDBInfo.getDbUserName());
            }
            if (eReceiptDBInfo.getDbUserPwd() == null) {
                p.setProperty("password", "");
            } else {
                p.setProperty("password", eReceiptDBInfo.getDbUserPwd());
            }
            p.setProperty("initialSize", INITIALSIZE);
            p.setProperty("maxActive", MAXACTIVE);
            p.setProperty("maxIdle", MAXIDLE);
            p.setProperty("minIdle", MINIDLE);
            p.setProperty("maxWait", MAXWAIT);
            p.setProperty("removeAbandoned", "true");
            p.setProperty("removeAbandonedTimeout", REMOVEABANDONEDTIMEOUT);
            p.setProperty("logAbandoned", "true");
            p.setProperty("testOnBorrow", "true");
            p.setProperty("testOnReturn", "true");
            p.setProperty("testWhileIdle", "true");
            p.setProperty("connectionProperties", CONNECTIONPROPERTIES);
            p.setProperty("defaultAutoCommit", DEFAULTAUTOCOMMIT);
            p.setProperty("defaultTransactionIsolation", DEFAULTTRANSACTIONISOLATION);
            dataSource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)p);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u6e90\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    public static synchronized Connection getConnection(EReceiptDBInfo eReceiptDBInfo) throws SQLException {
        if (dataSource == null) {
            DBCPConUtils.init(eReceiptDBInfo);
        }
        Connection conn = null;
        if (dataSource != null) {
            conn = dataSource.getConnection();
        }
        return conn;
    }

    public static void release(Connection conn, Statement st, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps = null;
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

