/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.StorageType;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.app.util.IEReceiptJDBCTool;
import com.kingdee.eas.fm.be.app.util.JdbcUtils_DBCP;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.be.vo.EReceiptVO;
import com.kingdee.eas.fm.common.FMHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.apache.log4j.Logger;

public class EReceiptJDBC
implements IEReceiptJDBCTool {
    private Logger logger = Logger.getLogger(EReceiptJDBC.class);

    public void createTable() throws Exception, SQLException {
        Statement st = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = JdbcUtils_DBCP.getConnection();
            ps = conn.prepareStatement("   CREATE TABLE IF NOT EXISTS T_BE_ERECEIPT ( FID varchar(44) NOT NULL,EASID varchar(44) NOT NULL,DETAILNO varchar(100) DEFAULT NULL,SERIALNO varchar(100) DEFAULT NULL,FILENAME varchar(200) DEFAULT NULL,FILEVALUE mediumblob,RECEIPTSTAMP mediumblob,PRIMARY KEY (FID))");
            ps.executeUpdate();
            conn.commit();
            this.logger.info((Object)"CREATE TABLE success");
        }
        catch (Exception e) {
            e.printStackTrace();
            conn.rollback();
            throw new Exception(e);
        }
        finally {
            JdbcUtils_DBCP.release(conn, st, ps);
        }
    }

    @Override
    public void insert(EReceiptVO eReceiptVO) throws Exception, SQLException {
        Statement st = null;
        PreparedStatement ps = null;
        Object file = null;
        Connection conn = null;
        try {
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u65b0\u589ePDF\u5f00\u59cb");
            this.logger.error((Object)"\u5f00\u59cb\u83b7\u53d6Mysql\u7684\u8fde\u63a5");
            conn = JdbcUtils_DBCP.getConnection();
            this.logger.error((Object)"\u83b7\u53d6MySql\u8fde\u63a5\u6210\u529f");
            ps = conn.prepareStatement("insert into T_BE_ERECEIPT(FID,EASID,FILEVALUE,FILENAME,DETAILNO) values(?,?,?,?,?)");
            ps.setString(1, eReceiptVO.getFID());
            ps.setString(2, eReceiptVO.getEASID());
            ps.setBinaryStream(3, eReceiptVO.getFILEVALUE(), eReceiptVO.getFILEVALUE().available());
            ps.setString(4, eReceiptVO.getFILENAME());
            ps.setString(5, eReceiptVO.getDETAILNO());
            this.logger.error((Object)"\u4fdd\u5b58\u7535\u5b50\u56de\u5355PDF\uff0cEReceiptJDBC.insert");
            ps.executeUpdate();
            this.logger.error((Object)"\u63d0\u4ea4MySQL\u4e8b\u52a1\uff0cEReceiptJDBC.insert");
            conn.commit();
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u65b0\u589ePDF\u6210\u529f 1\u6761");
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u65b0\u589ePDF\u5931\u8d25 1\u6761");
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                JdbcUtils_DBCP.release(conn, st, ps);
                this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
                throw throwable;
            }
        }
        JdbcUtils_DBCP.release(conn, st, ps);
        this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
    }

    @Override
    public void batchInsert(List<EReceiptVO> list) throws Exception, SQLException {
        Statement st = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            System.out.println("createTable success");
            this.createTable();
            conn = JdbcUtils_DBCP.getConnection();
            ps = conn.prepareStatement("insert into T_BE_ERECEIPT(FID,EASID,FILEVALUE,FILENAME) values(?,?,?,?)");
            for (int i = 0; i < list.size(); ++i) {
                EReceiptVO eReceiptVO = list.get(i);
                ps.setString(1, eReceiptVO.getFID());
                ps.setString(2, eReceiptVO.getEASID());
                ps.setBinaryStream(3, eReceiptVO.getFILEVALUE(), eReceiptVO.getFILEVALUE().available());
                ps.setString(4, eReceiptVO.getFILENAME());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
            this.logger.info((Object)"batchInsert success");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                JdbcUtils_DBCP.release(conn, st, ps);
                throw throwable;
            }
        }
        JdbcUtils_DBCP.release(conn, st, ps);
    }

    @Override
    public byte[] selectById(String pk1, CompareType compareType) throws Exception {
        byte[] byArray;
        Statement st = null;
        PreparedStatement ps = null;
        ResultSet rs1 = null;
        Connection conn = null;
        try {
            this.logger.error((Object)("\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u5f00\u59cb\uff0c\u7535\u5b50\u56de\u5355id\uff1a" + pk1));
            conn = JdbcUtils_DBCP.getConnection();
            this.logger.error((Object)"\u83b7\u53d6MySql\u8fde\u63a5\u6210\u529f");
            ps = conn.prepareStatement("select FID,EASID,FILEVALUE from T_BE_ERECEIPT where EASID " + compareType.getAlias() + "?");
            ps.setString(1, pk1);
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c");
            rs1 = ps.executeQuery();
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c\u7ed3\u679c\u8fd4\u56de");
            String dbName = conn.getMetaData().getDatabaseProductName();
            this.logger.error((Object)("\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName));
            byte[] fileValue = null;
            if (dbName.equals("MySQL")) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else if (dbName.equals("Oracle")) {
                Blob blob = null;
                if (rs1.next()) {
                    blob = rs1.getBlob("FILEVALUE");
                }
                fileValue = this.blobToBytes(blob);
            } else if (dbName.equals("PostgreSQL")) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else if (dbName != null && (dbName.toLowerCase().contains("SQL Server".toLowerCase()) || dbName.toLowerCase().contains("sqlserver"))) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else {
                throw new Exception("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u662fMySQL\u6216Oracle\u6216SQL Server");
            }
            byArray = fileValue;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                JdbcUtils_DBCP.release(conn, st, ps);
                throw throwable;
            }
        }
        JdbcUtils_DBCP.release(conn, st, ps);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] blobToBytes(Blob blob) {
        InputStream is = null;
        byte[] b = null;
        try {
            is = blob.getBinaryStream();
            b = new byte[(int)blob.length()];
            is.read(b);
            byte[] byArray = b;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertEReceipt(EReceiptVO eReceiptVO, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception, SQLException {
        block5: {
            Statement st = null;
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                this.logger.error((Object)"\u7535\u5b50\u56de\u5355 PDF\u6570\u636e\u5e93\u65b0\u589ePDF\u5f00\u59cb");
                this.logger.error((Object)"\u5f00\u59cb\u83b7\u53d6 PDF\u6570\u636e\u5e93\u7684\u8fde\u63a5");
                EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
                eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
                eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
                eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
                eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
                eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
                eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
                conn = DBCPConUtils.getConnection(eReceiptDBInfo);
                this.logger.error((Object)"\u83b7\u53d6PDF\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
                ps = conn.prepareStatement("insert into T_BE_ERECEIPT(FID,EASID,FILEVALUE,FILENAME,DETAILNO) values(?,?,?,?,?)");
                ps.setString(1, eReceiptVO.getFID());
                ps.setString(2, eReceiptVO.getEASID());
                ps.setBinaryStream(3, eReceiptVO.getFILEVALUE(), eReceiptVO.getFILEVALUE().available());
                ps.setString(4, eReceiptVO.getFILENAME());
                ps.setString(5, eReceiptVO.getDETAILNO());
                this.logger.error((Object)"\u4fdd\u5b58\u7535\u5b50\u56de\u5355PDF");
                ps.executeUpdate();
                this.logger.error((Object)"\u63d0\u4ea4MySQL\u4e8b\u52a1");
                conn.commit();
                this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u65b0\u589ePDF\u6210\u529f 1\u6761");
                if (conn == null) break block5;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u65b0\u589ePDF\u5931\u8d25 1\u6761");
                    e.printStackTrace();
                    if (conn == null) throw new Exception(e);
                    conn.rollback();
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        DBCPConUtils.release(conn, st, ps);
                    }
                    this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
                    throw throwable;
                }
            }
            DBCPConUtils.release(conn, st, ps);
        }
        this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
    }

    @Override
    public byte[] getEReceiptPDFValues(String pk1, CompareType compareType, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception {
        byte[] byArray;
        Statement st = null;
        PreparedStatement ps = null;
        ResultSet rs1 = null;
        Connection conn = null;
        try {
            this.logger.error((Object)("\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u5f00\u59cb\uff0c\u7535\u5b50\u56de\u5355id\uff1a" + pk1));
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
            conn = DBCPConUtils.getConnection(eReceiptDBInfo);
            this.logger.error((Object)"\u83b7\u53d6\u56de\u5355PDF\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
            ps = conn.prepareStatement("select FID,EASID,FILEVALUE from T_BE_ERECEIPT where EASID " + compareType.getAlias() + "?");
            ps.setString(1, pk1);
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c");
            rs1 = ps.executeQuery();
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c\u7ed3\u679c\u8fd4\u56de");
            String dbName = conn.getMetaData().getDatabaseProductName();
            this.logger.error((Object)("\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName));
            byte[] fileValue = null;
            if (dbName.equals("MySQL")) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else if (dbName.equals("Oracle")) {
                Blob blob = null;
                if (rs1.next()) {
                    blob = rs1.getBlob("FILEVALUE");
                }
                fileValue = this.blobToBytes(blob);
            } else if (dbName.equals("PostgreSQL")) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else if (dbName != null && (dbName.toLowerCase().contains("SQL Server".toLowerCase()) || dbName.toLowerCase().contains("sqlserver"))) {
                if (rs1.next()) {
                    fileValue = rs1.getBytes(3);
                }
            } else {
                throw new Exception("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u662fMySQL\u6216Oracle\u6216SQL Server");
            }
            byArray = fileValue;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DBCPConUtils.release(conn, st, ps);
                throw throwable;
            }
        }
        DBCPConUtils.release(conn, st, ps);
        return byArray;
    }

    @Override
    public Map<String, byte[]> getBatchEReceiptPDFValues(List eRecIdList, CompareType compareType, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception {
        LinkedHashMap<String, byte[]> linkedHashMap;
        HashMap<String, byte[]> fileValueMap = new HashMap<String, byte[]>();
        Statement st = null;
        PreparedStatement ps = null;
        ResultSet rs1 = null;
        Connection conn = null;
        try {
            this.logger.error((Object)("\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u5f00\u59cb\uff0c\u7535\u5b50\u56de\u5355id\uff1a" + eRecIdList.toArray().toString()));
            conn = this.getConnection(eReceiptStorageSettingInfo);
            ps = conn.prepareStatement("select FID,EASID,FILEVALUE from T_BE_ERECEIPT where EASID " + compareType.getAlias() + FMHelper.setTran2String((Set)FMHelper.list2Set((List)eRecIdList)));
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c");
            rs1 = ps.executeQuery();
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 \u67e5\u8be2\u6267\u884c\u7ed3\u679c\u8fd4\u56de");
            String dbName = conn.getMetaData().getDatabaseProductName();
            this.logger.error((Object)("\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName));
            byte[] fileValue = null;
            String id = null;
            while (rs1.next()) {
                fileValue = null;
                id = rs1.getString("EASID");
                if (dbName.equals("MySQL")) {
                    fileValue = rs1.getBytes("FILEVALUE");
                } else if (dbName.equals("Oracle")) {
                    Blob blob = null;
                    blob = rs1.getBlob("FILEVALUE");
                    fileValue = this.blobToBytes(blob);
                } else if (dbName.equals("PostgreSQL")) {
                    fileValue = rs1.getBytes("FILEVALUE");
                } else if (dbName != null && (dbName.toLowerCase().contains("SQL Server".toLowerCase()) || dbName.toLowerCase().contains("sqlserver"))) {
                    fileValue = rs1.getBytes(3);
                } else {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u662fMySQL\u6216Oracle\u6216SQL Server");
                }
                fileValueMap.put(id, fileValue);
            }
            LinkedHashMap<String, byte[]> sortFileValueMap = new LinkedHashMap<String, byte[]>();
            String eRecId = "";
            for (int i = 0; i < eRecIdList.size(); ++i) {
                eRecId = eRecIdList.get(i).toString();
                if (!fileValueMap.containsKey(eRecId)) continue;
                sortFileValueMap.put(eRecId, (byte[])fileValueMap.get(eRecIdList.get(i)));
            }
            linkedHashMap = sortFileValueMap;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DBCPConUtils.release(conn, st, ps);
                throw throwable;
            }
        }
        DBCPConUtils.release(conn, st, ps);
        return linkedHashMap;
    }

    private Connection getConnection(EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws SQLException {
        EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
        eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
        eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
        eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
        eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
        eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
        eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
        Connection conn = DBCPConUtils.getConnection(eReceiptDBInfo);
        this.logger.error((Object)"\u83b7\u53d6\u56de\u5355PDF\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchInsert(List<EReceiptVO> list, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore == eReceiptStorageSettingInfo.getStorageType()) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
            Statement st = null;
            Statement ps = null;
            Connection conn = null;
            try {
                System.out.println("createTable success");
                conn = DBCPConUtils.getConnection(eReceiptDBInfo);
                ps = conn.prepareStatement("insert into T_BE_ERECEIPT(FID,EASID,FILEVALUE,FILENAME,FISINNERERECEIPT) values(?,?,?,?,?)");
                for (int i = 0; i < list.size(); ++i) {
                    EReceiptVO eReceiptVO = list.get(i);
                    ps.setString(1, eReceiptVO.getFID());
                    ps.setString(2, eReceiptVO.getEASID());
                    ps.setBinaryStream(3, eReceiptVO.getFILEVALUE(), eReceiptVO.getFILEVALUE().available());
                    ps.setString(4, eReceiptVO.getFILENAME());
                    if ("PostgreSQL".equals(eReceiptStorageSettingInfo.getDbType())) {
                        int isInner = eReceiptVO.isISINNERERECEIPT() ? 1 : 0;
                        ps.setInt(5, isInner);
                    } else {
                        ps.setBoolean(5, eReceiptVO.isISINNERERECEIPT());
                    }
                    ps.addBatch();
                }
                ps.executeBatch();
                conn.commit();
                this.logger.info((Object)"batchInsert success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (StorageType.localStore == eReceiptStorageSettingInfo.getStorageType()) {
            String storePath = null;
            for (int i = 0; i < list.size(); ++i) {
                EReceiptVO eReceiptVO = list.get(i);
                String fileName = eReceiptVO.getFILENAME();
                String filePath = null;
                byte[] fileValue = eReceiptVO.getLFILEVALUE();
                String receiptStampPath = eReceiptVO.getRECEIPTSTAMPPATH();
                FileOutputStream fos = null;
                FilterOutputStream bos = null;
                try {
                    Object file;
                    String errMsg;
                    Object dir;
                    this.logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  start");
                    if (eReceiptStorageSettingInfo.isUseMapping()) {
                        storePath = eReceiptStorageSettingInfo.getMappingFinalPath();
                        dir = new SmbFile(storePath);
                        if (!dir.exists() && dir.isDirectory()) {
                            errMsg = "\u672c\u5730\u8be5\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u6587\u4ef6\u5939\uff0c\u8bf7\u5728web\u7aef\u7535\u5b50\u56de\u5355\u5b58\u50a8\u914d\u7f6e\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!";
                            this.logger.error((Object)errMsg);
                            throw new BOSException(errMsg);
                        }
                        file = new SmbFile(receiptStampPath);
                        if (!file.exists() && !file.isDirectory()) {
                            file.mkdirs();
                        }
                        filePath = receiptStampPath + "/" + fileName;
                        file = new SmbFile(filePath);
                        SmbFileOutputStream sfos = new SmbFileOutputStream((SmbFile)file);
                        bos = new BufferedOutputStream((OutputStream)sfos);
                        bos.write(fileValue);
                        this.logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  end");
                        continue;
                    }
                    storePath = eReceiptStorageSettingInfo.getLocalPath();
                    dir = new File(storePath);
                    if (!((File)dir).exists() && ((File)dir).isDirectory()) {
                        errMsg = "\u672c\u5730\u8be5\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u4e3a\u6587\u4ef6\u5939\uff0c\u8bf7\u5728web\u7aef\u7535\u5b50\u56de\u5355\u5b58\u50a8\u914d\u7f6e\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!";
                        this.logger.error((Object)errMsg);
                        throw new BOSException(errMsg);
                    }
                    file = new File(receiptStampPath);
                    if (!((File)file).exists() && !((File)file).isDirectory()) {
                        ((File)file).mkdirs();
                    }
                    filePath = receiptStampPath + "/" + fileName;
                    file = new File(filePath);
                    fos = new FileOutputStream((File)file);
                    bos = new BufferedOutputStream(fos);
                    bos.write(fileValue);
                    this.logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u672c\u5730  end");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void deleteEReceipt(String pk, CompareType compareType, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception, SQLException {
        Statement st = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 PDF\u6570\u636e\u5e93\u5220\u9664PDF\u5f00\u59cb");
            this.logger.error((Object)"\u5f00\u59cb\u83b7\u53d6 PDF\u6570\u636e\u5e93\u7684\u8fde\u63a5");
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
            conn = DBCPConUtils.getConnection(eReceiptDBInfo);
            this.logger.error((Object)"\u83b7\u53d6PDF\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
            ps = conn.prepareStatement("delete from T_BE_ERECEIPT where EASID " + compareType.getAlias() + "?");
            ps.setString(1, pk);
            this.logger.error((Object)"\u5220\u9664\u5185\u90e8\u7535\u5b50\u56de\u5355PDF");
            ps.executeUpdate();
            this.logger.error((Object)"\u63d0\u4ea4MySQL\u4e8b\u52a1");
            conn.commit();
            this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u5220\u9664PDF\u6210\u529f 1\u6761");
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"\u7535\u5b50\u56de\u5355 Mysql\u5220\u9664PDF\u5931\u8d25 1\u6761");
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    throw new BEException(BEException.CONNECTIONERROR);
                }
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DBCPConUtils.release(conn, st, ps);
                this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u5220\u9664\u5355\u6761 \u91ca\u653e\u6210\u529f");
                throw throwable;
            }
        }
        DBCPConUtils.release(conn, st, ps);
        this.logger.info((Object)"\u7535\u5b50\u56de\u5355 MySql\u5220\u9664\u5355\u6761 \u91ca\u653e\u6210\u529f");
    }

    @Override
    public void deleteEReceipt(Context ctx, String pk, CompareType equals, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fileSource"));
        sic.add(new SelectorItemInfo("fileValue"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("transDate"));
        sic.add(new SelectorItemInfo("isImport"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("receiptStampPath"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        this.logger.error((Object)("\u7535\u5b50\u56de\u5355\u5220\u9664 \uff1a " + view.toString()));
        try {
            EReceiptCollection coll = EReceiptFactory.getLocalInstance(ctx).getEReceiptCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                Object file;
                String filePath;
                EReceiptInfo info = coll.get(i);
                this.logger.error((Object)("\u5220\u9664\u7535\u5b50\u56de\u5355\u6587\u4ef6\u540d\u4e3a \uff1a " + info.getFileName()));
                if (eReceiptStorageSettingInfo.isUseMapping()) {
                    filePath = info.getReceiptStampPath() + "/" + info.getFileName();
                    file = new SmbFile(filePath);
                    file.delete();
                    continue;
                }
                filePath = info.getReceiptStampPath() + "/" + info.getFileName();
                file = new File(filePath);
                ((File)file).delete();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SmbException e) {
            e.printStackTrace();
        }
    }
}

