/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.kingdee.eas.fm.be.vo.FtpVO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EReceiptSFtpUtil {
    private static final Logger LOGGER = Logger.getLogger(EReceiptSFtpUtil.class);
    private Session session = null;
    private ChannelSftp channel = null;

    public ChannelSftp getConnect(FtpVO ftpVO) throws Exception {
        String ftpHost = ftpVO.getIp();
        int port = ftpVO.getPor();
        String ftpUserName = ftpVO.getUser();
        String ftpPassword = ftpVO.getPassword();
        int ftpPort = 0;
        ftpPort = port;
        JSch jsch = new JSch();
        try {
            this.session = port != -1 ? jsch.getSession(ftpUserName, ftpHost, ftpPort) : jsch.getSession(ftpUserName, ftpHost);
            LOGGER.error((Object)"Session created.");
            if (ftpPassword != null) {
                this.session.setPassword(ftpPassword);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("UseDNS", "no");
            this.session.setConfig(config);
            this.session.setTimeout(50000);
            this.session.connect(60000);
            LOGGER.error((Object)"Session connected.");
            LOGGER.error((Object)"Opening SFTP Channel.");
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            LOGGER.error((Object)"Session created.start");
            this.channel.connect();
            LOGGER.error((Object)"Session created. end");
            LOGGER.error((Object)("\u8fde\u63a5FTP\u670d\u52a1\u5668\u6210\u529f \uff0cConnected successfully to ftpHost = " + ftpHost + ",as ftpUserName = " + ftpUserName + ", returning: " + this.channel));
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25\uff1aconnect to ftpHost = " + ftpHost + ",as ftpUserName = " + ftpUserName + ",as ftpPort = " + ftpPort + "  returning: error"));
            throw new Exception(e + "Connected  to ftpHost = " + ftpHost + ",as ftpUserName = " + ftpUserName + ",as ftpPort = " + ftpPort + "  returning: error");
        }
        return this.channel;
    }

    public void closeChannel(ChannelSftp channelSftp) throws Exception {
        try {
            if (channelSftp != null) {
                channelSftp.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"close sftp error", (Throwable)e);
            throw new Exception(e);
        }
    }

    public void closeChannel() throws Exception {
        try {
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"close sftp error", (Throwable)e);
            throw new Exception(e);
        }
    }

    public byte[] downloadFile(String remotePath) throws Exception {
        OutputStream output = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = this.channel.get(remotePath);
            byte[] bytes = new byte[4096];
            int c = 0;
            while ((c = is.read(bytes)) != -1) {
                bos.write(bytes, 0, c);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Download file error", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new Exception(e);
                }
            }
        }
    }

    public byte[] downloadFile(String remotePath, ChannelSftp channel1) throws Exception {
        OutputStream output = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = channel1.get(remotePath);
            byte[] bytes = new byte[4096];
            int c = 0;
            while ((c = is.read(bytes)) != -1) {
                bos.write(bytes, 0, c);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Download file error", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new Exception(e);
                }
            }
        }
    }
}

