/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.fm.be.app.util.CloundDriveUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class KingDeeCloundDriveApiUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils");
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.be.CloundDriveStatusResource";
    public static final String REQERRORCODE = "-1";
    public static final String DRIVESUCCESS = "0";
    public static final String FOLDER_NOT_EXITS = "2002";

    public static Map<String, String> getUserAccessToken(Context ctx, String client_id, String client_secret, String userName, String pd) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuffer accessTokenURL = new StringBuffer();
        accessTokenURL.append("http://api.kingdee.com/auth/user/access_token?");
        accessTokenURL.append("client_id=" + client_id);
        accessTokenURL.append("&client_secret=" + client_secret);
        accessTokenURL.append("&username=" + userName);
        accessTokenURL.append("&password=" + pd);
        try {
            String accessTokenJSON = CloundDriveUtils.sendGetRequest(accessTokenURL.toString());
            JSONObject rsJson = new JSONObject(accessTokenJSON);
            String errcode = rsJson.getString("errcode");
            resultMap.put("errcode", errcode);
            resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
            if (errcode.equals(DRIVESUCCESS)) {
                JSONObject dataObject = rsJson.getJSONObject("data");
                String accessToken = dataObject.getString("access_token");
                String uid = dataObject.getString("uid");
                resultMap.put("access_token", accessToken);
                resultMap.put("uid", uid);
            }
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1129_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + accessTokenURL.toString();
            resultMap.put("errcode", REQERRORCODE);
            resultMap.put("description", exMsg);
            logger.error((Object)exMsg);
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map<String, String> getOrgAccessToken(Context ctx, String client_id, String client_secret, String tid, String orgSecret) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuffer accessTokenURL = new StringBuffer();
        accessTokenURL.append("http://api.kingdee.com/auth/org/access_token?");
        accessTokenURL.append("client_id=" + client_id);
        accessTokenURL.append("&client_secret=" + client_secret);
        accessTokenURL.append("&tid=" + tid);
        accessTokenURL.append("&secret=" + orgSecret);
        try {
            String orgAccessTokenURLJSON = CloundDriveUtils.sendGetRequest(accessTokenURL.toString());
            JSONObject rsJson = new JSONObject(orgAccessTokenURLJSON);
            String errcode = rsJson.getString("errcode");
            resultMap.put("errcode", errcode);
            resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
            if (errcode.equals(DRIVESUCCESS)) {
                JSONObject dataObject = rsJson.getJSONObject("data");
                String accessToken = dataObject.getString("access_token");
                resultMap.put("access_token", accessToken);
            }
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1130_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + accessTokenURL.toString();
            resultMap.put("errcode", REQERRORCODE);
            resultMap.put("description", exMsg);
            logger.error((Object)exMsg);
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map<String, String> getUserOrgs(Context ctx, String orgName, String userAccessToken) throws Exception {
        HashMap<String, String> resultMap;
        block3: {
            resultMap = new HashMap<String, String>();
            String url = "http://api.kingdee.com/passport/user/orgs?access_token=" + userAccessToken;
            try {
                String orgsJSON = CloundDriveUtils.sendGetRequest(url);
                JSONObject rsJson = new JSONObject(orgsJSON);
                String errcode = rsJson.getString("errcode");
                resultMap.put("errcode", errcode);
                resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
                if (!errcode.equals(DRIVESUCCESS)) break block3;
                JSONArray dataArrayObject = rsJson.getJSONArray("data");
                for (int i = 0; i < dataArrayObject.length(); ++i) {
                    JSONObject orgJSON = (JSONObject)dataArrayObject.get(i);
                    String rsOrgName = orgJSON.getString("name");
                    if (!orgName.equals(rsOrgName)) continue;
                    resultMap.put("tid", orgJSON.getString("tid"));
                    resultMap.put("secret", orgJSON.getString("secret"));
                    break;
                }
            }
            catch (Exception e) {
                String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1131_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + url.toString();
                resultMap.put("errcode", REQERRORCODE);
                resultMap.put("description", exMsg);
                logger.error((Object)exMsg);
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public static Map<String, String> isExistFolder(Context ctx, String folderName, String parentFolderId, String accessToken, String uid) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String url = "http://api.kingdee.com/kdrive/org/folder/existence?access_token=" + accessToken;
        url = url + "&name=" + folderName;
        url = url + "&uid=" + uid;
        if (parentFolderId != null) {
            url = url + "&pfolder_id=" + parentFolderId;
        }
        try {
            String folderJSON = CloundDriveUtils.sendGetRequest(url);
            JSONObject rsJson = new JSONObject(folderJSON);
            String errcode = rsJson.getString("errcode");
            resultMap.put("errcode", errcode);
            resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
            if (errcode.equals(DRIVESUCCESS)) {
                String folder_id = rsJson.getString("folder_id");
                resultMap.put("folder_id", folder_id);
            }
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1132_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + folderName + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1133_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + url.toString();
            resultMap.put("errcode", REQERRORCODE);
            resultMap.put("description", exMsg);
            logger.error((Object)exMsg);
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map<String, String> createFolder(Context ctx, String folderName, String parentFolderId, String orgAccessToken, String uid) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String url = "http://api.kingdee.com/kdrive/org/folder?access_token=" + orgAccessToken;
        StringBuffer sb = new StringBuffer();
        String params = "";
        sb.append("name").append("=").append(URLEncoder.encode(folderName, "UTF-8"));
        sb.append("&uid").append("=").append(URLEncoder.encode(uid, "UTF-8"));
        if (parentFolderId != null) {
            sb.append("&pfolder_id").append("=").append(URLEncoder.encode(parentFolderId, "UTF-8"));
        }
        params = sb.toString();
        try {
            String folderJSON = CloundDriveUtils.sendPOSTRequest(url, params);
            JSONObject rsJson = new JSONObject(folderJSON);
            String errcode = rsJson.getString("errcode");
            resultMap.put("errcode", errcode);
            resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
            if (errcode.equals(DRIVESUCCESS)) {
                String folder_id = rsJson.getString("folder_id");
                resultMap.put("folder_id", folder_id);
            }
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1134_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + folderName + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1133_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + url.toString();
            resultMap.put("errcode", REQERRORCODE);
            resultMap.put("description", exMsg);
            logger.error((Object)exMsg);
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map<String, String> uploadFileToOrgDrive(Context ctx, String orgAccessToken, byte[] fileValue, String fileName, String folderId, String uid) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String url = "http://api.kingdee.com/kdrive/org/file?access_token=" + orgAccessToken;
        if (folderId != null) {
            url = url + "&folder_id=" + folderId;
        }
        url = url + "&uid=" + uid;
        try {
            String fileJSON = CloundDriveUtils.uploadFile(url, fileValue, fileName);
            JSONObject rsJson = new JSONObject(fileJSON);
            String errcode = rsJson.getString("errcode");
            resultMap.put("errcode", errcode);
            resultMap.put("description", KingDeeCloundDriveApiUtils.getResourceValue(errcode));
            if (errcode.equals(DRIVESUCCESS)) {
                JSONObject dataObject = rsJson.getJSONObject("data");
                String fileId = dataObject.getString("file_id");
                resultMap.put("file_id", fileId);
            }
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1135_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + fileName + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1136_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + url.toString();
            resultMap.put("errcode", REQERRORCODE);
            resultMap.put("description", exMsg);
            logger.error((Object)exMsg);
            e.printStackTrace();
        }
        return resultMap;
    }

    public static byte[] getFileValue(String fileId, String orgAccessToken, String uid) throws Exception {
        String url = "http://api.kingdee.com/kdrive/org/file?access_token=" + orgAccessToken;
        url = url + "&uid=" + uid;
        url = url + "&file_id=" + fileId;
        byte[] fileValue = CloundDriveUtils.sendGetRequestReturnStream(url);
        return fileValue;
    }

    private static String getResourceValue(String errcode) {
        return EASResource.getString((String)RESOURCE_PATH, (String)errcode);
    }

    public static String getExMsg(Context ctx, Map<String, String> resultMap) {
        String errcode = resultMap.get("errcode");
        String description = resultMap.get("description");
        if (errcode.equals(REQERRORCODE)) {
            return description;
        }
        return ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1137_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + errcode + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1138_KingDeeCloundDriveApiUtils", (Locale)ctx.getLocale()) + description;
    }
}

