/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondReleasePlanStateEnum;
import com.kingdee.eas.fm.bond.BondReleaseReportStateEnum;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.bond.RegisterNoticeStateEnum;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;

public class BondClientUtil {
    public static final String MIN_VALUE = "0";
    public static final String MAX_VALUE = "9999999999999";
    public static final String _MAX_VALUE = "-9999999999999";

    public static KDFormattedTextField numberControlFormat(KDFormattedTextField formattedTextField) {
        return BondClientUtil.numberControlFormat(formattedTextField, 0);
    }

    public static KDFormattedTextField numberControlFormat(KDFormattedTextField formattedTextField, int precision) {
        return BondClientUtil.numberControlFormat(formattedTextField, precision, MIN_VALUE, MAX_VALUE);
    }

    public static KDFormattedTextField numberControlFormat(KDFormattedTextField formattedTextField, String minVal, String maxVal) {
        return BondClientUtil.numberControlFormat(formattedTextField, 0, minVal, maxVal);
    }

    public static KDFormattedTextField numberControlFormat(KDFormattedTextField formattedTextField, int precision, String minVal, String maxVal) {
        if (formattedTextField == null) {
            formattedTextField = new KDFormattedTextField();
        }
        formattedTextField.setDataType(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setPrecision(precision);
        formattedTextField.setMinimumValue((Comparable)new BigDecimal(minVal));
        formattedTextField.setMaximumValue((Comparable)new BigDecimal(maxVal));
        formattedTextField.setRemoveingZeroInDispaly(false);
        return formattedTextField;
    }

    public static void setComponentEnable(JComponent source, boolean enable) {
        for (int i = 0; i < source.getComponentCount(); ++i) {
            Component c = source.getComponent(i);
            if (c instanceof JComponent && ((JComponent)c).getComponentCount() > 0) {
                if (c instanceof KDBizPromptBox) {
                    ((KDBizPromptBox)c).setEnabled(enable);
                }
                if (c instanceof KDDatePicker) {
                    ((KDDatePicker)c).setEnabled(enable);
                }
                if (c instanceof KDComboBox) {
                    ((KDComboBox)c).setEnabled(enable);
                }
                if (c instanceof KDTable) {
                    ((KDTable)c).getStyleAttributes().setLocked(!enable);
                }
                if (c instanceof KDSpinner) {
                    ((KDSpinner)c).setEnabled(enable);
                }
                BondClientUtil.setComponentEnable((JComponent)c, enable);
                continue;
            }
            if (c instanceof KDFormattedTextField) {
                ((KDFormattedTextField)c).setEnabled(enable);
            }
            if (c instanceof KDTextField) {
                ((KDTextField)c).setEnabled(enable);
            }
            if (c instanceof KDWorkButton) {
                ((KDWorkButton)c).setEnabled(enable);
            }
            if (c instanceof KDCheckBox) {
                ((KDCheckBox)c).setEnabled(enable);
            }
            if (!(c instanceof KDTextArea)) continue;
            ((KDTextArea)c).setEnabled(enable);
        }
    }

    public static void verifyNumberMoreThanZero(CoreUIObject ui, KDFormattedTextField txtAmount) {
        if (!FMBillBigDecimalUtil.isGtZero((Object)txtAmount.getBigDecimalValue())) {
            MsgBox.showInfo((Component)ui, (String)(BondClientUtil.getComponentLabelText((Component)txtAmount) + EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"6_BondClientUtil")));
            txtAmount.requestFocus(true);
            SysUtil.abort();
        }
    }

    private static String getComponentLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void fillRegisterNoticeState(KDComboBox cbbState) {
        cbbState.removeAllItems();
        cbbState.addItems(RegisterNoticeStateEnum.getEnumList().toArray());
    }

    public static void fillBondReleasePlanState(KDComboBox cbbState) {
        cbbState.removeAllItems();
        cbbState.addItems(BondReleasePlanStateEnum.getEnumList().toArray());
    }

    public static void fillBondReleaseReportState(KDComboBox cbbState) {
        cbbState.removeAllItems();
        cbbState.addItems(BondReleaseReportStateEnum.getEnumList().toArray());
    }

    public static void showMessage(CoreUI UI, String msg) {
        UI.setMessageText(msg);
        UI.showMessage();
    }

    public static void resetYearDays(KDComboBox comboIntRateTypeExpression, KDFormattedTextField txtYearDays) {
        if (comboIntRateTypeExpression != null && comboIntRateTypeExpression.getSelectedItem() != null) {
            txtYearDays.setValue((Object)new Integer(BondUtil.getDefaultDays((IntRateTypeExpressionEnum)comboIntRateTypeExpression.getSelectedItem())));
        }
    }

    public static void resetYieldRate(CoreUIObject ui, KDFormattedTextField txtYieldRate, KDFormattedTextField txtBasePoints, KDComboBox cbbCurrency, KDDatePicker pkIssueDate, KDBizPromptBox prmtIntRateType, KDComboBox comboFloatAction) throws BOSException, EASBizException {
        if (!BondClientUtil.isXIEYILILV(prmtIntRateType)) {
            BigDecimal basePoints;
            FloatActionEnum floatAction;
            IntRateTypeInfo intRateType;
            Date issueDate;
            CurrencyInfo currency = (CurrencyInfo)cbbCurrency.getSelectedItem();
            BigDecimal bdYieldRate = BondUtil.getYieldRate(currency, issueDate = DateTimeUtils.truncateDate((Date)pkIssueDate.getSqlDate()), intRateType = (IntRateTypeInfo)prmtIntRateType.getValue(), floatAction = (FloatActionEnum)comboFloatAction.getSelectedItem(), basePoints = txtBasePoints.getBigDecimalValue());
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            txtYieldRate.setValue((Object)bdYieldRate);
        }
    }

    public static void reset3IntRateControl(KDBizPromptBox prmtIntRateType, KDComboBox comboIntRateTypeExpression, KDFormattedTextField txtYearDays, KDLabelContainer contYieldRate) throws EASBizException, BOSException {
        IntRateTypeInfo intRateInfo;
        if (!BondClientUtil.isXIEYILILV(prmtIntRateType) && (intRateInfo = (IntRateTypeInfo)prmtIntRateType.getValue()) != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("factorDay"));
            IntRateTypeInfo ifInfo = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(intRateInfo.getId()), evi.getSelector());
            if (ifInfo.getRateExpression().getValue().equals("year")) {
                comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
                contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI"));
            } else if (ifInfo.getRateExpression().getValue().equals("month")) {
                comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.MONTH);
                contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
            } else {
                comboIntRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.DAY);
                contYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
            }
            int intRate = ifInfo.getFactorDay();
            txtYearDays.setValue((Object)new Integer(intRate));
        }
    }

    public static boolean isXIEYILILV(KDBizPromptBox prmtIntRateType) {
        IntRateTypeInfo intRateTypeInfo = (IntRateTypeInfo)prmtIntRateType.getValue();
        return intRateTypeInfo == null || BondUtil.isXIEYILILV(intRateTypeInfo);
    }

    public static int getPrecOfExRate(KDComboBox cbbCurrency, IRow row, String columnField) {
        CurrencyInfo srcCurr = (CurrencyInfo)cbbCurrency.getSelectedItem();
        CurrencyInfo destCurr = (CurrencyInfo)row.getCell(columnField).getValue();
        return BondUtil.getPrecOfExRate(srcCurr, destCurr);
    }

    public static void setExchangeRateCreditLimit(ICell cell, CompanyOrgUnitInfo company, KDComboBox cbbCurrency, CurrencyInfo destCurr, KDDatePicker pkBizDate) {
        try {
            FinUtils.initExchangeRateRelAss(null, (ICell)cell, (CompanyOrgUnitInfo)company, (CurrencyInfo)((CurrencyInfo)cbbCurrency.getSelectedItem()), (CurrencyInfo)destCurr, (Date)((Date)pkBizDate.getValue()));
        }
        catch (Exception e) {
            cell.setValue((Object)Constants.ONE);
        }
    }

    public static void verifyGtZero(CoreUIObject ui, KDFormattedTextField txtNumber) {
        if (!FMBillBigDecimalUtil.isGtZero((Object)txtNumber.getBigDecimalValue())) {
            MsgBox.showInfo((Component)ui, (String)(BondClientUtil.getCompLabelText((Component)txtNumber) + EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"6_BondClientUtil")));
            txtNumber.requestFocus(true);
            SysUtil.abort();
        }
    }

    public static void verifyGeZero(CoreUIObject ui, KDFormattedTextField txtNumber) {
        if (!FMBillBigDecimalUtil.isGeZero((Object)txtNumber.getBigDecimalValue())) {
            MsgBox.showInfo((Component)ui, (String)(BondClientUtil.getCompLabelText((Component)txtNumber) + EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"7_BondClientUtil")));
            txtNumber.requestFocus(true);
            SysUtil.abort();
        }
    }

    public static void verifyDate(CoreUIObject ui, KDFormattedTextField txtNumber) {
        if (txtNumber == null) {
            return;
        }
        if (!FMBillBigDecimalUtil.isGtZero((Object)txtNumber.getBigDecimalValue())) {
            MsgBox.showInfo((Component)ui, (String)(BondClientUtil.getCompLabelText((Component)txtNumber) + EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"6_BondClientUtil")));
            txtNumber.requestFocus(true);
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDate(CoreUIObject ui, KDDatePicker pkBeginDate, KDDatePicker pkEndDate, boolean isCanEquals) {
        if (pkBeginDate == null || pkEndDate == null) {
            return;
        }
        if (pkBeginDate.getValue() == null || pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"pkDateIsNull"));
            SysUtil.abort();
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)((Date)pkBeginDate.getValue()));
        Date endDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        boolean flag = false;
        if (beginDate != null && endDate != null) {
            if (isCanEquals) {
                if (beginDate.after(endDate)) {
                    flag = true;
                }
            } else if (!endDate.after(beginDate)) {
                flag = true;
            }
        }
        if (flag) {
            MsgBox.showInfo((Component)ui, (String)(BondClientUtil.getCompLabelText((Component)pkEndDate) + EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"8_BondClientUtil") + (isCanEquals ? EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"9_BondClientUtil") : EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"10_BondClientUtil")) + BondClientUtil.getCompLabelText((Component)pkBeginDate)));
            pkEndDate.requestFocus(true);
            SysUtil.abort();
        }
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }
}

