/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMBillBaseInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class BondUtil {
    private static final String RESOURCE = "com.kingdee.eas.fm.bond.FMBondResource";

    public static CompanyOrgUnitInfo getCurrentCompany() {
        return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public static CurrencyInfo initCurrentCurrency(CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()), selectors);
        CurrencyInfo currcurr = info.getBaseCurrency();
        return currcurr;
    }

    public static CurrencyInfo initCurrentCurrency() throws BOSException, EASBizException {
        return BondUtil.initCurrentCurrency(BondUtil.getCurrentCompany());
    }

    public static boolean isXIEYILILV(IntRateTypeInfo intRateTypeInfo) {
        return intRateTypeInfo.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=");
    }

    public static String getResouseString(String resKey) {
        return EASResource.getString((String)RESOURCE, (String)resKey);
    }

    public static String getChineseFormat(BigDecimal number, boolean hasFull) {
        if (number == null) {
            number = Constants.ZERO;
        }
        if (number.equals(new BigDecimal("0E-10")) || FMBillBigDecimalUtil.isEqZero((Object)number)) {
            return GlUtils.getChineseFormat((BigDecimal)Constants.ZERO, (boolean)hasFull, (Locale)LocaleUtils.locale_l1);
        }
        return GlUtils.getChineseFormat((BigDecimal)number, (boolean)hasFull, (Locale)LocaleUtils.locale_l1);
    }

    public static Date getNowDate() {
        return DateTimeUtils.truncateDate((Date)new Date());
    }

    public static IntRateTypeInfo getRateAgreementInfo() {
        IntRateTypeInfo ifInfo = null;
        try {
            ifInfo = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK("lJlpCQEQEADgAAc+wKgSjiR9knQ="));
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return ifInfo;
    }

    public static int getDefaultDays(IntRateTypeExpressionEnum intRateTypeExpressionEnum) {
        if (IntRateTypeExpressionEnum.YEAR.equals((Object)intRateTypeExpressionEnum)) {
            return 360;
        }
        if (IntRateTypeExpressionEnum.MONTH.equals((Object)intRateTypeExpressionEnum)) {
            return 30;
        }
        if (IntRateTypeExpressionEnum.DAY.equals((Object)intRateTypeExpressionEnum)) {
            return 1;
        }
        return 1;
    }

    public static BigDecimal getYieldRate(CurrencyInfo currency, Date issueDate, IntRateTypeInfo intRateType, FloatActionEnum floatAction, BigDecimal basePoints) throws BOSException, EASBizException {
        if (currency != null && intRateType != null && issueDate != null && basePoints != null) {
            BigDecimal bdBaseRate = BondUtil.getBaseRate(intRateType, currency, issueDate);
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(Constants.ONE.add(FMBillBigDecimalUtil.divide((BigDecimal)basePoints, (BigDecimal)Constants.ONE_HUNDRED, (int)10))) : bdBaseRate.add(basePoints);
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    private static BigDecimal getBaseRate(IntRateTypeInfo intRateType, CurrencyInfo currency, Date issueDate) throws BOSException, EASBizException {
        BigDecimal bdBaseRate = null;
        IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), issueDate);
        bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
        return bdBaseRate;
    }

    public static int getPrecOfExRate(CurrencyInfo srcCurr, CurrencyInfo destCurr) {
        try {
            int precOfExRate = FMClientHelper.getPrecOfExRate(null, (String)srcCurr.getId().toString(), (String)destCurr.getId().toString(), null);
            return precOfExRate;
        }
        catch (EASBizException e) {
            return 5;
        }
        catch (BOSException e) {
            return 5;
        }
    }

    public static boolean isBotpRelation(FMBillBaseInfo info) throws BTPException, BOSException {
        Set set = FMHelper.getDestBillIdSet(null, (String)info.getId().toString());
        return set.size() > 0;
    }

    public static boolean isBotpRelation(FMBillBaseInfo info, BOSObjectType bosType) throws BOSException, EASBizException {
        ArrayList lst = FMHelper.getBotpDestBill(null, (String)info.getId().toString(), (BOSObjectType)bosType);
        return lst.size() > 0;
    }

    public static boolean getBooleanParam(Context ctx, String paramName, CompanyOrgUnitInfo currentCompany) {
        boolean ret = ctx == null ? ContextHelperFactory.getRemoteInstance().getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString())) : ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
        return ret;
    }
}

