/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.bond.AbstractCashSettleInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class CashSettleInfo
extends AbstractCashSettleInfo
implements Serializable,
IFMBgUsed {
    private BOSUuid sourceBill;
    private boolean isBat4Payable = false;
    private BondReleaseReportInfo bondReleaseReportInfo;
    private BigDecimal remAmt;
    private boolean isCreatePayment = false;
    public static final BOSObjectType BOSTYPE = new BOSObjectType("D12C40D4");

    public CashSettleInfo() {
    }

    protected CashSettleInfo(String pkField) {
        super(pkField);
    }

    public BondReleaseReportInfo getBondReleaseReportInfo() {
        return this.bondReleaseReportInfo;
    }

    public void setBondReleaseReportInfo(BondReleaseReportInfo bondReleaseReportInfo) {
        this.bondReleaseReportInfo = bondReleaseReportInfo;
    }

    public BigDecimal getRemAmt() {
        if (this.bondReleaseReportInfo != null) {
            return this.bondReleaseReportInfo.getBalance().subtract(this.getAmount());
        }
        return Constants.ZERO;
    }

    public void setRemAmt(BigDecimal remAmt) {
        this.remAmt = remAmt;
    }

    public boolean isCreatePayment() {
        return this.isCreatePayment;
    }

    public void setCreatePayment(boolean isCreatePayment) {
        this.isCreatePayment = isCreatePayment;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.sourceBill);
        marshaller.writeObject((Object)this.bondReleaseReportInfo);
        marshaller.writeObject((Object)this.remAmt);
        marshaller.writeObject((Object)new Boolean(this.isCreatePayment));
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.sourceBill = (BOSUuid)unmarshaller.readObject();
        this.bondReleaseReportInfo = (BondReleaseReportInfo)unmarshaller.readObject();
        this.remAmt = (BigDecimal)unmarshaller.readObject();
        this.isCreatePayment = (Boolean)unmarshaller.readObject();
    }

    public boolean isBat4Payable() {
        return this.isBat4Payable;
    }

    public void setBat4Payable(boolean isBat4Payable) {
        this.isBat4Payable = isBat4Payable;
    }

    public FMBgItemProp[] getBgItemProps() {
        return new FMBgItemProp[]{new FMBgItemProp("outBgItemId", "outBgItemNumber", "outBgItemName")};
    }
}

