/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond;

import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntSchemeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import java.math.BigDecimal;
import java.util.Date;

public class ImLoanInfoByBond
implements ILoanInfo {
    private BondReleaseReportInfo info;

    public ImLoanInfoByBond(BondReleaseReportInfo info) {
        this.info = info;
    }

    public Date getBizDate() {
        return this.info.getBizDate();
    }

    public int getConvertDays() {
        return this.info.getYearDays();
    }

    public CurrencyInfo getCurrency() {
        return this.info.getCurrency();
    }

    public Date getExpiredDate() {
        return this.info.getExpiredDate();
    }

    public BigDecimal getFloatPoint() {
        return this.info.getBasePoints();
    }

    public BigDecimal getIntFreeAmt() {
        return Constants.ZERO;
    }

    public BigDecimal getIntRate() {
        return this.info.getYieldRate();
    }

    public IntRateTypeInfo getIntRateType() {
        return this.info.getIntRateType();
    }

    public IntRateTypeExpressionEnum getIntRateTypeExp() {
        return this.info.getIntRateTypeExpression();
    }

    public Date getLastIntDate() {
        return this.info.getLastIntDate();
    }

    public Date getLastPreIntDate() {
        return this.info.getLastPreIntDate();
    }

    public BigDecimal getLoanBalance() {
        return this.info.getBalance();
    }

    public BigDecimal getLoanTotalAmt() {
        return this.info.getAmount();
    }

    public BigDecimal getPunishIntRate() {
        BigDecimal ret = null;
        ret = PenAccrualTypeEnum.ADD_PERCENT.equals((Object)this.info.getPunishIntRateType()) ? this.info.getPunishIntRate() : this.info.getPunishAddIntRate();
        return ret == null ? Constants.ZERO : ret;
    }

    public PenAccrualTypeEnum getPunishIntRateType() {
        return this.info.getPunishIntRateType();
    }

    public Date getStartDate() {
        return this.info.getIssueDate();
    }

    public Date getFirstRateAdjustDate() {
        return this.info.getFirstRateAdjustDate();
    }

    public int getRateAdjustPeriod() {
        return this.info.getRateAdjustPeriod();
    }

    public IntSchemeInfo getPayIntMode() {
        return this.info.getPayIntMode();
    }

    public FloatActionEnum getFloatAction() {
        return this.info.getFloatAction();
    }
}

