/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;

public class KDTableTotalRowUtil {
    private KDTable table;
    private String[] columnNames;

    public KDTableTotalRowUtil(KDTable table, String[] columnNames) {
        this.table = table;
        this.columnNames = columnNames;
    }

    public void resetTotalRow() {
        this.removeTotalRow();
        this.addTotalRow();
        int idx = this.locateTotalRow();
        IRow totalRow = this.table.getRow(idx);
        for (int i = 0; i < this.columnNames.length; ++i) {
            totalRow.getCell(this.columnNames[i]).setValue((Object)this.calculate(this.columnNames[i]));
        }
    }

    public BigDecimal calculate(String columnName) {
        int rowCount = this.table.getRowCount();
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            sum = FMHelper.add((BigDecimal)sum, (BigDecimal)((BigDecimal)row.getCell(columnName).getValue()));
        }
        return sum;
    }

    private void addTotalRow() {
        int idx = this.locateTotalRow();
        if (idx == -1) {
            IRow totalRow = this.table.addRow();
            totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            totalRow.getStyleAttributes().setLocked(true);
            totalRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"31_BondReleasePlanEditUI"));
            totalRow.getCell(0).getStyleAttributes().setBold(true);
            totalRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
    }

    public void removeTotalRow() {
        int idx = this.locateTotalRow();
        if (idx != -1) {
            this.table.removeRow(idx);
        }
    }

    private int locateTotalRow() {
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            if (!row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            return i;
        }
        return -1;
    }

    public int locateLastRow() {
        int rowCount = this.table.getRowCount();
        int lastRow = -1;
        int i = 0;
        while (i < rowCount) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) {
                return i - 1;
            }
            lastRow = i++;
        }
        return lastRow;
    }

    public IRow getLastRow() {
        int lastRow = this.locateLastRow();
        return lastRow >= 0 ? this.table.getRow(lastRow) : null;
    }

    public void verifyTotalRowEq(CoreUIObject ui, KDTabbedPane tabbedPane, String fieldName, BigDecimal number, String msg) {
        tabbedPane.setSelectedComponent((Component)this.table.getParent());
        if (!FMBillBigDecimalUtil.eq((Object)this.calculate(fieldName), (Object)number)) {
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public BigDecimal adjustLastRow(CoreUIObject ui, String fieldName, BigDecimal total, String msg) {
        int lastRow = this.locateLastRow();
        boolean isShowMsg = true;
        BigDecimal retValue = Constants.ZERO;
        if (lastRow == -1) {
            return retValue;
        }
        int rowCount = this.table.getRowCount();
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            if (i == lastRow) {
                retValue = FMHelper.subtract((BigDecimal)total, (BigDecimal)sum);
                if (FMBillBigDecimalUtil.isLtZero((Object)retValue)) {
                    if (isShowMsg) {
                        MsgBox.showInfo((Component)ui, (String)msg);
                        isShowMsg = false;
                    }
                    retValue = Constants.ZERO;
                }
                row.getCell(fieldName).setValue((Object)retValue);
                break;
            }
            BigDecimal result = (BigDecimal)row.getCell(fieldName).getValue();
            sum = sum.add(result);
        }
        return retValue;
    }
}

