/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondAdjustInterestInfo;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.app.AbstractBondAdjustInterestControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondAdjustInterestControllerBean
extends AbstractBondAdjustInterestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.BondAdjustInterestControllerBean");

    @Override
    protected Map _batchAdjust(Context ctx, Set bondReleaseReportIDSet, Date adjustDate, IntRateTypeExpressionEnum intRateTypeExpression, Integer yearDays, BigDecimal adjustAfterRate, PenAccrualTypeEnum penAccrualType, BigDecimal adjustPenAccrualRate) throws BOSException, EASBizException {
        HashMap hm = new HashMap();
        HashSet<IObjectPK> createdIdSet = new HashSet<IObjectPK>();
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo CURRENT_USER = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (String bondReleaseReportID : bondReleaseReportIDSet) {
            BondReleaseReportInfo bondReleaseReportInfo = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(bondReleaseReportID), this.getBondReleaseReportSelectors());
            BondAdjustInterestInfo adjustInfo = new BondAdjustInterestInfo();
            adjustInfo.setBondReleaseReport(bondReleaseReportInfo);
            adjustInfo.setAdjustSeq(this._getMaxSeq(ctx, (IObjectPK)new ObjectUuidPK(bondReleaseReportID)));
            adjustInfo.setAdjustDate(adjustDate);
            adjustInfo.setIntRateTypeExpression(intRateTypeExpression);
            adjustInfo.setYearDays(yearDays);
            adjustInfo.setAdjustAfterRate(adjustAfterRate);
            adjustInfo.setPenAccrualType(penAccrualType);
            adjustInfo.setPenAccrualRate(adjustPenAccrualRate);
            adjustInfo.setIsUsed(IsOrNoEnum.NO);
            adjustInfo.setCreator(CURRENT_USER);
            adjustInfo.setCompany(CURRENT_COMPANY);
            IObjectPK pk = this._submit(ctx, (IObjectValue)adjustInfo);
            createdIdSet.add(pk);
        }
        hm.put("createdIdSet", createdIdSet);
        return hm;
    }

    @Override
    protected Set _filterBondReleaseReportIDSet(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<String> filterBondReleaseReportIDSet = new HashSet<String>();
        for (String bondReleaseReportID : idSet) {
            filterBondReleaseReportIDSet.add(bondReleaseReportID);
        }
        return filterBondReleaseReportIDSet;
    }

    @Override
    protected Integer _getMaxSeq(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxAdjustSeq = 0;
        String sql = " select isnull(max(FAdjustSeq),0) from T_FM_BondAdjustInterest where FBondReleaseReportID = ? ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxAdjustSeq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return new Integer(++maxAdjustSeq);
    }

    protected SelectorItemCollection getBondReleaseReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("BankAcct.*"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        BondAdjustInterestInfo info = (BondAdjustInterestInfo)model;
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        BondReleaseReportInfo bondReleaseReportInfo = info.getBondReleaseReport();
        Date adjustDate = info.getAdjustDate();
        if (adjustDate.before(bondReleaseReportInfo.getIssueDate())) {
            throw new BondException(BondException.ADJUSTDATEMUSTAFTERLOANDATE);
        }
        this.checkNumberDup(ctx, model);
        this.checkSeqDup(ctx, model);
        this.checkSameDay(ctx, (BondAdjustInterestInfo)model);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        botpRelationShip.put(info.getBondReleaseReport().getId().toString(), info.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
        return pk;
    }

    private void checkSameDay(Context ctx, BondAdjustInterestInfo info) throws BOSException, EASBizException {
        String id = info.getBondReleaseReport().getId().toString();
        String sql = "select fid from T_FM_BondAdjustInterest where FBondReleaseReportID = ? and FAdjustDate = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id, info.getAdjustDate()});
        try {
            if (rs.next() && !(info.getId() + "").equals(rs.getString("fid"))) {
                throw new FinBizException(FinBizException.SAMEDAY, new Object[]{info.getBondReleaseReport().getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void checkSeqDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = this.getCheckSeqDupFilter(model, true, "adjustSeq");
        if (this._exists(ctx, filter)) {
            throw new FinBizException(FinBizException.CHECKDUPSEQ, new Object[]{model.getString("adjustSeq"), ""});
        }
    }

    protected FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("BondReleaseReport.id", (Object)model.getString("BondReleaseReport.id")));
        return filter;
    }

    private void deleteAfterRemoveBotp(Context ctx, IObjectPK pk) throws BOSException {
        Object[] paramList = new Object[]{pk.toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        this.deleteAfterRemoveBotp(ctx, pk);
    }
}

