/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.bond.BondAdjustInterestCollection;
import com.kingdee.eas.fm.bond.BondAdjustInterestFactory;
import com.kingdee.eas.fm.bond.BondAdjustInterestInfo;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.BondInterestCollection;
import com.kingdee.eas.fm.bond.BondInterestEntryInfo;
import com.kingdee.eas.fm.bond.BondInterestFactory;
import com.kingdee.eas.fm.bond.BondInterestInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportCollection;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.CashSettleCollection;
import com.kingdee.eas.fm.bond.CashSettleFactory;
import com.kingdee.eas.fm.bond.CashSettleInfo;
import com.kingdee.eas.fm.bond.ImAdjustIntRateCollectionByBond;
import com.kingdee.eas.fm.bond.ImLoanInfoByBond;
import com.kingdee.eas.fm.bond.ImRepaymentBillCollectionByBond;
import com.kingdee.eas.fm.bond.ImRepaymentBillInfoByBond;
import com.kingdee.eas.fm.bond.IntReverseInBondFacadeFactory;
import com.kingdee.eas.fm.bond.app.AbstractBondInterestControllerBean;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.StrikeEnum;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondInterestControllerBean
extends AbstractBondInterestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.BondInterestControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.FinResource";
    private Map botpRelationShip = new HashMap();
    private Map imMap = new HashMap();

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        BondInterestInfo bondInterestInfo = (BondInterestInfo)model;
        bondInterestInfo.setIsGenPayBill(false);
        IObjectPK pkReturn = super._addnew(ctx, model);
        this.afterBondInterestCreated(ctx, bondInterestInfo, pkReturn);
        bondInterestInfo.setCashSettleInfo(((BondInterestInfo)model).getCashSettleInfo());
        this.afterSubmit(ctx, bondInterestInfo, pkReturn);
        return pkReturn;
    }

    private void afterBondInterestCreated(Context ctx, BondInterestInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (infoInt.getInterestType().getValue() == 4) {
            this.afterRecIntSave(ctx, infoInt, pkReturn);
        } else if (infoInt.getInterestType().getValue() == 0 || infoInt.getInterestType().getValue() == 2) {
            // empty if block
        }
    }

    private void afterRecIntSave(Context ctx, BondInterestInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        this.saveBOTPRelationShip(ctx, infoInt, pkReturn);
        this.action1(ctx, infoInt);
        IntReverseInBondFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(infoInt);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ((BondInterestInfo)model).setStatusExtEnum(StatusExtEnum.SAVE);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BondInterestInfo oldInfo;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((BondInterestInfo)model));
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        BondInterestInfo bondInterestInfo = (BondInterestInfo)model;
        boolean isNeedSubmitCheck = true;
        if (StatusExtEnum.SUBMIT.equals((Object)bondInterestInfo.getStatusExtEnum())) {
            isNeedSubmitCheck = false;
        }
        bondInterestInfo.setStatusExtEnum(StatusExtEnum.SUBMIT);
        if (null != bondInterestInfo.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(bondInterestInfo.getId())) && (oldInfo = this.getBondInterestInfo(ctx, "select * where id='" + bondInterestInfo.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        IObjectPK pk = super._submit(ctx, model);
        BondInterestInfo info = (BondInterestInfo)this.getValue(ctx, pk);
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            if (isNeedSubmitCheck) {
                this.submitCheck(ctx, info);
            }
            this.afterSubmit(ctx, info, pk);
        }
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((BondInterestInfo)model));
        return pk;
    }

    private void submitCheck(Context ctx, BondInterestInfo bondInterestInfo) throws EASBizException, BOSException {
        java.util.Date lastPreDate;
        java.util.Date startDate;
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.PRE_INT && (startDate = DateTimeUtils.truncateDate((java.util.Date)bondInterestInfo.getBeginDate())).compareTo(lastPreDate = this.getLastPreDate(ctx, bondInterestInfo)) < 0) {
            throw new CHLoanException(CHLoanException.PREERROR, new Object[]{bondInterestInfo.getNumber()});
        }
    }

    private java.util.Date getLastPreDate(Context ctx, BondInterestInfo bondInterestInfo) throws EASBizException, BOSException {
        java.util.Date lastRec;
        BondReleaseReportInfo info = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(bondInterestInfo.getBondReleaseReport().getId().toString()));
        if (info.getLastPreIntDate() == null && info.getLastIntDate() == null) {
            return info.getIssueDate();
        }
        if (info.getLastPreIntDate() == null && info.getLastIntDate() != null) {
            return info.getLastIntDate();
        }
        if (info.getLastPreIntDate() != null && info.getLastIntDate() == null) {
            return info.getLastPreIntDate();
        }
        java.util.Date lastPre = info.getLastPreIntDate();
        if (lastPre.compareTo(lastRec = info.getLastIntDate()) >= 0) {
            return lastPre;
        }
        return lastRec;
    }

    private void afterSubmit(Context ctx, BondInterestInfo bondInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        if (bondInterestInfo.getInterestType().getValue() == 4) {
            this.afterRecIntSubmit(ctx, bondInterestInfo, pk);
        } else if (bondInterestInfo.getInterestType().getValue() == 0) {
            this.afterPreIntSubmit(ctx, bondInterestInfo, pk);
        } else if (bondInterestInfo.getInterestType().getValue() == 2) {
            this.afterRepaySubmit(ctx, bondInterestInfo, pk);
        }
    }

    private void afterRepaySubmit(Context ctx, BondInterestInfo bondInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this.saveRepayBill(bondInterestInfo, ctx, pk);
        if (this.imMap.get("imid") != null) {
            LoanInterestEntryCollection iCol = ((LoanInterestInfo)this.imMap.get("imid")).getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                this.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), bondInterestInfo);
            }
        }
        if (bondInterestInfo.getCashSettleInfo().getTotalAmount().compareTo(this.getBondReleaseReportPassByCashSettle(ctx, bondInterestInfo.getCashSettleInfo()).getAmount()) == 0) {
            this.action1(ctx, bondInterestInfo);
        }
    }

    private void saveRepayBill(BondInterestInfo bondInterestInfo, Context ctx, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (bondInterestInfo.getCashSettleInfo() != null) {
            CashSettleInfo info = bondInterestInfo.getCashSettleInfo();
            info.setAccrual(FMHelper.add((BigDecimal)bondInterestInfo.getRealInterest(), (BigDecimal)bondInterestInfo.getRealPunishInterest()));
            this.saveRepaymentBill(ctx, info);
            this.saveBOTPRelationShip(ctx, bondInterestInfo, pkReturn);
            if (bondInterestInfo.getCashSettleInfo().getTotalAmount().compareTo(this.getBondReleaseReportPassByCashSettle(ctx, bondInterestInfo.getCashSettleInfo()).getAmount()) == 0) {
                IntReverseInBondFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(bondInterestInfo);
            }
        }
    }

    private void afterPreIntSubmit(Context ctx, BondInterestInfo bondInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this.saveBOTPRelationShip(ctx, bondInterestInfo, pk);
        if (bondInterestInfo.getStatusExtEnum() == StatusExtEnum.SUBMIT) {
            IntReverseInBondFacadeFactory.getLocalInstance(ctx).reverseAfterPreInt(bondInterestInfo);
        }
    }

    private void afterRecIntSubmit(Context ctx, BondInterestInfo bondInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            BondInterestInfo info = (BondInterestInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setFiVouchered(false);
            } else {
                info.setFiVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void action1(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException {
        SQLUtil sql1 = new SQLUtil();
        sql1.appendSql("update T_FM_BondInterest set FStrikeStatus=?  ");
        sql1.appendSql("where FEndDate<=?  and FInterestType = 0 and FBondReleaseReportID = ? and (FStatusExtEnum=0 or FStatusExtEnum=1)");
        sql1.addParams(new Object[]{"striked", new Date(DateUtil.getAfterDay((java.util.Date)bondInterestInfo.getEndDate()).getTime()), bondInterestInfo.getBondReleaseReport().getId().toString()});
        sql1.execute(ctx);
    }

    private void saveBOTPRelationShip(Context ctx, BondInterestInfo bondInterestInfo, IObjectPK pkReturn) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(bondInterestInfo.getBondReleaseReport().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        if (bondInterestInfo.getCashSettleInfo() != null) {
            this.botpRelationShip.clear();
            this.botpRelationShip.put(bondInterestInfo.getCashSettleInfo().getId().toString(), pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    private void saveBOTPRelationShipLoanAdjust(Context ctx, String ajustId, BondInterestInfo bondInterestInfo) throws BOSException {
        String sql = "update T_FM_BondAdjustInterest set FIsUsed = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ajustId});
        this.botpRelationShip.clear();
        this.botpRelationShip.put(ajustId, bondInterestInfo.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    private void saveRepaymentBill(Context ctx, CashSettleInfo cashSettleInfo) throws EASBizException, BOSException {
        CashSettleFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cashSettleInfo);
    }

    private IntCalModel getIntCalModel(java.util.Date startDate, java.util.Date endDate, BondReleaseReportInfo bondReleaseReportInfo, BondAdjustInterestCollection bondAdjustInterestCollection, CashSettleCollection cashSettleCollection, CashSettleInfo cashSettleInfo) {
        ImLoanInfoByBond iLoanInfo = new ImLoanInfoByBond(bondReleaseReportInfo);
        ImAdjustIntRateCollectionByBond iAdjColl = new ImAdjustIntRateCollectionByBond(bondAdjustInterestCollection);
        ImRepaymentBillCollectionByBond iRepayColl = new ImRepaymentBillCollectionByBond(cashSettleCollection);
        ImRepaymentBillInfoByBond iRepayInfo = new ImRepaymentBillInfoByBond(cashSettleInfo);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        if (startDate != null) {
            model.setNewRequirement(true);
        } else {
            model.setNewRequirement(false);
        }
        return model;
    }

    private BondInterestInfo transfrom(Context ctx, LoanInterestInfo imIntInfo, BondReleaseReportInfo bondReleaseReportInfo, CashSettleInfo cashSettleInfo) throws FinBizException, EASBizException, BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        BondInterestInfo bondInterestInfo = new BondInterestInfo();
        LoanInterestEntryCollection imIntCol = imIntInfo.getEntries();
        for (int i = 0; i < imIntCol.size(); ++i) {
            LoanInterestEntryInfo imEntryInfo = imIntCol.get(i);
            BondInterestEntryInfo finEntryInfo = new BondInterestEntryInfo();
            finEntryInfo.setSeq(imEntryInfo.getSeq());
            finEntryInfo.setBeginDate(imEntryInfo.getBeginDate());
            finEntryInfo.setEndDate(imEntryInfo.getEndDate());
            finEntryInfo.setDays(imEntryInfo.getDays());
            finEntryInfo.setAmount(imEntryInfo.getPrincipal());
            finEntryInfo.setIntRate(imEntryInfo.getIntRate());
            finEntryInfo.setInterest(imEntryInfo.getInterest());
            finEntryInfo.setYearDays(imEntryInfo.getConvertDays());
            finEntryInfo.setIntRateTypeExpression(imEntryInfo.getIntRateTypeExp());
            finEntryInfo.setDaysOverdue(imEntryInfo.getOverdueDays());
            finEntryInfo.setPunishIntRate(imEntryInfo.getPunishIntRate());
            finEntryInfo.setPunishInterest(imEntryInfo.getPunishInterest());
            bondInterestInfo.getEntrys().add(finEntryInfo);
        }
        bondInterestInfo.setCashSettleInfo(cashSettleInfo);
        bondInterestInfo.setCashSettle(cashSettleInfo);
        bondInterestInfo.setBondReleaseReport(bondReleaseReportInfo);
        bondInterestInfo.setProject(bondReleaseReportInfo.getProject());
        if (cashSettleInfo != null) {
            bondInterestInfo.setAccount(cashSettleInfo.getPayBankAcct());
        }
        bondInterestInfo.setInterestType(imIntInfo.getIntCalType());
        bondInterestInfo.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        bondInterestInfo.setCurrency(imIntInfo.getCurrency());
        bondInterestInfo.setExchange(FinUtils.getCurrencyExRate((Context)ctx, (BOSUuid)CURRENT_COMPANY.getId(), (BOSUuid)bondReleaseReportInfo.getCurrency().getId(), (BOSUuid)CURRENT_COMPANY.getBaseCurrency().getId(), (java.util.Date)new java.util.Date()));
        bondInterestInfo.setBizDate(imIntInfo.getBizDate());
        bondInterestInfo.setBeginDate(imIntInfo.getBeginDate());
        bondInterestInfo.setEndDate(imIntInfo.getEndDate());
        bondInterestInfo.setDays(imIntInfo.getDays());
        bondInterestInfo.setAmount(imIntInfo.getPrincipal());
        bondInterestInfo.setIntRate(imIntInfo.getIntRate());
        bondInterestInfo.setDaysOverdue(imIntInfo.getOverdueDays());
        bondInterestInfo.setPunishIntType(imIntInfo.getPunishType());
        bondInterestInfo.setPunishIntRate(imIntInfo.getPunishIntRate());
        bondInterestInfo.setPunishInterest(imIntInfo.getPunishInterest());
        bondInterestInfo.setInterest(imIntInfo.getInterest());
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            bondInterestInfo.setStrikeAmount(Constants.ZERO);
        } else {
            bondInterestInfo.setStrikeAmount(this.calcStrikeAmount(ctx, bondInterestInfo, cashSettleInfo));
        }
        bondInterestInfo.setStrikeStatus(StrikeEnum.NULL);
        bondInterestInfo.setFiVouchered(false);
        bondInterestInfo.setRealPunishInterest(imIntInfo.getPunishInterest());
        bondInterestInfo.setRealInterest(imIntInfo.getInterest());
        bondInterestInfo.setIntRateTypeExpression(imIntInfo.getIntRateTypeExp());
        bondInterestInfo.setLastIntDate(imIntInfo.getLastIntDate());
        bondInterestInfo.setCreator(user);
        return bondInterestInfo;
    }

    private void deleteAfterRemoveBotp(Context ctx, IObjectPK pk) throws BOSException {
        Object[] paramList = new Object[]{pk.toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondInterestInfo bondInterestInfo = this.getBondInterestInfo(ctx, pk);
        this.deleteCheck(ctx, bondInterestInfo);
        this.afterDelete(ctx, bondInterestInfo);
        Map relMap = this.getAdjustRelation(ctx, bondInterestInfo);
        BgControlFacadeFactory.getLocalInstance((Context)ctx).cancelRequestBudget(pk.toString());
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)bondInterestInfo, (String)bondInterestInfo.getCompany().getId().toString());
        super._delete(ctx, pk);
        this.deleteAfterRemoveBotp(ctx, pk);
        this.updateAdjust(ctx, bondInterestInfo, relMap);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private Map getAdjustRelation(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        HashMap<String, Object> relMap = new HashMap<String, Object>();
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = " select FSrcEntityID,FDestEntityID,FSrcObjectID from t_bot_relation where FDestObjectID = ? and FSrcEntityID = ? ";
        try {
            cn = this.getConnection(ctx);
            String srcEntityID = null;
            String destEntityID = null;
            String srcObjectID = null;
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, bondInterestInfo.getId().toString());
            pstmt.setString(2, BondAdjustInterestInfo.BOSTYPE.toString());
            rs = pstmt.executeQuery();
            int number = 0;
            while (rs.next()) {
                srcEntityID = rs.getString(1);
                destEntityID = rs.getString(2);
                srcObjectID = rs.getString(3);
                relMap.put("srcEntityID" + ++number, srcEntityID);
                relMap.put("destEntityID" + number, destEntityID);
                relMap.put("srcObjectID" + number, srcObjectID);
            }
            relMap.put("number", new Integer(number));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return relMap;
    }

    private void updateAdjust(Context ctx, BondInterestInfo bondInterestInfo, Map relMap) throws BOSException, EASBizException {
        String sql1 = " select FID from t_bot_relation where FSrcObjectID = ? and FSrcEntityID =? ";
        int number = (Integer)relMap.get("number");
        Connection cn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        cn = this.getConnection(ctx);
        try {
            for (int i = 1; i <= number; ++i) {
                String srcObjectID = relMap.get("srcObjectID" + i).toString();
                String srcEntityID = relMap.get("srcEntityID" + i).toString();
                String fid = null;
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, srcObjectID);
                pstmt.setString(2, srcEntityID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    fid = rs.getString(1);
                }
                if (fid != null) continue;
                String sql2 = " update T_FM_BondAdjustInterest set FIsUsed = 0 where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{srcObjectID});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)cn);
        }
    }

    private void deleteCheck(Context ctx, BondInterestInfo bondInterestInfo) throws EASBizException, BOSException {
        if (bondInterestInfo.isFiVouchered()) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR1);
        }
        this.check(bondInterestInfo, ctx);
    }

    private void check(BondInterestInfo bondInterestInfo, Context ctx) throws BOSException, EASBizException {
        this.checkIsLastInt(bondInterestInfo, ctx);
        if (bondInterestInfo.getInterestType().getValue() == 0) {
            this.deletePreIntCheck(bondInterestInfo, ctx);
        }
        if (bondInterestInfo.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR5, new Object[]{bondInterestInfo.getNumber()});
        }
    }

    private void deletePreIntCheck(BondInterestInfo bondInterestInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select fid from T_FM_BondInterest where fstrikestatus = ? and fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"striked", bondInterestInfo.getId().toString()});
        try {
            if (rs.next()) {
                throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
            }
        }
        catch (SQLException e) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
        }
    }

    private void checkIsLastInt(BondInterestInfo bondInterestInfo, Context ctx) throws BOSException, EASBizException {
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(bondInterestInfo, ctx);
        } else {
            this.deleteOther(bondInterestInfo, ctx);
        }
    }

    private void deletePreInt(BondInterestInfo bondInterestInfo, Context ctx) throws BOSException, CHLoanException {
        if (bondInterestInfo.getStatusExtEnum() != StatusExtEnum.SAVE) {
            String sql = "select max(fenddate) from T_FM_BondInterest where FInterestType = ? and FBondReleaseReportID = ? and FStatusExtEnum = 0 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(bondInterestInfo.getInterestType().getValue()), bondInterestInfo.getBondReleaseReport().getId().toString()});
            java.util.Date billEndDate = DateTimeUtils.truncateDate((java.util.Date)bondInterestInfo.getEndDate());
            try {
                if (rs.next()) {
                    java.util.Date maxEndDate = new java.util.Date(rs.getDate(1).getTime());
                    if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((java.util.Date)maxEndDate)) < 0) {
                        throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                    }
                }
            }
            catch (SQLException e) {
                throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
            }
        }
    }

    private void deleteOther(BondInterestInfo bondInterestInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_FM_BondInterest where (FInterestType = ? or FInterestType=?) and FBondReleaseReportID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(4), bondInterestInfo.getBondReleaseReport().getId().toString()});
        java.util.Date billEndDate = DateTimeUtils.truncateDate((java.util.Date)bondInterestInfo.getEndDate());
        try {
            if (rs.next()) {
                java.util.Date maxEndDate = new java.util.Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((java.util.Date)maxEndDate)) < 0) {
                    throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
        }
    }

    private void afterDelete(Context ctx, BondInterestInfo bondInterestInfo) throws EASBizException, BOSException {
        if (bondInterestInfo.getInterestType().getValue() == 2) {
            String cashSettleId = bondInterestInfo.getCashSettle().getId().toString();
            boolean isRepayAllBill = this.isRepayAllBill(ctx, cashSettleId);
            if (isRepayAllBill) {
                this.action4(ctx, bondInterestInfo);
                this.reverseDate(ctx, bondInterestInfo);
            }
        } else if (bondInterestInfo.getInterestType().getValue() == 4) {
            this.action4(ctx, bondInterestInfo);
            this.reverseDate(ctx, bondInterestInfo);
        } else {
            this.reverseDate(ctx, bondInterestInfo);
        }
    }

    private boolean isRepayAllBill(Context ctx, String cashSettleId) throws BOSException {
        boolean isRepayAllBill = false;
        String sql = " select T_FM_CashSettle.FTotalAmount,T_FM_BondReleaseReport.FAmount from  T_FM_CashSettle,T_FM_BondReleaseReport where T_FM_CashSettle.FSourceBillID = T_FM_BondReleaseReport.fid  and T_FM_CashSettle.fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cashSettleId});
        BigDecimal loanAmtTotal = Constants.ZERO;
        BigDecimal repayAmtTotal = Constants.ZERO;
        try {
            if (rs.next()) {
                repayAmtTotal = rs.getBigDecimal(1);
                isRepayAllBill = repayAmtTotal.compareTo(loanAmtTotal = rs.getBigDecimal(2)) == 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRepayAllBill;
    }

    private void reverseDate(Context ctx, BondInterestInfo bondInterestInfo) throws EASBizException, BOSException {
        IntReverseInBondFacadeFactory.getLocalInstance(ctx).reverseAfterDelete(bondInterestInfo);
    }

    private void action4(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException {
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.PAY_INT || bondInterestInfo.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_FM_BondInterest set FStrikeStatus=? ");
            sql.append("where FBeginDate>? and FBeginDate<? and FInterestType=0 and FBondReleaseReportID = ? ");
            String billid = bondInterestInfo.getBondReleaseReport().getId().toString();
            Date tmp = null;
            if (bondInterestInfo.getLastIntDate() == null) {
                try {
                    tmp = new Date(DateTimeUtils.parseDate((String)"1900-01-01").getTime());
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                tmp = new Date(bondInterestInfo.getLastIntDate().getTime());
            }
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"null", tmp, new Date(bondInterestInfo.getEndDate().getTime()), billid});
        }
    }

    private BondAdjustInterestCollection getAdjustColl(Context ctx, Set bondReleaseReportIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bondReleaseReport.id", (Object)bondReleaseReportIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        return BondAdjustInterestFactory.getLocalInstance(ctx).getBondAdjustInterestCollection(evi);
    }

    private CashSettleCollection getRepayColl(Context ctx, Set bondReleaseReportIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)bondReleaseReportIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("bizDate"));
        return CashSettleFactory.getLocalInstance(ctx).getCashSettleCollection(evi);
    }

    private BondReleaseReportCollection getLoanColl(Context ctx, Set bondReleaseReportIDSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bondReleaseReportIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("Institution.name"));
        evi.getSelector().add(new SelectorItemInfo("Currency.name"));
        evi.getSelector().add(new SelectorItemInfo("Currency.number"));
        evi.setFilter(filter);
        return BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportCollection(evi);
    }

    private CashSettleCollection filterRepayByID(CashSettleCollection repayColl, String bondReleaseReportId) {
        CashSettleCollection returnCol = new CashSettleCollection();
        CashSettleInfo tmp = null;
        for (int i = 0; i < repayColl.size(); ++i) {
            tmp = repayColl.get(i);
            if (!tmp.getSourceBillId().toString().equals(bondReleaseReportId)) continue;
            returnCol.add(tmp);
        }
        return returnCol;
    }

    private BondAdjustInterestCollection filterAdjustByID(BondAdjustInterestCollection adjustColl, String bondReleaseReportId) {
        BondAdjustInterestCollection returnColl = new BondAdjustInterestCollection();
        BondAdjustInterestInfo tmp = null;
        for (int i = 0; i < adjustColl.size(); ++i) {
            tmp = adjustColl.get(i);
            if (!tmp.getBondReleaseReport().getId().toString().equals(bondReleaseReportId)) continue;
            returnColl.add(tmp);
        }
        return returnColl;
    }

    private BondReleaseReportInfo filterLoanInfoByID(BondReleaseReportCollection bondReleaseReportColl, String bondReleaseReportId) {
        BondReleaseReportInfo info = null;
        for (int i = 0; i < bondReleaseReportColl.size() && !(info = bondReleaseReportColl.get(i)).getId().toString().equals(bondReleaseReportId); ++i) {
        }
        return info;
    }

    private BondReleaseReportInfo getBondReleaseReportPassByCashSettle(Context ctx, CashSettleInfo cashSettleInfo) throws BOSException {
        String id = cashSettleInfo.getSourceBillId();
        BondReleaseReportInfo bondReleaseReportInfo = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("Institution.name"));
            sic.add(new SelectorItemInfo("Currency.name"));
            sic.add(new SelectorItemInfo("BankAcct.name"));
            bondReleaseReportInfo = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return bondReleaseReportInfo;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        BondInterestInfo bondInterestInfo = (BondInterestInfo)model;
        if (bondInterestInfo.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            String sql = "update T_FM_CashSettle set FAccrual = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bondInterestInfo.getRealInterest(), bondInterestInfo.getCashSettle().getId().toString()});
        }
    }

    private BigDecimal calcStrikeAmount(Context ctx, BondInterestInfo bondInterestInfo, CashSettleInfo repayInfo) throws EASBizException, BOSException {
        BigDecimal returnValue = Constants.ZERO;
        if (repayInfo != null && repayInfo.getTotalAmount().compareTo(this.getBondReleaseReportPassByCashSettle(ctx, repayInfo).getAmount()) != 0) {
            return returnValue;
        }
        returnValue = BondInterestFactory.getLocalInstance(ctx).getStrikeAmount(bondInterestInfo);
        return returnValue;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo f = new EntityViewInfo();
        f.setFilter(filter);
        BondInterestCollection col = this.getBondInterestCollection(ctx, f);
        BondInterestInfo bondInterestInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            bondInterestInfo = col.get(i);
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)bondInterestInfo, (String)bondInterestInfo.getCompany().getId().toString());
        }
        return super._delete(ctx, filter);
    }

    @Override
    protected Map _batchPreInt(Context ctx, Set bondReleaseReportIDSet, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        String errorMsgHeader = EASResource.getString((String)RESOURCE, (String)"preInt_error_header");
        BondInterestInfo bondInterestInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        String bondReleaseReportId2 = "";
        StringBuffer sb = new StringBuffer();
        BondAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection repayColl = this.getRepayColl(ctx, bondReleaseReportIDSet);
        BondReleaseReportCollection bondReleaseReportColl = this.getLoanColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection byIDsRepay = null;
        BondAdjustInterestCollection byIDsAdjust = null;
        BondReleaseReportInfo info = null;
        for (String bondReleaseReportId2 : bondReleaseReportIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, bondReleaseReportId2);
            byIDsAdjust = this.filterAdjustByID(adjustColl, bondReleaseReportId2);
            info = this.filterLoanInfoByID(bondReleaseReportColl, bondReleaseReportId2);
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            try {
                bondInterestInfo = this.transfrom(ctx, imIntInfo, info, null);
                IObjectPK pk = super.save(ctx, (CoreBaseInfo)bondInterestInfo);
                LoanInterestEntryCollection iCol = imIntInfo.getEntries();
                for (int i = 0; i < iCol.size(); ++i) {
                    LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                    if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                    this.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), bondInterestInfo);
                }
                createdIntReceivedID.add(pk);
            }
            catch (Exception e) {
                sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
            }
        }
        hm.put("createdID", createdIntReceivedID);
        if (sb.length() > 0) {
            String msg = EASResource.getString((String)RESOURCE, (String)"preInt_errorHeader") + sb.toString();
            hm.put("failureMsg", msg);
        }
        return hm;
    }

    @Override
    protected Map _batchRecInt(Context ctx, Set bondReleaseReportIDSet, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        BondInterestInfo bondInterestInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        String errorMsgHeader = EASResource.getString((String)RESOURCE, (String)"recInt_error_header");
        StringBuffer sb = new StringBuffer();
        BondAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection repayColl = this.getRepayColl(ctx, bondReleaseReportIDSet);
        BondReleaseReportCollection bondReleaseReportColl = this.getLoanColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection byIDsRepay = null;
        BondAdjustInterestCollection byIDsAdjust = null;
        BondReleaseReportInfo info = null;
        for (String bondReleaseReportId : bondReleaseReportIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, bondReleaseReportId);
            byIDsAdjust = this.filterAdjustByID(adjustColl, bondReleaseReportId);
            info = this.filterLoanInfoByID(bondReleaseReportColl, bondReleaseReportId);
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PAY_INT).calInt(ctx, model);
            try {
                bondInterestInfo = this.transfrom(ctx, imIntInfo, info, null);
                IObjectPK pk = this._submit(ctx, (IObjectValue)bondInterestInfo);
                LoanInterestEntryCollection iCol = imIntInfo.getEntries();
                for (int i = 0; i < iCol.size(); ++i) {
                    LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                    if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                    this.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), bondInterestInfo);
                }
                createdIntReceivedID.add(pk);
            }
            catch (Exception e) {
                sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
            }
        }
        hm.put("createdID", createdIntReceivedID);
        if (sb.length() > 0) {
            String msg = EASResource.getString((String)RESOURCE, (String)"errorHeaderRec") + sb.toString();
            hm.put("failureMsg", msg);
        }
        return hm;
    }

    @Override
    protected BondInterestInfo _calInt(Context ctx, java.util.Date startDate, java.util.Date endDate, CashSettleInfo cashSettleInfo) throws BOSException, EASBizException {
        BondReleaseReportInfo bondReleaseReportInfo = this.getBondReleaseReportPassByCashSettle(ctx, cashSettleInfo);
        String bondReleaseReportId = bondReleaseReportInfo.getId().toString();
        HashSet<String> bondReleaseReportIDSet = new HashSet<String>();
        bondReleaseReportIDSet.add(bondReleaseReportId);
        BondAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection repayColl = this.getRepayColl(ctx, bondReleaseReportIDSet);
        BondReleaseReportCollection bondReleaseReportColl = this.getLoanColl(ctx, bondReleaseReportIDSet);
        CashSettleCollection byIDsRepay = null;
        BondAdjustInterestCollection byIDsAdjust = null;
        BondReleaseReportInfo info = null;
        byIDsRepay = this.filterRepayByID(repayColl, bondReleaseReportId);
        byIDsAdjust = this.filterAdjustByID(adjustColl, bondReleaseReportId);
        info = this.filterLoanInfoByID(bondReleaseReportColl, bondReleaseReportId);
        IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, cashSettleInfo);
        LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        this.imMap.put("imid", loanIntInfo);
        return this.transfrom(ctx, loanIntInfo, bondReleaseReportInfo, cashSettleInfo);
    }

    @Override
    protected void _checkSeq(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("cashSettle.id", (Object)pk));
        evi.setFilter(fil);
        BondInterestCollection col = BondInterestFactory.getLocalInstance(ctx).getBondInterestCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }

    @Override
    protected List _getBondInterestByBondReleaseReport(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        throw new BondException(BondException.TEST_EXCEPTION);
    }

    @Override
    protected BigDecimal _getStrikeAmount(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(FRealInterest) from T_FM_BondInterest ");
        sbSQL.append("where FEndDate<=? and FInterestType=0 and FStrikeStatus=? and FBondReleaseReportID = ? and fstatusextenum=0 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{new Date(bondInterestInfo.getEndDate().getTime()), "null", bondInterestInfo.getBondReleaseReport().getId().toString()});
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }
}

