/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.app.AbstractBondInterestFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondInterestFacadeControllerBean
extends AbstractBondInterestFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.BondInterestFacadeControllerBean");

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String tableName = this.getTableName(ctx, idSet);
        this.auditDoUpdate(ctx, idSet, tableName, 1);
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String tableName = this.getTableName(ctx, idSet);
        this.antiAuditDoUpdate(ctx, idSet, tableName, 0);
    }

    private String getTableName(Context ctx, Set idSet) {
        String id = idSet.toArray()[0].toString();
        BOSUuid uuid = BOSUuid.read((String)id);
        BOSObjectType bosType = uuid.getType();
        EntityObjectInfo eoi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String tableName = eoi.getTable().getName();
        return tableName;
    }

    private void auditDoUpdate(Context ctx, Set idSet, String tableName, int value) throws SQLDataException, BOSException {
        String sql = "update " + tableName + " set fstatusextenum = ?,FAuditorID=?,FAuditDate=? where fid = ?";
        Connection con = this.getConnection(ctx);
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearBatch();
            String[] ids = idSet.toArray(new String[idSet.size()]);
            for (int i = 0; i < ids.length; ++i) {
                ps.setInt(1, value);
                ps.setString(2, currentUser.getId().toString());
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps.setString(4, ids[i]);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)con);
        }
    }

    private void antiAuditDoUpdate(Context ctx, Set idSet, String tableName, int value) throws SQLDataException, BOSException {
        String sql = "update " + tableName + " set fstatusextenum = ?,FAuditorID=null,FAuditDate=null where fid = ?";
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearBatch();
            String[] ids = idSet.toArray(new String[idSet.size()]);
            for (int i = 0; i < ids.length; ++i) {
                ps.setInt(1, value);
                ps.setString(2, ids[i]);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)con);
        }
    }
}

