/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.BondReleasePlanInfo;
import com.kingdee.eas.fm.bond.BondReleasePlanStateEnum;
import com.kingdee.eas.fm.bond.app.AbstractBondReleasePlanControllerBean;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class BondReleasePlanControllerBean
extends AbstractBondReleasePlanControllerBean {
    private static Logger LOGGER = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.BondReleasePlanControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo info = (FinancingBillInfo)model;
        IObjectPK pk = super._addnewOther(ctx, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BondReleasePlanInfo info = (BondReleasePlanInfo)model;
        super._updateOther(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BondReleasePlanInfo info = (BondReleasePlanInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (!BondReleasePlanStateEnum.AUDIT.equals((Object)info.getStatus())) {
            info.setStatus(BondReleasePlanStateEnum.SAVE);
        }
        return super._saveOther(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BondReleasePlanInfo info = (BondReleasePlanInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (!BondReleasePlanStateEnum.AUDIT.equals((Object)info.getStatus())) {
            info.setStatus(BondReleasePlanStateEnum.SUBMIT);
        }
        IObjectPK iObjectPK = super._submitOther(ctx, model);
        this._removeBotpRelation(ctx, (IObjectValue)info);
        this._createBotpRelation(ctx, (IObjectValue)info);
        return iObjectPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleasePlanInfo info = this.getBondReleasePlanInfo(ctx, pk);
        super._deleteOther(ctx, pk);
        this._removeBotpRelation(ctx, (IObjectValue)info);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleasePlanInfo info = this.getBondReleasePlanInfo(ctx, pk);
        if (!BondReleasePlanStateEnum.SUBMIT.equals((Object)info.getStatus())) {
            throw new BondException(BondException.BONDRELEASEPLAN_ADUIT_CASE);
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        info.setStatus(BondReleasePlanStateEnum.AUDIT);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _cancelAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleasePlanInfo info = this.getBondReleasePlanInfo(ctx, pk);
        if (!BondReleasePlanStateEnum.AUDIT.equals((Object)info.getStatus()) || Constants.ZERO.compareTo(info.getRealityLoanAmount()) != 0) {
            throw new BondException(BondException.BONDRELEASEPLAN_CANCEL_ADUIT_CASE);
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        info.setStatus(BondReleasePlanStateEnum.SAVE);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        this._removeBotpRelation(ctx, (IObjectValue)info);
    }

    private void addAssureBillBotp(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        for (GuaranteeDetailInfo element : info.getGuaranteeEntrys()) {
            AssureBillInfo assBill;
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null || (assBill = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            BondReleasePlanControllerBean.addAssureBillBotp((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (String)assBill.getId().toString());
        }
    }

    private void addWageBotp(Context ctx, FinancingBillInfo info) throws EASBizException, BOSException {
        for (GuaranteeDetailInfo element : info.getGuaranteeEntrys()) {
            WageInfo wageInfo;
            if (element.getBilltype() != GuanTypeBillEnum.wage || element.getBillId() == null || (wageInfo = WageFactory.getLocalInstance((Context)ctx).getWageInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            FinUtils.addBotRelation((Context)ctx, (String)wageInfo.getId().toString(), (String)info.getId().toString());
        }
    }

    @Override
    protected void _createBotpRelation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo info = (FinancingBillInfo)model;
        this.addAssureBillBotp(ctx, info);
        this.addWageBotp(ctx, info);
    }

    @Override
    protected void _removeBotpRelation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo info = (FinancingBillInfo)model;
        if (info == null || info.getId() == null) {
            return;
        }
        Object[] paramList = new Object[]{info.getId().toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    @Override
    protected void _register(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BondReleasePlanInfo info = (BondReleasePlanInfo)model;
        info.setStatus(BondReleasePlanStateEnum.AUDIT);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _cancelRegister(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleasePlanInfo info = this.getBondReleasePlanInfo(ctx, pk);
        if (info != null) {
            info.setIsRegisted(false);
            info.setRegisterNotice(null);
            super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
    }

    @Override
    protected void _saveByAudited(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BondReleasePlanInfo info = (BondReleasePlanInfo)model;
        info.setStatus(BondReleasePlanStateEnum.AUDIT);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected boolean _isReference(Context ctx, String key) throws BOSException, EASBizException {
        String sql = "select * from T_FM_BondReleaseReport where FBondReleasePlanID=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{key});
        return rs.size() > 0;
    }
}

