/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportStateEnum;
import com.kingdee.eas.fm.bond.IntoAccountEntryCollection;
import com.kingdee.eas.fm.bond.IntoAccountEntryInfo;
import com.kingdee.eas.fm.bond.app.AbstractBondReleaseReportControllerBean;
import com.kingdee.eas.fm.bond.app.BondReleaseReportHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BondReleaseReportControllerBean
extends AbstractBondReleaseReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.BondReleaseReportControllerBean");
    private boolean isSave = false;

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        BondReleaseReportInfo info = (BondReleaseReportInfo)model;
        if (this.isSave) {
            pk = super._addnewOther(ctx, (IObjectValue)info);
        } else {
            pk = super._addnew(ctx, (IObjectValue)info);
            if (info.getRegisterNotice() != null) {
                BondReleaseReportHelper.submitDisposeRegisterNotice(ctx, info.getRegisterNotice().getId().toString());
            }
        }
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BondReleaseReportInfo info = (BondReleaseReportInfo)model;
        if (this.isSave) {
            super._updateOther(ctx, pk, (IObjectValue)info);
        } else {
            BondReleaseReportInfo oldInfo = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            String oldRegisterNoticId = null;
            if (oldInfo.getRegisterNotice() != null) {
                oldRegisterNoticId = oldInfo.getRegisterNotice().getId().toString();
            }
            super._update(ctx, pk, (IObjectValue)info);
            if (!FMHelper.isEmpty((String)oldRegisterNoticId)) {
                BondReleaseReportHelper.submitDisposeRegisterNotice(ctx, oldRegisterNoticId);
            }
            if (info.getRegisterNotice() != null) {
                BondReleaseReportHelper.submitDisposeRegisterNotice(ctx, info.getRegisterNotice().getId().toString());
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.isSave = true;
        BondReleaseReportInfo info = (BondReleaseReportInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (!BondReleaseReportStateEnum.SUBMIT.equals((Object)info.getStatus()) && !BondReleaseReportStateEnum.AUDIT.equals((Object)info.getStatus())) {
            info.setStatus(BondReleaseReportStateEnum.SAVE);
        }
        return super._saveOther(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.isSave = false;
        BondReleaseReportInfo info = (BondReleaseReportInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (!BondReleaseReportStateEnum.AUDIT.equals((Object)info.getStatus())) {
            info.setStatus(BondReleaseReportStateEnum.SUBMIT);
        }
        IObjectPK iObjectPK = super._submit(ctx, model);
        BondReleaseReportHelper.submitDisposeBondReleasePlan(ctx, info);
        this.creditLimitReduce(ctx, info);
        return iObjectPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleaseReportInfo info = this.getBondReleaseReportInfo(ctx, pk);
        BondReleaseReportHelper.deleteDisposeBondReleasePlan(ctx, info);
        BondReleaseReportHelper.deleteDisposeRegisterNotice(ctx, info);
        this.cancelCreditLimit(ctx, info);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleaseReportInfo info = this.getBondReleaseReportInfo(ctx, pk);
        if (!BondReleaseReportStateEnum.SUBMIT.equals((Object)info.getStatus())) {
            throw new BondException(BondException.BONDRELEASEPLAN_ADUIT_CASE);
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        info.setStatus(BondReleaseReportStateEnum.AUDIT);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _cancelAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BondReleaseReportInfo info = this.getBondReleaseReportInfo(ctx, pk);
        if (!BondReleaseReportStateEnum.AUDIT.equals((Object)info.getStatus())) {
            throw new BondException(BondException.BONDRELEASEPLAN_CANCEL_ADUIT_CASE);
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        info.setStatus(BondReleaseReportStateEnum.SAVE);
        super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    private void creditLimitReduce(Context ctx, BondReleaseReportInfo info) throws EASBizException, BOSException {
        HashMap<BOSUuid, BigDecimal> amountMap = new HashMap<BOSUuid, BigDecimal>();
        IntoAccountEntryCollection colls = info.getIntoAccountEntry();
        for (int i = 0; i < colls.size(); ++i) {
            IntoAccountEntryInfo entryInfo = colls.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)entryInfo.getCreditLimit())) continue;
            BOSUuid id = entryInfo.getCreditLimit().getId();
            if (amountMap.containsKey(id)) {
                BigDecimal amount = (BigDecimal)amountMap.get(id);
                amountMap.put(id, amount.add(entryInfo.getCreditLocalAmt()));
                continue;
            }
            amountMap.put(id, entryInfo.getCreditLocalAmt());
        }
        for (BOSUuid id : amountMap.keySet()) {
            BigDecimal retAmt = (BigDecimal)amountMap.get(id);
            CreditLimitManagerFactory.getLocalInstance((Context)ctx).useLimit(id, retAmt, info.getCompany().getId(), info.getId(), false);
            BondReleaseReportControllerBean.addCreditBotp((Context)ctx, (FinancingBillInfo)info, (String)id.toString());
        }
    }

    private void cancelCreditLimit(Context ctx, BondReleaseReportInfo info) throws EASBizException, BOSException {
        HashMap<BOSUuid, CreditLimitInfo> creditMap = new HashMap<BOSUuid, CreditLimitInfo>();
        IntoAccountEntryCollection colls = info.getIntoAccountEntry();
        for (int i = 0; i < colls.size(); ++i) {
            BOSUuid id;
            IntoAccountEntryInfo entryInfo = colls.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)entryInfo.getCreditLimit()) || creditMap.containsKey(id = entryInfo.getCreditLimit().getId())) continue;
            creditMap.put(id, entryInfo.getCreditLimit());
        }
        for (BOSUuid id : creditMap.keySet()) {
            CreditLimitInfo credit = (CreditLimitInfo)creditMap.get(id);
            CreditLimitManagerFactory.getLocalInstance((Context)ctx).cancelLimit(info.getId(), credit.getId());
        }
    }
}

