/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondReleasePlanFactory;
import com.kingdee.eas.fm.bond.BondReleasePlanInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.IntoAccountEntryInfo;
import com.kingdee.eas.fm.bond.RegisterNoticeFactory;
import com.kingdee.eas.fm.bond.RegisterNoticeInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;

public class BondReleaseReportHelper {
    public static void submitDisposeBondReleasePlan(Context ctx, BondReleaseReportInfo reportInfo) throws EASBizException, BOSException {
        if (reportInfo.getBondReleasePlan() != null) {
            BigDecimal sum = Constants.ZERO;
            int a = 3;
            String sql = "select sum(famount) as sum_amount from t_fm_bondreleasereport where fbondreleaseplanid =(select fbondreleaseplanid from t_fm_bondreleasereport where fid=?) and FStatus<>?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reportInfo.getId().toString(), "1"});
            try {
                if (rs.next()) {
                    sum = rs.getBigDecimal(1);
                    sum = sum == null ? Constants.ZERO : sum;
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            if (FMBillBigDecimalUtil.isGtZero((Object)sum)) {
                String sql2 = "update t_fm_bondreleaseplan set FRealityLoanAmount=? where fid = (select fbondreleaseplanid from t_fm_bondreleasereport where fid=?)";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{sum, reportInfo.getId().toString()});
            }
        }
    }

    public static void deleteDisposeBondReleasePlan(Context ctx, BondReleaseReportInfo reportInfo) throws EASBizException, BOSException {
        BondReleasePlanInfo info = reportInfo.getBondReleasePlan();
        if (info != null) {
            BondReleasePlanInfo planInfo = BondReleasePlanFactory.getLocalInstance(ctx).getBondReleasePlanInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            BigDecimal result = planInfo.getRealityLoanAmount();
            result = FMBillBigDecimalUtil.subtract((BigDecimal)result, (BigDecimal)reportInfo.getAmount());
            planInfo.setRealityLoanAmount(result);
            BondReleasePlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(planInfo.getId()), planInfo);
        }
    }

    public static void submitDisposeRegisterNotice(Context ctx, String registerNoticId) throws EASBizException, BOSException {
        BigDecimal sum = Constants.ZERO;
        String sql = "select sum(fbalance) as sum_balance from t_fm_bondreleasereport where FRegisterNoticeID=?  and FStatus<>?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{registerNoticId, "1"});
        try {
            if (rs.next()) {
                sum = rs.getBigDecimal(1);
                sum = sum == null ? Constants.ZERO : sum;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        sql = "update T_FM_RegisterNotice set FUsedAmount=? where FID=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sum, registerNoticId});
        sql = "update T_FM_RegisterNotice set FRegisterNoticeBalance=FRegisteAmount-FUsedAmount where FID=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{registerNoticId});
    }

    public static void deleteDisposeRegisterNotice(Context ctx, BondReleaseReportInfo reportInfo) throws EASBizException, BOSException {
        if (!FMHelper.isEmpty((CoreBaseInfo)reportInfo.getRegisterNotice())) {
            RegisterNoticeInfo registerInfo = RegisterNoticeFactory.getLocalInstance(ctx).getRegisterNoticeInfo((IObjectPK)new ObjectUuidPK(reportInfo.getRegisterNotice().getId()));
            BigDecimal result = registerInfo.getUsedAmount();
            result = FMBillBigDecimalUtil.subtract((BigDecimal)result, (BigDecimal)reportInfo.getBalance());
            registerInfo.setUsedAmount(result);
            result = FMBillBigDecimalUtil.subtract((BigDecimal)registerInfo.getRegisteAmount(), (BigDecimal)registerInfo.getUsedAmount());
            registerInfo.setRegisterNoticeBalance(result);
            RegisterNoticeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(registerInfo.getId()), registerInfo);
        }
    }

    public static void disposeAllCreditLimit(Context ctx, BondReleaseReportInfo reportInfo) throws BOSException {
        Iterator it = reportInfo.getIntoAccountEntry().iterator();
        while (it.hasNext()) {
            IntoAccountEntryInfo intoAccountEntryInfo = (IntoAccountEntryInfo)it.next();
            if (intoAccountEntryInfo == null || intoAccountEntryInfo.getCreditLimit() == null || intoAccountEntryInfo.getCreditLimit().getId() == null) continue;
            CreditLimitInfo creditLimitInfo = intoAccountEntryInfo.getCreditLimit();
            FinUtils.addBotRelation((Context)ctx, (String)creditLimitInfo.getId().toString(), (String)reportInfo.getId().toString());
        }
    }

    public static void removeDisposeAllCreditLimit(Context ctx, BondReleaseReportInfo reportInfo) throws BOSException {
        Iterator it = reportInfo.getIntoAccountEntry().iterator();
        while (it.hasNext()) {
            IntoAccountEntryInfo intoAccountEntryInfo = (IntoAccountEntryInfo)it.next();
            if (intoAccountEntryInfo == null || intoAccountEntryInfo.getCreditLimit() == null || intoAccountEntryInfo.getCreditLimit().getId() == null) continue;
            CreditLimitInfo creditLimitInfo = intoAccountEntryInfo.getCreditLimit();
        }
    }
}

