/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.BondInterestFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.bond.CashSettleCollection;
import com.kingdee.eas.fm.bond.CashSettleEntryInfo;
import com.kingdee.eas.fm.bond.CashSettleFactory;
import com.kingdee.eas.fm.bond.CashSettleInfo;
import com.kingdee.eas.fm.bond.CashSettleStateEnum;
import com.kingdee.eas.fm.bond.RegisterNoticeFactory;
import com.kingdee.eas.fm.bond.RegisterNoticeInfo;
import com.kingdee.eas.fm.bond.app.AbstractCashSettleControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.ctl.AssureBillManagerFacadeFactory;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryFactory;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashSettleControllerBean
extends AbstractCashSettleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.CashSettleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CashSettleInfo info = (CashSettleInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        CashSettleCollection coll = CashSettleFactory.getLocalInstance(ctx).getCashSettleCollection(view);
        info.setCashSeq(coll.size() + 1);
        info.setState(CashSettleStateEnum.SUBMIT);
        IObjectPK PK = super._addnew(ctx, model);
        this.dispose(ctx, info, true);
        this.returnQuota(ctx, info, true);
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).returnAssure(info.getId());
        return PK;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = this.getCashSettleSelectors();
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        view.setSorter(sorterColl);
        SorterItemInfo sorter = new SorterItemInfo("cashSeq");
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        CashSettleInfo info = (CashSettleInfo)this.getValue(ctx, pk, sic);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId()));
        CashSettleCollection coll = CashSettleFactory.getLocalInstance(ctx).getCashSettleCollection(view);
        if (!info.getId().equals((Object)coll.get(0).getId())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"1_CashSettleControllerBean", (Locale)ctx.getLocale())});
        }
        if (!info.getState().equals((Object)CashSettleStateEnum.SUBMIT)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"2_CashSettleControllerBean", (Locale)ctx.getLocale())});
        }
        BondInterestFactory.getLocalInstance(ctx).deleteRaleted((IObjectPK)new ObjectUuidPK(info.getId()));
        this.dispose(ctx, info, false);
        this.returnQuota(ctx, info, false);
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelReturnAssure(info.getId());
        super._delete(ctx, pk);
    }

    private SelectorItemCollection getCashSettleSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("entrys"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.underRate"));
        sic.add(new SelectorItemInfo("entrys.repayAmt"));
        sic.add(new SelectorItemInfo("entrys.creditLimit.*"));
        sic.add(new SelectorItemInfo("entrys.creditCurrency.name"));
        sic.add(new SelectorItemInfo("entrys.creditCurrency.precision"));
        sic.add(new SelectorItemInfo("entrys.creditCurRate"));
        sic.add(new SelectorItemInfo("entrys.returnQuota"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CashSettleInfo oldInfo;
        CashSettleInfo info = (CashSettleInfo)model;
        if (info != null && info.getId() != null && CashSettleFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = CashSettleFactory.getLocalInstance(ctx).getCashSettleInfo((IObjectPK)new ObjectUuidPK(info.getId()))) != null && CashSettleStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BondException(BondException.STATUS_CHANGE_CANNOT_PROCESS);
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CashSettleInfo oldInfo;
        CashSettleInfo info = (CashSettleInfo)model;
        if (info != null && info.getId() != null && CashSettleFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = CashSettleFactory.getLocalInstance(ctx).getCashSettleInfo((IObjectPK)new ObjectUuidPK(info.getId()))) != null && CashSettleStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BondException(BondException.STATUS_CHANGE_CANNOT_PROCESS);
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BondException(BondException.NUMBER_NOT_EMPTY);
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._save(ctx, model);
    }

    private void dispose(Context ctx, CashSettleInfo info, boolean isAddNew) throws EASBizException, BOSException {
        String srcid = info.getSourceBillId();
        if (FMHelper.isEmpty((String)srcid)) {
            return;
        }
        SelectorItemCollection sic = this.getSelectors_BondReleaseReport();
        BondReleaseReportInfo reportInfo = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(srcid), sic);
        BigDecimal reportBalance = reportInfo.getBalance();
        reportBalance = isAddNew ? FMBillBigDecimalUtil.subtract((BigDecimal)reportInfo.getBalance(), (BigDecimal)info.getAmount()) : FMBillBigDecimalUtil.add((BigDecimal)reportInfo.getBalance(), (BigDecimal)info.getAmount());
        String sSQL = "Update T_FM_BondReleaseReport set FBalance = ? where Fid = ?";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{reportBalance, srcid});
        RegisterNoticeInfo registerNoticeInfo = reportInfo.getRegisterNotice();
        if (!FMHelper.isEmpty((CoreBaseInfo)registerNoticeInfo)) {
            if (isAddNew) {
                registerNoticeInfo.setUsedAmount(registerNoticeInfo.getUsedAmount().subtract(info.getAmount()));
            } else {
                registerNoticeInfo.setUsedAmount(registerNoticeInfo.getUsedAmount().add(info.getAmount()));
            }
            registerNoticeInfo.setRegisterNoticeBalance(registerNoticeInfo.getRegisteAmount().subtract(registerNoticeInfo.getUsedAmount()));
            RegisterNoticeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(registerNoticeInfo.getId()), registerNoticeInfo);
        }
    }

    private SelectorItemCollection getSelectors_BondReleaseReport() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CreditLimit"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage"));
        sic.add(new SelectorItemInfo("UsedQuota"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.billId"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.exchangeRate"));
        sic.add(new SelectorItemInfo("registerNotice.id"));
        sic.add(new SelectorItemInfo("registerNotice.usedAmount"));
        sic.add(new SelectorItemInfo("registerNotice.registerNoticeBalance"));
        sic.add(new SelectorItemInfo("registerNotice.registeAmount"));
        sic.add(new SelectorItemInfo("registerNotice.registerNoticeBalance"));
        sic.add(new SelectorItemInfo("intoAccountEntry.underwriteName.id"));
        sic.add(new SelectorItemInfo("intoAccountEntry.creditLimit.Balance"));
        return sic;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        CashSettleCollection colls = CashSettleFactory.getLocalInstance(ctx).getCashSettleCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            CashSettleInfo info = colls.get(i);
            if (!info.getState().equals((Object)CashSettleStateEnum.SUBMIT)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"3_CashSettleControllerBean", (Locale)ctx.getLocale())});
            }
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setAuditor(userInfo);
            info.setAuditDate(BondUtil.getNowDate());
            info.setState(CashSettleStateEnum.AUDIT);
            CashSettleFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        CashSettleCollection colls = CashSettleFactory.getLocalInstance(ctx).getCashSettleCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            CashSettleInfo info = colls.get(i);
            if (!info.getState().equals((Object)CashSettleStateEnum.AUDIT)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"4_CashSettleControllerBean", (Locale)ctx.getLocale())});
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            info.setState(CashSettleStateEnum.SUBMIT);
            CashSettleFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
    }

    private void returnQuota(Context ctx, CashSettleInfo info, boolean isRepay) throws EASBizException, BOSException {
        HashMap<BOSUuid, BigDecimal> returnMap = new HashMap<BOSUuid, BigDecimal>();
        HashMap<BOSUuid, CreditLimitInfo> creditMap = new HashMap<BOSUuid, CreditLimitInfo>();
        HashMap<BOSUuid, BigDecimal> creditRateMap = new HashMap<BOSUuid, BigDecimal>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            CashSettleEntryInfo detailInfo = info.getEntrys().get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)detailInfo.getCreditLimit()) || detailInfo.getCreditLimit().getProperty().equals((Object)LimitPropertyEnum.FIXED_AMOUNT)) continue;
            BOSUuid creditLimitId = detailInfo.getCreditLimit().getId();
            if (returnMap.containsKey(creditLimitId)) {
                BigDecimal returnedQuota = (BigDecimal)returnMap.get(creditLimitId);
                returnMap.put(creditLimitId, returnedQuota.add(detailInfo.getReturnQuota()));
                continue;
            }
            returnMap.put(creditLimitId, detailInfo.getReturnQuota());
            creditMap.put(creditLimitId, detailInfo.getCreditLimit());
            creditRateMap.put(creditLimitId, detailInfo.getCreditCurRate());
        }
        SelectorItemCollection sic = this.getSelectors_BondReleaseReport();
        BondReleaseReportInfo reportInfo = BondReleaseReportFactory.getLocalInstance(ctx).getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
        for (BOSUuid creditLimitId : returnMap.keySet()) {
            BigDecimal UserreturnedQuota = (BigDecimal)returnMap.get(creditLimitId);
            CreditLimitUsedInfo userInfo = null;
            EntityViewInfo viewUsed = new EntityViewInfo();
            FilterInfo filterUsed = new FilterInfo();
            viewUsed.setFilter(filterUsed);
            filterUsed.getFilterItems().add(new FilterItemInfo("BillId", (Object)reportInfo.getId().toString()));
            filterUsed.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
            viewUsed.getSelector().add(new SelectorItemInfo("id"));
            viewUsed.getSelector().add(new SelectorItemInfo("BillId"));
            viewUsed.getSelector().add(new SelectorItemInfo("UsedQuota"));
            viewUsed.getSelector().add(new SelectorItemInfo("ReturnedQuota"));
            CreditLimitUsedCollection coll = CreditLimitUsedFactory.getLocalInstance((Context)ctx).getCreditLimitUsedCollection(viewUsed);
            if (coll.size() > 0) {
                userInfo = coll.get(0);
            }
            BigDecimal relReturnedQuota = isRepay ? UserreturnedQuota : UserreturnedQuota.negate();
            CreditLimitInfo creditLimitInfo = (CreditLimitInfo)creditMap.get(creditLimitId);
            CashSettleControllerBean.checkCreditLimitAmount(relReturnedQuota, creditLimitInfo);
            BigDecimal balance = creditLimitInfo.getBalance().subtract(relReturnedQuota.negate());
            creditLimitInfo.setBalance(balance);
            BigDecimal UsedAmount = creditLimitInfo.getQuotaAmount().subtract(creditLimitInfo.getBalance());
            creditLimitInfo.setUsedAmount(UsedAmount);
            CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus((Context)ctx, (String)creditLimitInfo.getId().toString());
            creditLimitInfo.setCreditLimitStat(creditStatus);
            CreditLimitFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), (CoreBaseInfo)creditLimitInfo);
            CreditLimitEntryInfo shareEntry = this.getOrgEntry(ctx, creditLimitInfo, info.getCompany().getId());
            if (!FMHelper.isEmpty((CoreBaseInfo)shareEntry)) {
                BigDecimal entryBalance = shareEntry.getBanlance().subtract(relReturnedQuota.negate());
                shareEntry.setBanlance(entryBalance);
                CreditLimitEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(shareEntry.getId()), (CoreBaseInfo)shareEntry);
            }
            if (creditLimitInfo == null || !creditLimitInfo.getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT) || FMHelper.isEmpty((CoreBaseInfo)userInfo)) continue;
            userInfo.setReturnedQuota(userInfo.getReturnedQuota().add(relReturnedQuota));
            if (userInfo.getReturnedQuota().compareTo(userInfo.getUsedQuota()) > 0) {
                userInfo.setReturnedQuota(userInfo.getUsedQuota());
            }
            ObjectUuidPK pk = new ObjectUuidPK(userInfo.getId());
            CreditLimitUsedFactory.getLocalInstance((Context)ctx).update((IObjectPK)pk, (CoreBaseInfo)userInfo);
        }
    }

    public static void checkCreditLimitAmount(BigDecimal amount, CreditLimitInfo creditLimitInfo) throws EASBizException {
        BigDecimal banlance = creditLimitInfo.getBalance();
        BigDecimal totalAmount = creditLimitInfo.getQuotaAmount();
        if (banlance.compareTo(Constants.ZERO) < 0 || totalAmount.compareTo(amount.add(banlance)) < 0) {
            FinUtils.throwFMCommonException((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"446_FinUtils") + totalAmount.subtract(banlance)));
        }
    }

    public CreditLimitEntryInfo getOrgEntry(Context ctx, CreditLimitInfo creditLimit, BOSUuid companyId) throws BOSException {
        CreditLimitEntryInfo entryInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId()));
        CreditLimitEntryCollection cleCollection = CreditLimitEntryFactory.getLocalInstance((Context)ctx).getCreditLimitEntryCollection(evi);
        int n = cleCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!cleCollection.get(i).getShareOrg().getId().equals((Object)companyId)) continue;
            entryInfo = cleCollection.get(i);
        }
        return entryInfo;
    }
}

