/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondInterestInfo;
import com.kingdee.eas.fm.bond.app.AbstractIntReverseInBondFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class IntReverseInBondFacadeControllerBean
extends AbstractIntReverseInBondFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.IntReverseInBondFacadeControllerBean");

    @Override
    protected void _reverseAfterPreInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        this.updateLastIntDate(ctx, bondInterestInfo);
    }

    private void updateLastIntDate(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException {
        String sql = "update T_FM_BondReleaseReport set FLastPreIntDate = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getEndDate(), bondInterestInfo.getBondReleaseReport().getId().toString()});
    }

    @Override
    protected void _reverseAfterRecInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        this.updateLastSettleDate(ctx, bondInterestInfo);
    }

    private void updateLastSettleDate(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException {
        if (bondInterestInfo.getEndDate() == null) {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getBondReleaseReport().getId().toString()});
        } else {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getEndDate(), bondInterestInfo.getBondReleaseReport().getId().toString()});
        }
    }

    @Override
    protected void _reverseAfterDelete(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        int type = bondInterestInfo.getInterestType().getValue();
        if (type == 0) {
            this.casePreInt(ctx, bondInterestInfo);
        } else if (type == 4) {
            this.caseRecInt(ctx, bondInterestInfo);
        } else if (type == 2) {
            this.caseRepayInt(ctx, bondInterestInfo);
        } else {
            this.caseHexiaoInt(ctx, bondInterestInfo);
        }
    }

    private void casePreInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        if (bondInterestInfo.getLastIntDate() == null) {
            String sql = "update T_FM_BondReleaseReport set FLastPreIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getBondReleaseReport().getId().toString()});
        } else {
            String sql = "update T_FM_BondReleaseReport set FLastPreIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getLastIntDate(), bondInterestInfo.getBondReleaseReport().getId().toString()});
        }
    }

    private void caseRecInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        if (bondInterestInfo.getLastIntDate() == null) {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getBondReleaseReport().getId().toString()});
        } else {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getLastIntDate(), bondInterestInfo.getBondReleaseReport().getId().toString()});
        }
    }

    private void caseRepayInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
        if (bondInterestInfo.getLastIntDate() == null) {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getBondReleaseReport().getId().toString()});
        } else {
            String sql = "update T_FM_BondReleaseReport set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bondInterestInfo.getLastIntDate(), bondInterestInfo.getBondReleaseReport().getId().toString()});
        }
    }

    private void caseHexiaoInt(Context ctx, BondInterestInfo bondInterestInfo) throws BOSException, EASBizException {
    }
}

