/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.bond.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.bond.BondException;
import com.kingdee.eas.fm.bond.RegisterNoticeFactory;
import com.kingdee.eas.fm.bond.RegisterNoticeInfo;
import com.kingdee.eas.fm.bond.RegisterNoticeStateEnum;
import com.kingdee.eas.fm.bond.app.AbstractRegisterNoticeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RegisterNoticeControllerBean
extends AbstractRegisterNoticeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.bond.app.RegisterNoticeControllerBean");

    @Override
    protected void _submit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)this.getValue(ctx, key));
        this.updateUsedStatus(ctx, RegisterNoticeStateEnum.SUBMIT, key.toString());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
        this.updateUsedStatus(ctx, RegisterNoticeStateEnum.AUDIT, key.toString());
    }

    @Override
    protected void _cancelAudit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
        this.checkCancelAudit(ctx, key);
        this.updateUsedStatus(ctx, RegisterNoticeStateEnum.SAVE, key.toString());
    }

    private void checkCancelAudit(Context ctx, IObjectPK key) throws BOSException, EASBizException {
        RegisterNoticeInfo info = RegisterNoticeFactory.getLocalInstance(ctx).getRegisterNoticeInfo((IObjectPK)new ObjectUuidPK(key.toString()));
        if (!info.getState().equals((Object)RegisterNoticeStateEnum.AUDIT)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"5_RegisterNoticeControllerBean", (Locale)ctx.getLocale())});
        }
        if (RegisterNoticeFactory.getLocalInstance(ctx).isReference(key.toString())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.bond.BONDAutoGenerateResource", (String)"5_RegisterNoticeControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super.tempAddnew(ctx, model);
    }

    private void updateUsedStatus(Context ctx, RegisterNoticeStateEnum state, String pk) throws BOSException {
        Object[] paramList = new Object[]{state.getValue(), pk};
        String sql = "update T_FM_RegisterNotice set fstate=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RegisterNoticeInfo info = (RegisterNoticeInfo)this.getValue(ctx, pk);
        if (RegisterNoticeStateEnum.AUDIT.equals((Object)info.getState())) {
            throw new BondException(BondException.AUDIT_NOT_DELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _isReference(Context ctx, String key) throws BOSException, EASBizException {
        String sql = "select * from T_FM_BondReleasePlan where FRegisterNoticeID=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{key});
        if (rs.size() > 0) {
            return true;
        }
        sql = "select * from T_FM_BondReleaseReport where FRegisterNoticeID=?";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{key});
        return rs.size() > 0;
    }
}

