/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.cbs.CBPaymentException;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cbs.MessageToBankEnum;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.cbs.app.AbstractCBAgentPayBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CBAgentPayBillWebFacadeControllerBean
extends AbstractCBAgentPayBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cbs.app.CBAgentPayBillWebFacadeControllerBean");

    protected void verifyBeforeSubmit(Context ctx, AgentPayBillInfo info) throws Exception {
        super.verifyBeforeSubmit(ctx, info);
        if (info.getPayBankAccount() == null) {
            throw new CBPaymentException(CBPaymentException.PAYERACCOUNTBANK_REQUIRED);
        }
        if (info.getPayerAccount() == null) {
            throw new CBPaymentException(CBPaymentException.PAYERACCOUNT_REQUIRED);
        }
        if (info.getUsage() == null) {
            throw new CBPaymentException(CBPaymentException.USAGE_REQUIRED);
        }
        CBPaymentInfo cbPayInfo = info.getCbPayInfo();
        if (cbPayInfo.getPayeeCurrency() == null) {
            throw new CBPaymentException(CBPaymentException.PAYEECURRENCY_REQUIRED);
        }
        if (cbPayInfo.isIsByAgentBank()) {
            if (cbPayInfo.getAgentAcctBank() == null) {
                throw new CBPaymentException(CBPaymentException.AGENTACCTBANK_REQUIRED);
            }
            String agentSwift = cbPayInfo.getAgentSwift();
            if (agentSwift == null || agentSwift == "" || agentSwift.length() != 8 && agentSwift.length() != 11) {
                throw new CBPaymentException(CBPaymentException.AGENTSWTIFTCODE_REQUIRED);
            }
            if (cbPayInfo.getAgentCountry() == null) {
                throw new CBPaymentException(CBPaymentException.AGENTCOUNTRY_REQUIRED);
            }
        }
    }

    protected IObjectPK getSavePk(Context ctx, IAgentPayBill iAgentPayBill, AgentPayBillInfo info) throws Exception {
        CBPaymentInfo cbInfo = info.getCbPayInfo();
        cbInfo.setPaymentBillId(info.getId().toString());
        CBPaymentFactory.getLocalInstance(ctx).save((CoreBaseInfo)cbInfo);
        return super.getSavePk(ctx, iAgentPayBill, info);
    }

    protected IObjectPK getSubmitPk(Context ctx, IAgentPayBill iAgentPayBill, AgentPayBillInfo info) throws Exception {
        CBPaymentInfo cbInfo = info.getCbPayInfo();
        cbInfo.setPaymentBillId(info.getId().toString());
        CBPaymentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cbInfo);
        return super.getSubmitPk(ctx, iAgentPayBill, info);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = super.getSelector();
        selector.add("isCBPay");
        selector.add("cbPayInfo.id");
        selector.add("cbPayInfo.payeeCurrency.id");
        selector.add("cbPayInfo.isByAgentBank");
        selector.add("cbPayInfo.agentSwift");
        selector.add("cbPayInfo.agentAcctBank");
        selector.add("cbPayInfo.agentCountry.id");
        selector.add("cbPayInfo.agentCountry.ISOCode");
        selector.add(new SelectorItemInfo("entrys.payeeBankAddr"));
        selector.add(new SelectorItemInfo("entrys.payeeSwiftCode"));
        selector.add(new SelectorItemInfo("entrys.payeeCountry.id"));
        selector.add(new SelectorItemInfo("entrys.payeeCountry.name"));
        selector.add(new SelectorItemInfo("entrys.payeeCountry.ISOCode"));
        selector.add(new SelectorItemInfo("entrys.payeeBankBranch"));
        selector.add(new SelectorItemInfo("entrys.payeeBankNumber"));
        return selector;
    }

    @Override
    protected IObjectValue _setCBPayInfo4BOTP(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        AgentPayBillInfo agentInfo = (AgentPayBillInfo)info;
        CBPaymentInfo cbInfo = new CBPaymentInfo();
        if (agentInfo.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(agentInfo.getCurrency().getId()));
            cbInfo.setPaymentCurrency(currency);
            cbInfo.setPayeeCurrency(currency);
        }
        cbInfo.setIsFeeByPayAmount(true);
        cbInfo.setTransactionType(TransTypeEnum.TTF);
        cbInfo.setMessageToBank(MessageToBankEnum.Single);
        cbInfo.setFeeAccountBank(agentInfo.getPayBankAccount());
        cbInfo.setPaymentBillId(agentInfo.getId().toString());
        cbInfo.setPayeeAmount(agentInfo.getAmount());
        cbInfo.setFeeCurrency(agentInfo.getCurrency());
        agentInfo.setCbPayInfo(cbInfo);
        return cbInfo;
    }

    protected Map _batchUnaudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchUnaudit(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchSubmit(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchAudit(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchPay(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchPay(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCancelPay(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCancelPay(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchDelete(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCommitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCommitToBe(ctx, ids);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchAudit4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchAudit4Ca(ctx, ids, signature);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchSubmit4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchSubmit4Ca(ctx, ids, signature);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchCommitToBe4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchCommitToBe4Ca(ctx, ids, signature);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    protected Map _batchPay4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)super._batchPay4Ca(ctx, ids, signature);
        result = this.replacePaymentMsg(ctx, result);
        return result;
    }

    private BatchExecuteResult replacePaymentMsg(Context ctx, BatchExecuteResult result) {
        if (result.getDetailMsgList().size() > 0) {
            BatchExecuteResult cbResult = new BatchExecuteResult();
            cbResult.setSummaryMsg(result.getSummaryMsg());
            List detailMsgList = result.getDetailMsgList();
            for (int i = 0; i < detailMsgList.size(); ++i) {
                String msg = (String)detailMsgList.get(i);
                if (msg.indexOf(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"AgentPaymentBill")) != -1) {
                    msg = msg.replaceAll(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"AgentPaymentBill"), CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.cbs.CbsWebResource", (String)"CBAgentPaymentBill"));
                }
                cbResult.getDetailMsgList().add(msg);
            }
            return cbResult;
        }
        return result;
    }
}

