/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.VerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountApplyBillFactory;
import com.kingdee.eas.basedata.assistant.AccountApplyBillInfo;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountApplyBillControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class AccountApplyBillControllerBean
extends AbstractAccountApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AccountApplyBillControllerBean");

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue objectValue) throws EASBizException, BOSException {
        AccountApplyBillInfo billInfo = (AccountApplyBillInfo)objectValue;
        billInfo.setBillState(BillStateEnum.SUBMITTED);
        super._submit(ctx, pk, (IObjectValue)billInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        AccountApplyBillInfo info;
        AccountApplyBillInfo billInfo = (AccountApplyBillInfo)objectValue;
        if (!EmptyUtil.isEmpty((Object)billInfo.getId()) && (info = this.getAccountApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()))).getBillState() == BillStateEnum.AUDITED) {
            throw new FMException(FMException.EDITERROR);
        }
        billInfo.setBillState(BillStateEnum.SUBMITTED);
        IObjectPK pk = super._submit(ctx, (IObjectValue)billInfo);
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
        return pk;
    }

    @Override
    protected boolean _antiAudit(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null) {
            logger.error((Object)"AccountApplyBillControllerBean/billID is null");
            return false;
        }
        if (FMHelper.hasWFInstance(ctx, billID)) {
            throw new FMException(FMException.ERROR_IN_WORKFLOW);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        AccountApplyBillInfo accountApplyBill = AccountApplyBillFactory.getLocalInstance(ctx).getAccountApplyBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        if (BillStateEnum.AUDITED != accountApplyBill.getBillState()) {
            throw new FMException(FMException.SELECT_AUDIT_BILL);
        }
        try {
            AccountApplyBillInfo info = new AccountApplyBillInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.SAVED);
            info.setAuditor(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("auditor"));
            AccountApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            this.antiAudit4WF(ctx, billID);
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)("AccountApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)("AccountApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
    }

    @Override
    protected boolean _audit(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null) {
            logger.error((Object)"AccountApplyBillControllerBean/billID is null");
            return false;
        }
        if (FMHelper.hasWFInstance(ctx, billID)) {
            throw new FMException(FMException.ERROR_IN_WORKFLOW);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billState"));
        AccountApplyBillInfo accountApplyBill = AccountApplyBillFactory.getLocalInstance(ctx).getAccountApplyBillInfo((IObjectPK)new ObjectUuidPK(billID), sic);
        if (BillStateEnum.SUBMITTED != accountApplyBill.getBillState()) {
            throw new FMException(FMException.SELECT_SUBMITED_BILL);
        }
        this.audit4WF(ctx, billID);
        return true;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountApplyBillInfo billInfo = (AccountApplyBillInfo)model;
        if (EmptyUtil.isEmpty((String)billInfo.getNumber())) {
            String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)billInfo, (String)billInfo.getCompany().getId().toString());
            billInfo.setNumber(numberSilent);
        }
        VerifyHelper.checkBlank((Context)ctx, (IObjectValue)billInfo, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountApplyBillInfo info = this.getAccountApplyBillInfo(ctx, pk);
        if (info.getBillState() == BillStateEnum.AUDITED) {
            throw new FMException(FMException.AUDITDELETE);
        }
        if (info.getBillState() == BillStateEnum.DUMPED) {
            throw new FMException(FMException.DUMPDELETE);
        }
        super._delete(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountApplyBillInfo info;
        AccountApplyBillInfo billInfo = (AccountApplyBillInfo)model;
        if (!EmptyUtil.isEmpty((Object)billInfo.getId()) && (info = this.getAccountApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()))).getBillState() == BillStateEnum.AUDITED) {
            throw new FMException(FMException.EDITERROR);
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, String billID) throws BOSException, EASBizException {
        AccountApplyBillInfo info = AccountApplyBillFactory.getLocalInstance(ctx).getAccountApplyBillInfo("select billState where id = '" + billID + "'");
        if (BillStateEnum.AUDITED.equals((Object)info.getBillState())) {
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.SAVED);
            info.setAuditor(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("auditor"));
            AccountApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, String billID) throws BOSException, EASBizException {
        try {
            AccountApplyBillInfo info = new AccountApplyBillInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.AUDITED);
            info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("auditor"));
            AccountApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        }
        catch (EASBizException e) {
            logger.error((Object)("AccountApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            logger.error((Object)("AccountApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
    }
}

