/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AbstractFuncInfo;
import com.kingdee.eas.fm.common.BOTPBaseFunctions;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import org.apache.log4j.Logger;

public class FMBotpFormulaFunctions
extends BOTPBaseFunctions {
    private static final Logger logger = CoreUIObject.getLogger(FMBotpFormulaFunctions.class);

    public FMBotpFormulaFunctions() {
        BOTGetAsstActType funcInfo1 = new BOTGetAsstActType();
        this.funcInfos.put(funcInfo1.getFuncName(), funcInfo1);
        BOTGetEntrysCount funcInfo2 = new BOTGetEntrysCount();
        this.funcInfos.put(funcInfo2.getFuncName(), funcInfo2);
        BOTGetDefaultPaymentAccount funcInfo3 = new BOTGetDefaultPaymentAccount();
        this.funcInfos.put(funcInfo3.getFuncName(), funcInfo3);
        BOTGetDefaultPayAcctByCurrency funcInfo4 = new BOTGetDefaultPayAcctByCurrency();
        this.funcInfos.put(funcInfo4.getFuncName(), funcInfo4);
    }

    private final class BOTGetDefaultPayAcctByCurrency
    extends AbstractFuncInfo {
        private BOTGetDefaultPayAcctByCurrency() {
            super("__BOTGetDefaultPayAcctByCurrency", AbstractFuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"176_BOTGetDefaultPayAcctByCurrency"));
        }

        @Override
        public Object evalFunction(List args) throws KScriptException {
            Context ctx = this.getContext(args);
            Object company = args.get(1);
            Object currency = args.get(2);
            if (company == null || currency == null) {
                return null;
            }
            AccountBankInfo bankInfo = null;
            if (company instanceof CompanyOrgUnitInfo && currency instanceof CurrencyInfo) {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)company;
                CurrencyInfo currencyInfo = (CurrencyInfo)currency;
                bankInfo = this.getDefaultPayAcctByCurrency(ctx, companyInfo.getId().toString(), currencyInfo.getId().toString());
            }
            return bankInfo;
        }

        private AccountBankInfo getDefaultPayAcctByCurrency(Context ctx, String companyId, String currencyId) {
            EntityViewInfo bankViewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("account.id"));
            selector.add(new SelectorItemInfo("account.name"));
            selector.add(new SelectorItemInfo("account.number"));
            selector.add(new SelectorItemInfo("currency.id"));
            SorterItemCollection bankSortColl = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            bankSortColl.add(sort);
            FilterInfo bankFilter = new FilterInfo();
            bankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            bankFilter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)1));
            bankViewInfo.setFilter(bankFilter);
            bankViewInfo.setSorter(bankSortColl);
            bankViewInfo.setSelector(selector);
            try {
                AccountBankCollection acountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(bankViewInfo);
                if (acountBankColl != null && acountBankColl.size() > 0) {
                    for (int i = 0; i < acountBankColl.size(); ++i) {
                        AccountBankInfo bankInfo = acountBankColl.get(i);
                        if (bankInfo.getCurrency() != null && !currencyId.equals(bankInfo.getCurrency().getId().toString())) continue;
                        return bankInfo;
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private final class BOTGetDefaultPaymentAccount
    extends AbstractFuncInfo {
        private BOTGetDefaultPaymentAccount() {
            super("__BOTGetDefaultPaymentAccount", AbstractFuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"175_BOTGetDefaultPaymentAccount"));
        }

        @Override
        public Object evalFunction(List args) throws KScriptException {
            Context ctx = this.getContext(args);
            Object obj = args.get(1);
            if (obj == null) {
                return null;
            }
            AccountBankInfo bankInfo = null;
            if (obj instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)obj;
                bankInfo = this.getDefaultPayAccount(ctx, companyInfo.getId().toString());
            }
            return bankInfo;
        }

        private AccountBankInfo getDefaultPayAccount(Context ctx, String companyId) {
            AccountBankInfo bankInfo = null;
            EntityViewInfo bankViewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("account.id"));
            selector.add(new SelectorItemInfo("account.name"));
            selector.add(new SelectorItemInfo("account.number"));
            SorterItemCollection bankSortColl = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            bankSortColl.add(sort);
            FilterInfo bankFilter = new FilterInfo();
            bankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            bankFilter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)1));
            bankViewInfo.setFilter(bankFilter);
            bankViewInfo.setSorter(bankSortColl);
            bankViewInfo.setSelector(selector);
            try {
                AccountBankCollection acountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(bankViewInfo);
                if (acountBankColl.size() > 0) {
                    bankInfo = acountBankColl.get(0);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return bankInfo;
        }
    }

    private final class BOTGetEntrysCount
    extends AbstractFuncInfo {
        private BOTGetEntrysCount() {
            super("__BOTGetEntrysCount", AbstractFuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"76_FMBotpFormulaFunctions"));
        }

        @Override
        public Object evalFunction(List args) throws KScriptException {
            Object obj = args.get(1);
            if (obj == null) {
                return null;
            }
            if (obj instanceof EndorsementBillInfo) {
                return new Integer(((EndorsementBillInfo)obj).getReceivableEntrys().size());
            }
            return new Integer(1);
        }
    }

    private final class BOTGetAsstActType
    extends AbstractFuncInfo {
        private BOTGetAsstActType() {
            super("__BOTGetAsstActType", AbstractFuncInfo.CATEGORY_MATH, EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_FMBotpFormulaFunctions"));
        }

        @Override
        public Object evalFunction(List args) throws KScriptException {
            Context ctx = this.getContext(args);
            Object obj = args.get(1);
            if (obj == null) {
                return null;
            }
            AsstActTypeInfo asstActType = null;
            if (obj instanceof BOSUuid) {
                asstActType = this.getAsstActType(ctx, (BOSUuid)obj);
            }
            return asstActType;
        }

        private AsstActTypeInfo getAsstActType(Context ctx, BOSUuid bosid) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = loader.getEntity(bosid.getType());
            String tableName = bo.getTable().getName();
            if (tableName != null && tableName.equals("T_ORG_BaseUnit")) {
                tableName = "T_ORG_Company";
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)tableName));
            view.setFilter(filterInfo);
            try {
                AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
                if (coll.size() > 0) {
                    return coll.get(0);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

