/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FMPeriodUtils
extends PeriodUtils {
    public static PeriodInfo getPeriodInfo(Context ctx, Date date, String periodTypeId) throws BOSException, EASBizException {
        PeriodInfo periodInfo = new PeriodInfo();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        IPeriod iPeriod = FMPeriodUtils.getInterface(ctx);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, String periodTypeId) throws BOSException, EASBizException {
        PeriodInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        IPeriod iPeriod = FMPeriodUtils.getInterface(ctx);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, Date dateFrom, Date dateTo, String periodTypeId) throws BOSException, EASBizException {
        PeriodInfo PeriodTo;
        PeriodInfo PeriodFrom;
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        IPeriod iPeriod = FMPeriodUtils.getInterface(ctx);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (PeriodFrom = FMPeriodUtils.getPeriodInfo(null, dateFrom, periodTypeId)).equals((Object)(PeriodTo = FMPeriodUtils.getPeriodInfo(null, dateTo, periodTypeId)))) {
            periodc.add(PeriodTo);
        }
        return periodc;
    }

    private static IPeriod getInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return PeriodFactory.getRemoteInstance();
        }
        return PeriodFactory.getLocalInstance((Context)ctx);
    }

    public static Map getPeriodColl(Context ctx, Date date, Set companyIdSet) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitCollection companyColl = FMPeriodUtils.getCompanyColl(ctx, companyIdSet);
        CompanyOrgUnitInfo companyInfo = null;
        HashSet<String> periodTypeIdSet = new HashSet<String>();
        String periodTypeId = null;
        int size = companyColl.size();
        for (int i = 0; i < size; ++i) {
            companyInfo = companyColl.get(i);
            map.put(companyInfo.getId().toString(), null);
            if (companyInfo.getAccountPeriodType() == null) continue;
            periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            periodTypeIdSet.add(periodTypeId);
            map.put(companyInfo.getId().toString(), periodTypeId);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", periodTypeIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        PeriodInfo periodInfo = null;
        HashMap retMap = new HashMap();
        int size2 = periodColl.size();
        for (int i = 0; i < size2; ++i) {
            periodInfo = periodColl.get(i);
            for (Map.Entry entry : map.entrySet()) {
                if (!periodInfo.getPeriodType().getId().toString().equals((String)entry.getValue()) || retMap.containsKey(entry.getKey())) continue;
                retMap.put(entry.getKey(), periodInfo);
            }
        }
        return retMap;
    }

    public static Map getPeriodColl(Context ctx, int periodYear, int periodNumber, Set companyIdSet) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitCollection companyColl = FMPeriodUtils.getCompanyColl(ctx, companyIdSet);
        CompanyOrgUnitInfo companyInfo = null;
        HashSet<String> periodTypeIdSet = new HashSet<String>();
        String periodTypeId = null;
        int size = companyColl.size();
        for (int i = 0; i < size; ++i) {
            companyInfo = companyColl.get(i);
            map.put(companyInfo.getId().toString(), null);
            if (companyInfo.getAccountPeriodType() == null) continue;
            periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            periodTypeIdSet.add(periodTypeId);
            map.put(companyInfo.getId().toString(), periodTypeId);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber)));
        filter.getFilterItems().add(new FilterItemInfo("periodType", periodTypeIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        PeriodInfo periodInfo = null;
        HashMap retMap = new HashMap();
        int size2 = periodColl.size();
        for (int i = 0; i < size2; ++i) {
            periodInfo = periodColl.get(i);
            for (Map.Entry entry : map.entrySet()) {
                if (!periodInfo.getPeriodType().getId().toString().equals((String)entry.getValue())) continue;
                retMap.put(entry.getKey(), periodInfo);
            }
        }
        return retMap;
    }

    private static CompanyOrgUnitCollection getCompanyColl(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
    }
}

