/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Arrays;

public final class FMVerifyHelper {
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.common.COMMONAutoGenerateResource";

    public static void checkNumberEmpty(DataBaseInfo info) throws EASBizException {
        if (FMHelper.isEmpty(info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[0]);
        }
    }

    public static void checkNumberEmpty(BillBaseInfo info) throws EASBizException {
        if (FMHelper.isEmpty(info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[0]);
        }
    }

    public static void checkBlank(Object o1, Object[] args) throws EASBizException {
        if (o1 == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
        if (o1 instanceof String && o1.toString().trim().length() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(Context ctx, IObjectValue vo, String name) throws EASBizException {
        Object val = vo.get(name);
        if (val == null) {
            FMVerifyHelper.checkMsg(ctx, vo, name, val);
        } else if (val instanceof String && val.toString().trim().length() == 0) {
            FMVerifyHelper.checkMsg(ctx, vo, name, (String)val);
        }
    }

    public static void checkMustMoreThanZero(Context ctx, IObjectValue vo, String name) throws EASBizException {
        FMVerifyHelper.checkBlank(ctx, vo, name);
        Object value = vo.get(name);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.signum() <= 0) {
                String alias = FMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
                throw new FMException(FMException.MUSTMORETHANZERO, new Object[]{alias});
            }
        } else {
            String alias = FMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
            throw new FMException(FMException.FIELDNOTBIGDECIMAL, new Object[]{alias});
        }
    }

    public static void checkNotLessThanZero(Context ctx, IObjectValue vo, String name) throws EASBizException {
        FMVerifyHelper.checkBlank(ctx, vo, name);
        Object value = vo.get(name);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.signum() < 0) {
                String alias = FMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
                throw new FMException(FMException.MUSTNOTLESSTHANZERO, new Object[]{alias});
            }
        } else {
            String alias = FMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
            throw new FMException(FMException.FIELDNOTBIGDECIMAL, new Object[]{alias});
        }
    }

    public static void checkDateFromBeforeDateTo(Context ctx, IObjectValue vo, String dateFrom, String dateTo) throws EASBizException {
        Date fromDate = vo.getDate(dateFrom);
        Date toDate = vo.getDate(dateTo);
        String aliasFrom = FMVerifyHelper.getEntityFieldAlias(ctx, vo, dateFrom);
        String aliasTo = FMVerifyHelper.getEntityFieldAlias(ctx, vo, dateTo);
        if (!fromDate.before(toDate)) {
            throw new FMException(FMException.DATEFROMMUSTBEFORETO, new Object[]{aliasFrom, aliasTo});
        }
    }

    public static void throwNotSame(Context ctx, IObjectValue val, String name) throws EASBizException {
        String alias = FMVerifyHelper.getEntityFieldAlias(ctx, val, name);
        FMVerifyHelper.checkBlank(val, (Object[])new String[]{alias});
        throw new FMException(FMException.ATTRINOTSAME, new String[]{alias});
    }

    private static void checkMsg(Context ctx, IObjectValue vo, String name, Object val) throws EASBizException {
        String alias = FMVerifyHelper.getEntityFieldAlias(ctx, vo, name);
        FMVerifyHelper.checkBlank(val, (Object[])new String[]{alias});
    }

    private static String getEntityFieldAlias(Context ctx, IObjectValue vo, String name) {
        IMetaDataLoader loader = null;
        loader = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx) : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(vo.getBOSType());
        PropertyInfo property = entity.getPropertyByName(name);
        String alias = null;
        if (property != null) {
            alias = property.getAlias();
        }
        return alias;
    }

    public static void checkBlank(int o1, Object[] args) throws EASBizException {
        if (o1 == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(String o1, Object[] args) throws EASBizException {
        if (o1 == null || o1.trim().length() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkBlank(Object[] o1, Object[] args) throws EASBizException {
        if (o1 == null || o1.length == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, args);
        }
    }

    public static void checkProperties(IObjectValue info, String[] properties) throws EASBizException {
        if (info == null) {
            String msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"160_FMIsqlUIHandler"), Arrays.asList(properties));
            throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msgStr});
        }
        if (properties == null || properties.length == 0) {
            return;
        }
        for (String aPropertyName : properties) {
            FMVerifyHelper.checkProperty(info, aPropertyName);
        }
    }

    public static void checkProperties(IObjectCollection infos, String[] properties) throws EASBizException {
        if (infos == null || infos.size() == 0) {
            return;
        }
        if (properties == null || properties.length == 0) {
            return;
        }
        int m = infos.size();
        for (int j = 0; j < m; ++j) {
            IObjectValue info = infos.getObject(j);
            for (String aPropertyName : properties) {
                FMVerifyHelper.checkProperty(info, aPropertyName);
            }
        }
    }

    public static void checkProperty(IObjectValue info, String propertyName) throws EASBizException {
        if (info == null) {
            String msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"161_FMIsqlUIHandler"), propertyName);
            throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msgStr});
        }
        if (propertyName == null) {
            return;
        }
        int dotIdx = propertyName.indexOf(".");
        if (dotIdx > -1) {
            String oneLevelPropertyName = propertyName.substring(0, dotIdx);
            String twoLevelPropertyName = propertyName.substring(dotIdx + 1);
            FMVerifyHelper.checkProperty((IObjectValue)info.get(oneLevelPropertyName), twoLevelPropertyName);
        } else {
            Object value = info.get(propertyName);
            if (value == null) {
                String msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"161_FMIsqlUIHandler"), propertyName);
                throw new FMException(FMException.COMMMONEXCEPTION, new String[]{msgStr});
            }
        }
    }
}

