/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger logger = CoreUIObject.getLogger(FileUtils.class);

    public static String readFileContent(String filePathAndName) throws IOException {
        return FileUtils.readFileContent(filePathAndName, null, null, 1024);
    }

    public static String readFileContent(String filePathAndName, String encoding) throws IOException {
        return FileUtils.readFileContent(filePathAndName, encoding, null, 1024);
    }

    public static String readFileContent(String filePathAndName, int bufLen) throws IOException {
        return FileUtils.readFileContent(filePathAndName, null, null, bufLen);
    }

    public static String readFileContent(String filePathAndName, String encoding, String sep) throws IOException {
        return FileUtils.readFileContent(filePathAndName, encoding, sep, 1024);
    }

    public static String readFileContent(String filePathAndName, String encoding, String sep, int bufLen) throws IOException {
        if (filePathAndName == null || filePathAndName.equals("")) {
            return "";
        }
        if (sep == null || sep.equals("")) {
            sep = "\n";
        }
        if (!new File(filePathAndName).exists()) {
            return "";
        }
        StringBuffer str = new StringBuffer("");
        FileInputStream fs = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fs = new FileInputStream(filePathAndName);
            isr = encoding == null || encoding.trim().equals("") ? new InputStreamReader(fs) : new InputStreamReader((InputStream)fs, encoding.trim());
            br = new BufferedReader(isr, bufLen);
            String data = "";
            while ((data = br.readLine()) != null) {
                str.append(data).append(sep);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
        return str.toString();
    }

    public static boolean newFile(String path, String fileName, StringBuffer content) throws IOException {
        return FileUtils.newFile(path, fileName, content, 1024, false);
    }

    public static boolean newFile(String path, String fileName, StringBuffer content, boolean isWrite) throws IOException {
        return FileUtils.newFile(path, fileName, content, 1024, isWrite);
    }

    public static boolean newFile(String path, String fileName, StringBuffer content, int bufLen, boolean isWrite) throws IOException {
        if (path == null || path.equals("") || content == null || content.toString().equals("")) {
            return false;
        }
        boolean flag = false;
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            fw = new FileWriter(path + File.separator + fileName, isWrite);
            bw = new BufferedWriter(fw, bufLen);
            bw.write(content.toString());
            flag = true;
        }
        catch (IOException e) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"72_FileUtils"));
            flag = false;
            throw e;
        }
        finally {
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
        return flag;
    }

    public static boolean newFile(String path, String fileName, String content) throws IOException {
        return FileUtils.newFile(path, fileName, content, 1024, false);
    }

    public static boolean newFile(String path, String fileName, String content, boolean isWrite) throws IOException {
        return FileUtils.newFile(path, fileName, content, 1024, isWrite);
    }

    public static boolean newFile(String path, String fileName, String content, int bufLen, boolean isWrite) throws IOException {
        if (path == null || path.equals("") || content == null || content.equals("")) {
            return false;
        }
        boolean flag = false;
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            fw = new FileWriter(path + File.separator + fileName, isWrite);
            bw = new BufferedWriter(fw, bufLen);
            bw.write(content);
            flag = true;
        }
        catch (IOException e) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"72_FileUtils"));
            flag = false;
            throw e;
        }
        finally {
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
        return flag;
    }

    public static boolean newFolder(String filePath) throws Exception {
        boolean flag = false;
        if (filePath == null || filePath.equals("") || filePath.equals("null")) {
            return flag;
        }
        File myFilePath = new File(filePath);
        if (!myFilePath.exists()) {
            myFilePath.mkdirs();
        }
        flag = true;
        return flag;
    }

    public static boolean copyFile(String oldPath, String newPath) throws IOException {
        return FileUtils.copyFile(oldPath, newPath, null);
    }

    public static boolean copyFile(String oldPath, String newPath, String newFileName) throws IOException {
        boolean flag = false;
        if (oldPath == null || newPath == null || newPath.equals("") || oldPath.equals("")) {
            return flag;
        }
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            int bytesum = 0;
            int byteread = 0;
            File file = null;
            file = new File(newPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file = new File(oldPath)).exists()) {
                inStream = new FileInputStream(oldPath);
                if (newFileName == null || newFileName.equals("")) {
                    newFileName = file.getName();
                }
                fs = new FileOutputStream(newPath + File.separator + newFileName);
                byte[] buffer = new byte[8192];
                while ((byteread = inStream.read(buffer)) != -1) {
                    logger.info((Object)(bytesum += byteread));
                    fs.write(buffer, 0, byteread);
                }
                flag = true;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return flag;
    }

    public static void copyFolder(String oldPath, String newPath) throws Exception {
        if (oldPath == null || newPath == null || newPath.equals("") || oldPath.equals("")) {
            return;
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            File temp = null;
            temp = new File(newPath);
            if (!temp.exists()) {
                temp.mkdirs();
            }
            temp = new File(oldPath);
            String[] file = temp.list();
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    input = new FileInputStream(temp);
                    output = new FileOutputStream(newPath + File.separator + temp.getName().toString());
                    byte[] b = new byte[8192];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                }
                if (!temp.isDirectory()) continue;
                FileUtils.copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i]);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    public static boolean Move(String srcFile, String destPath) {
        return FileUtils.Move(srcFile, destPath, null);
    }

    public static boolean Move(String srcFile, String destPath, String newFileName) {
        boolean flag = false;
        if (srcFile == null || srcFile.equals("") || destPath == null || destPath.equals("")) {
            return flag;
        }
        File file = new File(srcFile);
        File dir = new File(destPath);
        if (newFileName == null || newFileName.equals("") || newFileName.equals("null")) {
            newFileName = file.getName();
        }
        flag = file.renameTo(new File(dir, newFileName));
        return flag;
    }

    public static void moveFile(String oldPath, String newPath) throws Exception {
        if (FileUtils.copyFile(oldPath, newPath)) {
            FileUtils.delFile(oldPath);
        }
    }

    public static void moveFile(String oldPath, String newPath, String newFileName) throws Exception {
        if (FileUtils.copyFile(oldPath, newPath)) {
            FileUtils.delFile(oldPath);
        }
    }

    public static void moveFolder(String oldPath, String newPath) throws Exception {
        FileUtils.copyFolder(oldPath, newPath);
        FileUtils.delFolder(oldPath);
    }

    public static void delFile(String filePathAndName) {
        if (filePathAndName == null || filePathAndName.equals("") || filePathAndName.equals("null")) {
            return;
        }
        try {
            File myDelFile = new File(FilenameUtils.normalize((String)filePathAndName));
            if (myDelFile.exists()) {
                myDelFile.delete();
            }
        }
        catch (Exception e) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"73_FileUtils"));
        }
    }

    public static void delFolder(String folderPath) {
        if (folderPath == null || folderPath.equals("")) {
            return;
        }
        try {
            File myFilePath = new File(folderPath);
            if (myFilePath.isDirectory() && myFilePath.exists()) {
                FileUtils.delAllFile(folderPath);
                myFilePath.delete();
            }
        }
        catch (Exception e) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"74_FileUtils"));
        }
    }

    public static void delAllFile(String path) {
        if (path == null || path.equals("")) {
            return;
        }
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtils.delAllFile(path + File.separator + tempList[i]);
            FileUtils.delFolder(path + File.separator + tempList[i]);
        }
    }

    public static void del(String filepath) throws Exception {
        if (filepath == null || filepath.equals("") || filepath.equals("null")) {
            return;
        }
        File f = new File(filepath);
        if (f.exists() && f.isDirectory()) {
            if (f.listFiles().length == 0) {
                f.delete();
            } else {
                File[] delFile = f.listFiles();
                int i = f.listFiles().length;
                for (int j = 0; j < i; ++j) {
                    if (delFile[j].isDirectory()) {
                        FileUtils.del(delFile[j].getAbsolutePath());
                    }
                    delFile[j].delete();
                }
            }
            FileUtils.del(filepath);
        }
    }
}

