/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FmBatchCalculator
implements ICalculator,
IMethodBatchQuery {
    private static final Logger logger = CoreUIObject.getLogger(FmBatchCalculator.class);
    protected ICalculateContextProvider context;
    protected Context serverCtx = null;
    protected String reportCompanyNumber = null;
    protected String reportCurrencyNumber = null;
    protected Date reportBeginDate = null;
    protected Date reportEndDate = null;
    protected int periodYear;
    protected int periodNumber;
    protected int periodType;

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = context.getServerContext();
    }

    protected void initParams() {
        String reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
        try {
            this.reportCompanyNumber = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportCompanyId)).getNumber();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.reportCurrencyNumber = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        this.reportBeginDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        this.periodYear = (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
        this.periodNumber = (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
        this.periodType = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        RptPeriodTypeEnum type = RptPeriodTypeEnum.getEnum((int)this.periodType);
        if (this.reportBeginDate == null) {
            this.reportBeginDate = RPTDateUtil.getPeriodFirstDate((int)this.periodYear, (int)this.periodNumber, (RptPeriodTypeEnum)type);
        }
        if (this.reportEndDate == null) {
            this.reportEndDate = RPTDateUtil.getPeriodLastDate((int)this.periodYear, (int)this.periodNumber, (RptPeriodTypeEnum)type);
        }
    }

    public boolean batchQuery(Map methods) {
        this.initParams();
        return false;
    }
}

