/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class GenXML {
    private static final Logger logger = CoreUIObject.getLogger(GenXML.class);

    private GenXML() {
    }

    public static GenXML getInstant() {
        return new GenXML();
    }

    public Element getXML(Object o) {
        Element elem = null;
        elem = this.newInstant(null, o);
        this.serialObjectToXML(o, elem);
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serial(String file, Element elem) {
        Document docn = new Document(elem);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(docn, (OutputStream)outStream);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeStream(outStream);
        }
    }

    private void closeStream(FileOutputStream object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void serialObjectToXML(Object o, Element elem) {
        block4: {
            block3: {
                if (o == null) {
                    return;
                }
                if (!(o instanceof IObjectValue)) break block3;
                IObjectValue vo = (IObjectValue)o;
                Enumeration keys = vo.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    Object value = vo.get(key);
                    String cls = value.getClass().getName();
                    Element newelem = this.newInstant(key, value);
                    elem.getChildren().add(newelem);
                    this.serialObjectToXML(value, newelem);
                }
                break block4;
            }
            if (!(o instanceof IObjectCollection)) break block4;
            IObjectCollection coll = (IObjectCollection)o;
            for (int i = 0; i < coll.size(); ++i) {
                IObjectValue newO = coll.getObject(i);
                Element list = this.newInstant(null, newO);
                elem.getChildren().add(list);
                this.serialObjectToXML(newO, list);
            }
        }
    }

    private Element newInstant(String name, Object value) {
        Element elem = null;
        if (value instanceof IObjectValue) {
            elem = new Element("object");
        } else if (value instanceof IObjectCollection) {
            elem = new Element("list");
        } else {
            elem = new Element("property");
            elem.setAttribute("value", value.toString());
        }
        if (name != null) {
            elem.setAttribute("name", name);
        }
        elem.setAttribute("class", value.getClass().getName());
        return elem;
    }
}

