/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.VOPredicate;
import java.util.HashMap;
import java.util.Map;

public class HashSearchEngine
implements VOPredicate {
    private String[] destKeys;
    private Map map = null;
    private String[] srcKeys;
    private IObjectValue vo;

    public HashSearchEngine(IObjectCollection iObjCol, String[] keys) {
        this(keys);
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            this.add(iObjCol.getObject(i));
        }
    }

    public HashSearchEngine(IObjectValue[] coll, String[] keys) {
        this(keys);
        for (int i = 0; i < coll.length; ++i) {
            this.add(coll[i]);
        }
    }

    public HashSearchEngine(String[] keys) {
        this.srcKeys = keys;
        this.setDestKeys(keys);
        this.map = new HashMap();
    }

    public void add(IObjectValue iObjVal) {
        String keyString = FMHelper.getKeyString(iObjVal, this.srcKeys);
        if (this.map.containsKey(keyString)) {
            throw new IllegalArgumentException("key values is repeat" + keyString);
        }
        this.map.put(keyString, iObjVal);
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean evaluate(IObjectValue iter) {
        String key = FMHelper.getKeyString(iter, this.getDestKeys());
        this.vo = (IObjectValue)this.map.get(key);
        return this.vo != null;
    }

    public String[] getDestKeys() {
        return this.destKeys;
    }

    public Map getHashMap() {
        return this.map;
    }

    public IObjectValue getResult() {
        return this.vo;
    }

    public void remove(IObjectValue iObjVal) {
        String keyString = FMHelper.getKeyString(iObjVal, this.srcKeys);
        if (!this.map.containsKey(keyString)) {
            throw new IllegalArgumentException("key not found:" + keyString);
        }
        this.map.remove(keyString);
    }

    public void setDestKeys(String[] dstKeys) {
        this.destKeys = dstKeys;
    }

    public void cat(IObjectCollection coll) {
        for (IObjectValue info : this.map.values()) {
            coll.addObject(info);
        }
    }
}

