/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fm.common.DProviderSrv;
import com.kingdee.eas.fm.common.IRemoteTestRunner;
import com.kingdee.eas.fm.common.RemoteAssertionFailedError;
import com.kingdee.eas.fm.common.RemoteTestException;
import com.kingdee.eas.fm.common.RemoteTestRunnerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.log4j.Logger;

public class ServerTestCase
extends TestCase {
    private static Logger logger = Logger.getLogger(ServerTestCase.class);
    public Context ctx;
    public DProviderSrv data = null;
    public long methodRunTime;
    private boolean serverSide = false;

    public ServerTestCase(String arg) {
        super(arg);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.data = DProviderSrv.newInstance(this.ctx);
        this.methodRunTime = System.currentTimeMillis();
        logger.info((Object)("Begin: " + this.toString()));
    }

    protected void tearDown() throws Exception {
        logger.info((Object)("Time: " + (System.currentTimeMillis() - this.methodRunTime)));
        super.tearDown();
    }

    public void setContext(Context contx) {
        this.ctx = contx;
        DProviderSrv.newInstance(contx);
    }

    public Context getContext() {
        return this.ctx;
    }

    protected Connection getConnection() throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void run(TestResult result) {
        ClassLoader oldClassLoader = null;
        try {
            if (!this.isServerSide()) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
            super.run(result);
        }
        finally {
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public void runBare() throws Throwable {
        block6: {
            if (!this.isServerSide()) {
                IRemoteTestRunner testRunner = null;
                try {
                    testRunner = this.getEJBTestRunner();
                    testRunner.run(((Object)((Object)this)).getClass().getName(), this.getName());
                    break block6;
                }
                catch (RemoteTestException e) {
                    Throwable remote = e.getRemoteThrowable();
                    if (remote instanceof AssertionFailedError) {
                        throw new RemoteAssertionFailedError((AssertionFailedError)remote, e.getRemoteStackTrace());
                    }
                    throw e;
                }
            }
            super.runBare();
        }
    }

    public void setUpEJB() throws Exception {
    }

    public void tearDownEJB() throws Exception {
    }

    private IRemoteTestRunner getEJBTestRunner() throws Exception {
        return RemoteTestRunnerFactory.getRemoteInstance();
    }
}

