/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;

public class BatchFetcher {
    public FmRpcCacheInfo fetchData(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        FmRpcCacheInfo cacheInfo = (FmRpcCacheInfo)((Object)paramInfo.clone());
        CompanyOrgUnitInfo currentCompany = this.getCurrentCompany(ctx, paramInfo);
        cacheInfo.setCurrentCompany(currentCompany);
        cacheInfo.setAllCurrencyColl(this.getCurrencyCollection(ctx));
        cacheInfo.setHasCodeRule(this.hasNumber(ctx, cacheInfo.getBillInfo(), currentCompany.getId().toString()));
        cacheInfo.setNumber(this.getNumber(ctx, cacheInfo));
        cacheInfo.setClearHouse(this.getClearHouse(ctx, currentCompany.getId().toString()));
        cacheInfo.setCurPeriod(this.getCurPeriod(ctx, currentCompany));
        cacheInfo.setStartPeriod(this.getStartPeriod(ctx, currentCompany));
        CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany);
        cacheInfo.setCurrentCurrency(currency);
        boolean isClearingHourse = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString());
        cacheInfo.setClearingHouse(isClearingHourse);
        this.appendCacheValue(ctx, cacheInfo);
        return cacheInfo;
    }

    private PeriodInfo getStartPeriod(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
    }

    private PeriodInfo getCurPeriod(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
    }

    private BankInfo getClearHouse(Context ctx, String companyid) throws EASBizException, BOSException {
        return BankFactory.getLocalInstance((Context)ctx).getClearingHouse(companyid);
    }

    protected String getNumber(Context ctx, FmRpcCacheInfo cacheInfo) throws EASBizException, BOSException {
        String companyid = cacheInfo.getCurrentCompany().getId().toString();
        boolean rst = cacheInfo.isHasCodeRule();
        if (rst) {
            return this.getDispNumber(ctx, cacheInfo.getBillInfo(), companyid);
        }
        return null;
    }

    public boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.isExist((IObjectValue)info, companyId);
        return result;
    }

    private String getDispNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return number;
    }

    protected void appendCacheValue(Context ctx, FmRpcCacheInfo paramInfo) throws EASBizException, BOSException {
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
    }

    protected Boolean getSysParam(Context ctx, String paramName, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(this.getCurrentCompany(ctx, paramInfo).getId()));
        return new Boolean(val);
    }

    private CurrencyCollection getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filter);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        return iCurrency.getCurrencyCollection(view, true);
    }

    public FmRpcCacheInfo fetchData(Context ctx, FmRpcCacheInfo paramInfo, boolean ingoreNumberUseUp) throws BOSException, EASBizException {
        FmRpcCacheInfo cacheInfo = (FmRpcCacheInfo)((Object)paramInfo.clone());
        CompanyOrgUnitInfo currentCompany = this.getCurrentCompany(ctx, paramInfo);
        cacheInfo.setCurrentCompany(currentCompany);
        cacheInfo.setAllCurrencyColl(this.getCurrencyCollection(ctx));
        cacheInfo.setHasCodeRule(this.hasNumber(ctx, cacheInfo.getBillInfo(), currentCompany.getId().toString()));
        String number = "not getting number";
        try {
            number = this.getNumber(ctx, cacheInfo);
        }
        catch (EASBizException e) {
            if (e.getMessage().contains("\u987a\u5e8f\u53f7\u5df2\u7ecf\u7528\u5b8c")) {
                number = "number sequence has used up";
            }
            throw e;
        }
        cacheInfo.setNumber(number);
        cacheInfo.setClearHouse(this.getClearHouse(ctx, currentCompany.getId().toString()));
        cacheInfo.setCurPeriod(this.getCurPeriod(ctx, currentCompany));
        cacheInfo.setStartPeriod(this.getStartPeriod(ctx, currentCompany));
        CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany);
        cacheInfo.setCurrentCurrency(currency);
        boolean isClearingHourse = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString());
        cacheInfo.setClearingHouse(isClearingHourse);
        this.appendCacheValue(ctx, cacheInfo);
        return cacheInfo;
    }
}

